<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div data-ng-controller="exchClientsController as clientListCtrl" >
	<div data-ng-if="clientListCtrl.exexchClients && clientListCtrl.exexchClients.length != 0">
		<cv-grid cv-grid-options="clientListCtrl.gridOptions"></cv-grid>
	</div>
	<div data-ng-if="!clientListCtrl.exexchClients || clientListCtrl.exchClients.length == 0">
		<div class="horz-center">
			<h2><cv:msg key="label.noExchClients" bundle="exchange"/></h2>
			<div>
				<svg class="add-new-placeholder" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 160 200" xml:space="preserve">
					<path d="M121,167a5,5,0,0,0,5-5V38a5,5,0,0,0-5-5H39a5,5,0,0,0-5,5V162a5,5,0,0,0,5,5h82ZM44.8,53.3h70.4v3H44.8v-3Zm0,12h70.4v3H44.8v-3Zm0,12h70.4v3H44.8v-3Zm0,12h70.4v3H44.8v-3ZM72,134.8a8,8,0,1,1,8,8A8,8,0,0,1,72,134.8Z"/>
				</svg>
			</div>
			<div>
				<span class="uib-dropdown" uib-dropdown>
					<a class="uib-dropdown-toggle" uib-dropdown-toggle>
						<p class="larger-font"><cv:msg key="label.addExchClient" bundle="exchange"/><span class="dropdownArrow right capps-setup"></span></p>
					</a>
					<ul uib-dropdown-menu class="capps-setup">
		                <li>
		                    <a href="" data-ng-click="clientListCtrl.addDAGClient()"><cv:msg key="label.clientType.DAG" bundle="exchange"/></a>
		                </li>
		                <li>
		                    <a href="" data-ng-click="clientListCtrl.addMBClient()"><cv:msg key="label.clientType.Mailbox" bundle="exchange"/></a>
		                </li>
		            </ul>
				</span>
				<!-- <a href="" data-ng-click="clientListCtrl.addExchangeClient()"><cv:msg key="label.addExchClient" bundle="exchange"/></a>-->
			</div>
			<div>
                <a href="#/4"><cv:msg key="label.getClientDetails" bundle="exchange"/></a>
            </div>
		</div>
	</div>
</div>
