<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvEnum name="App.ExchangeVersion"></cv:cvEnum>
</script>
<div data-ng-controller="exchDbClientDetailsController as exchDbClientDetCtrl">
	<div class="row">
		<%-- This is the page message to display any error --%>
		<span class="server-message {{exchDbClientDetCtrl.pageMessage.type}}">{{exchDbClientDetCtrl.pageMessage.message}}</span>
	</div>
	<div class="row">
		<div class="col-md-12">
			<!--<cv-changename obj='exchDbClientDetCtrl.changeNameObj' service-method='changeServerName.do' class="float-left"></cv-changename> -->
			<h1 class="float-left" data-ng-show="exchDbClientDetCtrl.pageMessage.message==''"><cv:msg key="label.exchange.database" bundle="exchange" />
			<span data-ng-if="exchDbClientDetCtrl.isSnapBackupEnabled"><cv-help-component help-text="<cv:msg key="label.snapSubclients.help.text" bundle="exchange"/>"></cv-help-component></span></h1>
			<cv:comp name="show.delete"><span data-ng-if="exchDbClientDetCtrl.showEdit"><a href="" class="page-action-item"  data-ng-click="exchDbClientDetCtrl.deleteServer()"><cv:msg key="label.releaseLicense" bundle="exchange" /></a></span></cv:comp>
			<span data-ng-if="exchDbClientDetCtrl.details"><a href="" class="page-action-item"  data-ng-click="exchDbClientDetCtrl.serverJobs()"><cv:msg key="header.jobs" bundle="exchange" /></a></span>
		</div>
	</div>
	<div class="row">
		<div class="col-md-6">
			<!-- Begin General -->
				<cv-tile-component data-ac-id="dagDetails-header_general-exchange" data-title='<cv:msg key="header.general" bundle="exchange"/>' loader="(exchDbClientDetCtrl.clientName && !exchDbClientDetCtrl.showLoaderPseudoClientInfo)">
					<ul class="group list-style-secondary toggle-height">
						<li class="group">
							<span class="pageDetailColumn"><cv:msg key="label.clientName" bundle="exchange" /></span>
							<span class="pageDetailColumn" data-ng-bind="exchDbClientDetCtrl.changeNameObj.name"></span>
						</li>
						<li class="group">
							<span class="pageDetailColumn"><cv:msg key="label.adDomainName" bundle="exchange" /></span>
							<span class="pageDetailColumn" data-ng-bind="exchDbClientDetCtrl.pseudoClientDetails.nameServer"></span>
						</li>
					</ul>
					<div class="page-details-box-links" data-ng-show="exchDbClientDetCtrl.details && exchDbClientDetCtrl.pseudoClientDetails">
		                <a href="" data-ng-click="exchDbClientDetCtrl.showEditClientDialog()"><cv:msg key="action.edit" bundle="exchange" />
		                </a>
		            </div>
				</cv-tile-component>
			<!-- End General -->
			<!-- Begin Proxy Details -->
				<cv-tile-component data-ac-id="dagDetails-header_exch_proxy-exchange" data-title='<cv:msg key="header.exch.proxy" bundle="exchange"/>' loader="!exchDbClientDetCtrl.showLoaderPseudoClientInfo">
					<ul class="group list-style-secondary toggle-height">
						<li class="group" data-ng-show="exchDbClientDetCtrl.pseudoClientDetails.proxyDetail.useProxy">
							<span class="pageDetailColumn"><cv:msg key="label.proxyName" bundle="exchange" /></span>
							<span class="pageDetailColumn" data-ng-bind="exchDbClientDetCtrl.pseudoClientDetails.proxyDetail.proxyClientForDAGDiscovery.clientName"></span>
						</li>
						<li class="group" data-ng-show="exchDbClientDetCtrl.pseudoClientDetails.proxyDetail.useProxy">
							<span class="pageDetailColumn"><cv:msg key="label.proxy.dag.discovery" bundle="exchange" /></span>
							<!--  <span class="pageDetailColumn" data-ng-if="exchDbClientDetCtrl.pseudoClientDetails.proxyDetail.useProxy == true"><cv:msg key="label.proxy.dag.discovery.on" bundle="exchange" /></span>
							<span class="pageDetailColumn" data-ng-if="exchDbClientDetCtrl.pseudoClientDetails.proxyDetail.useProxy == false"><cv:msg key="label.proxy.dag.discovery.off" bundle="exchange" /></span>-->
							<span class="pageDetailColumn">
	                            <toggle-control class="{{exchDbClientDetCtrl.useProxyForDagDisc}}" disabled="true" status="exchDbClientDetCtrl.useProxyForDagDisc" data-ng-click=""
	                            	title="<cv:msg key='tooltip.proxy.dag.discovery' bundle='exchange' />" data-ng-show="!exchDbClientDetCtrl.showLoaderPseudoClientInfo">
	                            </toggle-control>
	                        </span>
						</li>
						<li class="group">
							<span class="pageDetailColumn"><cv:msg key="label.dag.servers" bundle="exchange" /></span>
							<span class="pageDetailColumn" data-ng-bind="exchDbClientDetCtrl.pseudoClientDetails.dagSetup.dagName"></span>
						</li>
						<li class="group">
							<span class="pageDetailColumn"><cv:msg key="label.member.servers" bundle="exchange" /></span>
							<span class="pageDetailColumn exch-member-servers">
								<ul class="group list-style-secondary">
 									<li style="padding: 0 0 3px 0;" data-ng-repeat="srv in exchDbClientDetCtrl.formattedMemberServer | limitTo: exchDbClientDetCtrl.memberServerLimit">{{srv.text}}</li>
									<li style="padding: 0 0 3px 0;" data-ng-show="(exchDbClientDetCtrl.formattedMemberServer.length > 3) && (exchDbClientDetCtrl.memberServerLimit !== exchDbClientDetCtrl.formattedMemberServer.length)" class="tile-content-link">
 										<a href="" data-ng-click="exchDbClientDetCtrl.memberServerLimit = exchDbClientDetCtrl.formattedMemberServer.length"><cv:msg key="label.proxy.servers.more" bundle="exchange" /> (<cv:msg key="label.proxy.servers.count" bundle="exchange" /> {{exchDbClientDetCtrl.formattedMemberServer.length}})</a>
									</li>
								</ul>
							</span>
						</li>
						<li class="group">
							<span class="pageDetailColumn"><cv:msg key="label.exchangeVersion" bundle="exchange" /></span>
							<span class="pageDetailColumn" data-ng-bind="exchDbClientDetCtrl.selectedExchangeVersion"></span>
						</li>
					</ul>
					<div class="page-details-box-links" data-ng-show="exchDbClientDetCtrl.details && exchDbClientDetCtrl.pseudoClientDetails">
		                <a href="" data-ng-click="exchDbClientDetCtrl.showEditClientDialog()"><cv:msg key="action.edit" bundle="exchange" />
		                </a>
		            </div>
				</cv-tile-component>
			<!-- End Proxy Details -->
		</div>
		<div class="col-md-6">
			<!-- remove plan tile from agent level, since agent level plan is supported in adminconsole yet, have added plan in subclient level -->
			<%-- <cv-client-plan-component data-ng-if="exchDbClientDetCtrl.clientId" client-id="exchDbClientDetCtrl.clientId" plan-id="exchDbClientDetCtrl.planId"
			plan-entity="exchDbClientDetCtrl.planEntity" app-id="exchDbClientDetCtrl.appId"></cv-client-plan-component> --%>
			<!-- Begin Activity Control -->
				<cv-activity-control-component data-ac-params="exchDbClientDetCtrl.acParams"></cv-activity-control-component>
			<!-- End Activity Control -->
			<span data-ng-if="exchDbClientDetCtrl.formattedSecurityAssociations">
				<cv-security-component entity-type='exchDbClientDetCtrl.entityType' generic-entity='exchDbClientDetCtrl.genericEntity' associations='exchDbClientDetCtrl.formattedSecurityAssociations' associations-loaded='exchDbClientDetCtrl.associationsLoaded' data-show-Owners='true'>
				</cv-security-component>
			</span>
		</div>
	</div>
	<div class="row">
		<div class="col-md-12">
			<cv-grid cv-grid-options="exchDbClientDetCtrl.gridOptions"></cv-grid>
		</div>
	</div>
</div>