<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper">
	<div class="setup-title">
		<h1>{{addMbSerAccCtrl.title}}</h1>
	</div>
	<form name="addMbServiceAccountForm" novalidate class="form-horizontal"
		data-cv-submit="addMbSerAccCtrl.save()" autocomplete="off">
		<div class="modal-body">
			<div class="form-group" data-ng-if="addMbSerAccCtrl.canShowInfraStructure">
				<label for="serviceType" class="col-xs-12 col-md-4"><cv:msg
						key="label.serviceType" bundle="exchange" /></label>
				<div class="col-xs-12 col-md-8">
					<select name="serviceType" required	data-ng-model="addMbSerAccCtrl.model.serviceType">
						<option value="EXCHANGE_ONLINE" data-ng-if="addMbSerAccCtrl.model.environmentType !== 'EXCHANGE_ON_PREMISES'"><cv:msg key="label.needExchangeOnline" bundle="exchange"></cv:msg></option>
						<option value="SYSTEM_ACCOUNT" data-ng-if="addMbSerAccCtrl.model.environmentType === 'EXCHANGE_ONLINE_WITH_ONPREM_AD' || addMbSerAccCtrl.model.environmentType === 'EXCHANGE_ONLINE_ONLY'"><cv:msg key="label.localSystemAccount" bundle="exchange"></cv:msg></option>
						<option value="EXCHANGE_2007" data-ng-if="addMbSerAccCtrl.model.environmentType === 'EXCHANGE_ON_PREMISES' || addMbSerAccCtrl.model.environmentType === 'EXCHANGE_ONLINE_HYBRID'"><cv:msg key="label.exchange2007" bundle="exchange"></cv:msg></option>
						<option value="EXCHANGE_2010" data-ng-if="addMbSerAccCtrl.model.environmentType === 'EXCHANGE_ON_PREMISES' || addMbSerAccCtrl.model.environmentType === 'EXCHANGE_ONLINE_HYBRID'"><cv:msg key="label.exchange2010" bundle="exchange"></cv:msg></option>
						<option value="EXCHANGE_2013" data-ng-if="addMbSerAccCtrl.model.environmentType === 'EXCHANGE_ON_PREMISES' || addMbSerAccCtrl.model.environmentType === 'EXCHANGE_ONLINE_HYBRID'"><cv:msg key="label.exchange2013" bundle="exchange"></cv:msg></option>
						<option value="EXCHANGE_2016" data-ng-if="addMbSerAccCtrl.model.environmentType === 'EXCHANGE_ON_PREMISES' || addMbSerAccCtrl.model.environmentType === 'EXCHANGE_ONLINE_HYBRID'"><cv:msg key="label.exchange2016" bundle="exchange"></cv:msg></option>
						<option value="EXCHANGE_2019" data-ng-if="addMbSerAccCtrl.model.environmentType === 'EXCHANGE_ON_PREMISES' || addMbSerAccCtrl.model.environmentType === 'EXCHANGE_ONLINE_HYBRID'"><cv:msg key="label.exchange2019" bundle="exchange"></cv:msg></option>
					</select>
					<div class="help-block"
						data-ng-show="cv.addMbServiceAccountForm.needsAttention(addMbServiceAccountForm.serviceType)">
						<cv:msg key="error.selectServiceType" bundle="exchange" />
					</div>
				</div>
			</div>
			<div class="form-group"
				data-uib-collapse="addMbSerAccCtrl.model.serviceType !== 'EXCHANGE_ONLINE'">
				<label class="col-xs-12 col-md-4" for="exchangeAdminSmtpAddress"><cv:msg
						key="label.emailAddress" bundle="exchange"></cv:msg></label>
				<div class="col-xs-12 col-md-8">
					<input type="email" id="exchangeAdminSmtpAddress"
						name="exchangeAdminSmtpAddress"
						data-ng-model="addMbSerAccCtrl.model.exchangeAdminSmtpAddress"
						data-ng-pattern="addMbSerAccCtrl.REGEX.EMAIL"
						placeholder="<cv:msg key="label.emailAddressPlaceholder" bundle="exchange"></cv:msg>"
						data-ng-required="addMbSerAccCtrl.model.serviceType === 'EXCHANGE_ONLINE'" />
					<div class="help-block"
						data-ng-show="cv.addMbServiceAccountForm.needsAttention(addMbServiceAccountForm.exchangeAdminSmtpAddress)">
						<cv:msg key="error.noEmail" bundle="exchange" />
					</div>
				</div>
			</div>
			<div class="form-group" data-ng-if="addMbSerAccCtrl.model.serviceType !== 'EXCHANGE_ONLINE'">
				<label for="userName" class="col-xs-12 col-md-4"><cv:msg
						key="label.userName" bundle="exchange" /></label>
				<div class="col-xs-12 col-md-8">
					<input type="text" name="userName" id="userName"
						data-ng-model="addMbSerAccCtrl.model.userName"
						data-ng-pattern="addMbSerAccCtrl.REGEX.EXTERNAL_USERNAME_WITH_DOMAIN"
						data-ng-required="addMbSerAccCtrl.model.serviceType !== 'EXCHANGE_ONLINE'"
						placeholder="<cv:msg key="label.helptextDomain" bundle="serversJs"></cv:msg>\<cv:msg key="label.helpTextUsername" bundle="serversJs"></cv:msg>" />
					<div class="text-muted"
						data-ng-if="addMbSerAccCtrl.model.serviceType === 'EXCHANGE_ONLINE'">
						<cv:msg key="label.exchangeOnlineNote" bundle="exchange"></cv:msg>
					</div>
					<div class="help-block"
						data-ng-show="cv.addMbServiceAccountForm.needsAttention(addMbServiceAccountForm.userName)">
						<cv:msg key="error.noUserName" bundle="exchange" />
					</div>
				</div>
			</div>
			<div class="form-group">
				<label for="password" class="col-xs-12 col-md-4"><cv:msg
						key="label.password" bundle="exchange" /></label>
				<div class="col-xs-12 col-md-8">
					<input type="password" name="password" id="password"
						data-ng-model="addMbSerAccCtrl.model.password" required />
					<div class="help-block"
						data-ng-show="cv.addMbServiceAccountForm.needsAttention(addMbServiceAccountForm.password)">
						<cv:msg key="error.noPassword" bundle="exchange" />
					</div>
				</div>
			</div>
			<div class="form-group">
				<label for="confirmPassword" class="col-xs-12 col-md-4"><cv:msg
						key="label.confirmPassword" bundle="exchange" /></label>
				<div class="col-xs-12 col-md-8">
					<input type="password" name="confirmPassword" id="confirmPassword"
						data-ng-model="addMbSerAccCtrl.model.confirmPassword"
						data-cv-equals="{{addMbSerAccCtrl.model.password}}" required />
					<div class="help-block"
						data-ng-show="addMbServiceAccountForm.confirmPassword.$error.required && cv.addMbServiceAccountForm.needsAttention(addMbServiceAccountForm.confirmPassword)">
						<cv:msg key="error.noConfirmPassword" bundle="exchange" />
					</div>
					<div class="help-block"
						data-ng-show="!addMbServiceAccountForm.confirmPassword.$error.required && addMbServiceAccountForm.confirmPassword.$error.cvEquals && cv.addMbServiceAccountForm.needsAttention(addMbServiceAccountForm.confirmPassword)">
						<cv:msg key="error.mismatchedPassword" bundle="exchange" />
					</div>
				</div>
			</div>
			<div class="form-group" data-ng-if="addMbSerAccCtrl.model.serviceType !== 'EXCHANGE_ONLINE' && addMbSerAccCtrl.model.serviceType !== 'SYSTEM_ACCOUNT'">
				<div class="col-xs-12">
					<input type="checkbox" id="useStaticProfile"
						name="useStaticProfile"
						data-ng-model="addMbSerAccCtrl.useStaticProfile" data-ng-change="addMbSerAccCtrl.model.profileName = '';" /> <label
						for="useStaticProfile"><cv:msg
							key="label.useStaticProfile" bundle="exchange" /></label>
				</div>
			</div>
			<div class="form-group"
				data-uib-collapse="!addMbSerAccCtrl.useStaticProfile">
				<label class="col-xs-12 col-lg-4" for="profileName"><cv:msg
						key="label.profileName" bundle="exchange" /></label>
				<div class="col-xs-12 col-lg-8">
					<input data-ng-required="addMbSerAccCtrl.useStaticProfile"
						type="text" id="profileName" name="profileName"
						data-ng-model="addMbSerAccCtrl.model.profileName" />
					<div class="help-block"
						data-ng-show="cv.addMbServiceAccountForm.needsAttention(addMbServiceAccountForm.profileName)">
						<cv:msg key="error.invalidProfileName" bundle="exchange" />
					</div>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<button id="addServiceAccountModal_button_#5942" type="button" class="btn btn-default cvBusyOnAjax " 
				data-ng-click="addMbSerAccCtrl.cancel()">
				<cv:msg key="action.cancel" bundle="exchange" />
			</button>
			<button id="addServiceAccountModal_button_#9056" class="btn btn-primary cvBusyOnAjax" type="submit"> 
				<cv:msg key="action.save" bundle="exchange" />
			</button>
		</div>
	</form>
</div>