<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="form-horizontal bootstrap-wrapper no-padding">
	<span class="{{serverMessage.type}} serverMessage"
	data-ng-bind="serverMessage.message">
	</span>
	<form name="addInventoryForm"  autocomplete="off" novalidate data-cv-submit="">
		<div class="col-xs-12 col-md-9 col-lg-6 col-lg-offset-3">
			<div class="panel panel-default no-border">
				<div class="panel-body">
					<div class="form-group">
						<label class="col-xs-12 col-md-3 col-lg-3 padding-top-10" for="inventoryName">
							<cv:msg key="label.name" bundle="collections" />
						</label>
						<div class="col-xs-12 col-md-9 col-lg-9">
							<input type="text"
							id="inventoryName"
							name="inventoryName"
							data-ng-model="model.inventoryName" required autofocus data-ng-pattern="/^[A-Za-z0-9_\- ]*$/"
							ng-maxlength="50"
							/>
							<span class="help-block" data-ng-if="cv.addInventoryForm.needsAttention(addInventoryForm.inventoryName)"><cv:msg key="error.invalidInventoryName" bundle="ediscovery" /></span>
							<span class="help-block" data-ng-if="addInventoryForm.inventoryName.$error.pattern"><cv:msg key="error.invalidName" bundle="ediscovery" /></span>
							<span class="help-block" data-ng-if="addInventoryForm.inventoryName.$error.maxlength"><cv:msg key="error.maxlength" bundle="ediscovery" /></span>
						</div>
					</div>
					<div class="form-group">
						<label class="col-xs-12 col-md-3 col-lg-3">
							<cv:msg key="label.analyticsEngine" bundle="ediscovery" />
						</label>
						<div class="col-xs-12 col-md-9 col-lg-9">
							<isteven-multi-select
							directive-id="indexServers"
							input-model="model.analyticsEngines"
							output-model="model.analyticsEngine"
							button-label="engineName"
							item-label="engineName"
							selection-mode="single"
							tick-property="selected"
							translation="localLang"
							helper-elements="filter"
							search-property="engineName internalCloudName"
							min-search-length="1"
							is-required="true">
							</isteven-multi-select>
							<input type="text" ng-model="model.analyticsEngine" name="analyticsEngine" style="display:none" required />

							<span class="help-block" data-ng-if="cv.addInventoryForm.needsAttention(addInventoryForm.analyticsEngine) && addInventoryForm.analyticsEngine.$error.required">
								<i class="ion-alert-circled"></i>
								<cv:msg key="error.noIndexServer" bundle="profiles" />
							</span>
						</div>
					</div>
					<div class="form-group">
					<label class="col-xs-12 col-md-3 col-lg-3" for="nameServer"><cv:msg key="label.assets.nameserver" bundle="ediscovery" /></label>
					<div class="col-xs-11 col-md-9 col-lg-8">
						<isteven-multi-select
						  input-model="model.nameServerInputModel"
						  output-model="model.nameServerOutputModel"
						  button-label="connectName"
						  item-label="connectName"
						  tick-property="selected"
						  class="isteven-multi-select user-group-select"
						  helper-elements="all none reset filter"
						  max-labels="1"
						  translation="localLang"
						  disable-property="disabled">
						</isteven-multi-select>
					</div>
					<div class="col-xs-1 padding-top-10">
						<a>
							<span class="k-icon k-i-plus-outline cursor-pointer" data-ng-click="addNameServerWindow()"></span>
						</a>
					</div>
				</div>
				</div>
			</div>
		</div>
		<div class="cv-wizard-default-actions add-alert-wizard-actions row">
			<div class="col-xs-12">
				<div class="col-xs-3 col-xs-offset-9 col-md-2 col-md-offset-10">
					<cv-wizard-button data-cv-type="finish" data-cv-label='<cv:msg key="label.add" bundle="ediscovery" />'>
					</cv-wizard-button>
				</div>
			</div>
		</div>
	</form>
</div>

