<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
</script>
<div id="customProjectReport" data-ng-controller = "projectController as project">
	<h1 class="page-title">
		<span>{{project.clientName}}</span>
	</h1>
	<%-- Display details if the client details are loaded from the API --%>
	<div id="detailsArea" data-ng-if="($state.is('projectDetails') || $state.is('analyticsDetails')) && project.clientName">
		<div id="projectDetails" data-ng-controller="projectDetailsController as details">
			<div class="row">
				<div class="col-md-6">
					<cv-tile-component data-ac-id="casemanagerDetails-label_configuration-ediscovery" title='<cv:msg key="label.configuration" bundle="ediscovery"/>'>
						<ul class="list-style-secondary">
							<li class="group">
								<span class="pageDetailColumn">
									<cv:msg key="label.plan" bundle="ediscovery" />
								</span>
								<a
									class="pageDetailColumn" data-ng-href="#/profileDetails/{{details.clientInfo.plan.planId}}">{{details.clientInfo.plan.planName}}</a>
							</li>
							<li class="group">
								<span class="pageDetailColumn">
									<cv:msg key="label.inventorymanager.name" bundle="ediscovery" />
								</span>
								<a
									class="pageDetailColumn" data-ng-href="#/inventoryManager/{{details.clientInfo.inventoryDataSource.seaDataSourceId}}">{{details.clientInfo.inventoryDataSource.seaDataSourceName}}</a>
							</li>
							<li class="group">
								<span class="pageDetailColumn">
									<cv:msg key="label.analyticsEngine" bundle="ediscovery" />
								</span>
								<span
									class="pageDetailColumn">{{details.clientInfo.indexServer.clientName}}</span>
							</li>
							<li class="group">
								<span class="pageDetailColumn">
									<cv:msg key="label.contentAnalyzer" bundle="ediscovery" />
								</span>
								<span
									class="pageDetailColumn">{{details.clientInfo.contentAnalyzerCloud.cloudName}}</span>
							</li>
							<li class="group">
								<span class="pageDetailColumn">
									<cv:msg key="label.schedule" bundle="ediscovery" />
								</span>
								<span class="pageDetailColumn" data-ng-if="details.clientName">
									<schedule entity-id="details.genericEntity.clientId" entity-type="details.entityType" entity-name="details.clientName" />
								</span>
							</li>
						</ul>
					</cv-tile-component>
				</div>
				<div class="col-md-6">
					<cv-ds-security-component entity-type='details.entityType' generic-entity = 'details.genericEntity' associations='details.formattedSecurityAssociations' associations-loaded='details.associationsLoaded' data-show-Owners='false' >
					</cv-ds-security-component>
				</div>
			</div>
			<view-tabs view-tabs="details.viewTabs" selected-tab="details.selectedTab"></view-tabs>
			<div data-ng-if="details.selectedTab === 'dataSources'" id="dataSourcesGrid" data-ng-controller="dataSourcesGridController">
				<cv-kendo-grid data-cv-grid-options="dataSourceGridOptions"></cv-kendo-grid>
			</div>
			<div data-ng-if="details.selectedTab === 'requests'" id="taskDetails" data-ng-controller="TaskManagerController as TaskManagerCtrl">
				<cv-kendo-grid data-cv-grid-options="TaskManagerCtrl.gridOptions"></cv-kendo-grid>
			</div>
		</div>
	</div>
	<%-- Display reports if the client details are loaded from the API --%>
	<div id="reportArea" data-ng-if="($state.is('projectReport') || $state.is('analyticsReport')) && project.clientName">
		<%-- Reports controller to manage report IDs --%>
		<div data-ng-controller="projectReportController">
			<span class="{{serverMessage.type}} serverMessage" data-ng-bind="serverMessage.message"></span>
			<%-- Dashboard for Sensitive data analysis --%>
			<div data-ng-if="$state.is('projectReport') && viewsLoaded">
				<cv-report-view-selector view-groups="gdprViews" context-path="'${pageContext.request.contextPath}'"></cv-report-view-selector>
			</div>
			<%-- Dashboard for Analytics --%>
			<div data-ng-if="$state.is('analyticsReport') && viewsLoaded">
				<cv-report-view-selector view-groups="analyticsViews" context-path="'${pageContext.request.contextPath}'"></cv-report-view-selector>
			</div>
		</div>
	</div>
</div>