<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.userPermissions"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<h2 class="page-title"><cv:msg key="label.userPermissions" bundle="ediscovery" /></h2>

<div class="permission-report-content form-horizontal" data-ng-if="!permCtrl.noDataSourcesConfigured">
	<cv-permission-input on-input-applied="permCtrl.inputApplied(clientId)"/>
	<div class="entitlement-manager-filter-container">
	</div>
</div>

<div data-ng-if="!permCtrl.clientId" class="horz-center">
	<div data-ng-include="appUtil.appRoot + 'ediscovery/analytics/img/client.svg'">
	</div>
	<h3>{{ 'error.noClientSelected' | cvLoc}}</h3>
</div>

<div class="permissions-grid panel" data-ng-show="permCtrl.clientId">
	<div class="directory-tree-wrapper">
		<cv-file-filter on-search = "permCtrl.fileSearch(fileName)" placeholder='<cv:msg key="message.fileSearch.placeholder" bundle="userPermissions"/>' filter-control="permCtrl.fileFilterControlObj" data-ng-if="false"/>
		<cv-directory-tree client ="permCtrl.client" filters="permCtrl.filters" on-node-selected="permCtrl.nodeSelected(node)"/>
	</div>
	<div class="permissions-panel">
		<div data-ng-if="!permCtrl.url" class="file-no-selection">
			<h4 data-ng-bind-html="permCtrl.userMessage"></h4>
		</div>
		<div data-ng-show="permCtrl.url">
			<div class="padding-top-10 break-all-text">
				<h5 ng-bind-html="permCtrl.urlFormatString"></h5>
				</div>
			<div class="current-owner-wrapper" data-ng-if="permCtrl.currentOwner && permCtrl.currentOwner.length > 0">
				<span class="owner-label"><cv:msg key="label.owner" bundle="userPermissions" />:</span>
				<span data-ng-bind="permCtrl.currentOwner" title="{{permCtrl.currentOwner}}" class="owner-detail"></span>
				<span class="k-icon k-i-edit change-owner" data-ng-click="permCtrl.changeFileOwner()" title='<cv:msg key="label.changeOwner.change" bundle="userPermissions" />'></span>
			</div>
			<uib-tabset active="permCtrl.activeTab">
				<uib-tab heading='<cv:msg key="label.permissions" bundle="userPermissions"/>' select="permCtrl.getPermissionsInfo()" index="0">
					<div class="permissions-grid-container">
	                </div>
				</uib-tab>
				<uib-tab heading='<cv:msg key="heading.activities" bundle="userPermissions"/>' select="permCtrl.getActivitiesInfo()" index="1">
					<div class="activities-grid-container">
                    </div>
				</uib-tab>
				<uib-tab heading='<cv:msg key="heading.monitoring" bundle="userPermissions"/>' index="2" select="permCtrl.showFileMonitoring ( )" data-ng-if="permCtrl.enableNetappMonitoring">
					<div class="entitlement-manager-file-monitoring-container">
					</div>
				</uib-tab>
			</uib-tabset>
		</div>
	</div>
	<div class="vertical-gutter">
	</div>
</div>
