<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.userPermissions"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<form name="permissionsChangeFileOwnerForm" class="bootstrap-wrapper form-horizontal permissionsChangeFileOwnerModal" novalidate autocomplete="off">
	<div class="setup-title">
		<h1>
			<cv:msg key="title.changeOwner" bundle="userPermissions" />
		</h1>
	</div>
	<div class="modal-body">
	<div class="padding-top-10 break-all-text">
		<span class="permissions-url" ng-bind-html="permChgCtrl.url_str"></span>
	</div>
	<div class="padding-top-20">
		<cv-select-2 output-model="permChgCtrl.newOwner" search-options="permChgCtrl.config" ng-disabled="permChgCtrl.showOk || permChgCtrl.showInProgress"  ></cv-select-2>
	</div>
	<div class="padding-top-20" data-ng-if="permChgCtrl.newOwner &&  permChgCtrl.newOwner.loginName && permChgCtrl.newOwner.loginName.length > 0">
		<table class="table">
			<thead>
				<th><cv:msg key="label.currentOwner" bundle="userPermissions" /></th>
				<th><cv:msg key="label.ownerChanged.to" bundle="userPermissions" /></th>
			</thead>
			<tbody>
				<td>{{permChgCtrl.currentOwner}}</td>
				<td>{{permChgCtrl.newOwner.loginName}}</td>
			</tbody>
		</table>
	</div>
	<div data-ng-if="permChgCtrl.showInProgress">
		<img src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
			<cv:msg key="message.apply.ownership" bundle="userPermissions" />
	</div>
	<div class="serverMessage margin-top-20" data-ng-class="permChgCtrl.isError ? 'error-no-permissions' : 'jobCompleted'" data-ng-if="permChgCtrl.showMessage" ng-bind-html="permChgCtrl.serverMessage"></div>
	</div>
	<div class="modal-footer">
		<button id="permissionsChangeFileOwnerModal_button_#1591" type="button" class="btn btn-default cvBusyOnAjax" 
			data-ng-click="permChgCtrl.cancel()"  data-ng-hide="permChgCtrl.showOk">
			<cv:msg key="action.cancel" bundle="profiles"/>
		</button>
		<button id="permissionsChangeFileOwnerModal_button_#6185" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-click="permChgCtrl.change()"  data-ng-hide="permChgCtrl.showOk" data-ng-disabled="permChgCtrl.showInProgress"> 
			<cv:msg key="label.changeOwner.change" bundle="userPermissions"/>
		</button>
		<button id="permissionsChangeFileOwnerModal_button_#2710" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="permChgCtrl.ok()" data-ng-show="permChgCtrl.showOk"> 
			<cv:msg key="action.ok" bundle="userPermissions" />
		</button>
	</div>
</form>