<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.userPermissions"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<form name="permissionsAddNewUserForm" class="bootstrap-wrapper form-horizontal permissions-add-newUser-container" novalidate autocomplete="off">
	<div class="setup-title">
		<h1>
			<cv:msg key="message.addUser" bundle="userPermissions" />
		</h1>
	</div>
	<div class="modal-body">
		<div class="padding-top-10 break-all-text">
			<span class="permissions-url" ng-bind-html="permANUCtrl.url_str"></span>
		</div>
		<div class="padding-top-20">
			<cv-select-2 output-model="permANUCtrl.newUser" search-options="permANUCtrl.config" ng-disabled="permANUCtrl.showOk || permANUCtrl.showInProgress"  ></cv-select-2>
			<span class="cv-help-block" data-ng-show="permANUCtrl.noUserSelected" ><cv:msg key="error.userName" bundle="servers"/></span>
		</div>
		<div class="margin-top-50" data-ng-if="permANUCtrl.newUser">
			<table class="table table-striped permissionDetail">
				<thead>
					<tr>
						<th>
							<h5 class="font-weight-bold">
								<cv:msg key="label.permissions" bundle="userPermissions"/> <cv:msg key="message.friendlyText_for" bundle="userPermissions"/> {{permANUCtrl.newUserLoginName}}
							</h5>
						</th>
						<th>
							<h5 class="font-weight-bold">
								<cv:msg key="title.allow" bundle="userPermissions"/>
							</h5>
						</th>
						<th>
							<h5 class="font-weight-bold">
								<cv:msg key="title.deny" bundle="userPermissions"/>
							</h5>
						</th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td>
							<cv:msg key="title.fullcontrol" bundle="userPermissions"/>
						</td>
						<td class="padding-cell-edit-permissions padding-left-15">
							<input id="allow_fullcontrol" type="checkbox" ng-model="permANUCtrl.newPermissionsStruct.details.allow.fullcontrol" data-ng-change="permANUCtrl.permissionDependency('fullcontrol','allow',permANUCtrl.newPermissionsStruct)"/>
							<label for="allow_fullcontrol"></label>
						</td>
						<td class="padding-cell-edit-permissions padding-left-15">
							<input id="deny_fullcontrol" type="checkbox" ng-model="permANUCtrl.newPermissionsStruct.details.deny.fullcontrol" data-ng-change="permANUCtrl.permissionDependency('fullcontrol','deny',permANUCtrl.newPermissionsStruct)"/>
							<label for="deny_fullcontrol"></label>
						</td>
					</tr>
					<tr>
						<td>
							<cv:msg key="title.modify" bundle="userPermissions"/>
						</td>
						<td class="padding-cell-edit-permissions padding-left-15">
							<input id="allow_modify" type="checkbox" ng-model="permANUCtrl.newPermissionsStruct.details.allow.modify" data-ng-change="permANUCtrl.permissionDependency('modify','allow',permANUCtrl.newPermissionsStruct)"/>
							<label for="allow_modify"></label>
						</td>
						<td class="padding-cell-edit-permissions padding-left-15">
							<input id="deny_modify" type="checkbox" ng-model="permANUCtrl.newPermissionsStruct.details.deny.modify" data-ng-change="permANUCtrl.permissionDependency('modify','deny',permANUCtrl.newPermissionsStruct)"/>
							<label for="deny_modify"></label>
						</td>
					</tr>
					<tr>
						<td>
							<cv:msg key="title.readandexecute" bundle="userPermissions"/>
						</td>
						<td class="padding-cell-edit-permissions padding-left-15">
							<input id="allow_readandexecute" type="checkbox" ng-model="permANUCtrl.newPermissionsStruct.details.allow.read_execute" data-ng-change="permANUCtrl.permissionDependency('read_execute','allow',permANUCtrl.newPermissionsStruct)"/>
							<label for="allow_readandexecute"></label>
						</td>
						<td class="padding-cell-edit-permissions padding-left-15">
							<input id="deny_readandexecute" type="checkbox" ng-model="permANUCtrl.newPermissionsStruct.details.deny.read_execute" data-ng-change="permANUCtrl.permissionDependency('read_execute','deny',permANUCtrl.newPermissionsStruct)"/>
							<label for="deny_readandexecute"></label>
						</td>
					</tr>
					<tr>
						<td>
							<cv:msg key="title.read" bundle="userPermissions"/>
						</td>
						<td class="padding-cell-edit-permissions padding-left-15">
							<input id="allow_read" type="checkbox" ng-model="permANUCtrl.newPermissionsStruct.details.allow.read" data-ng-change="permANUCtrl.permissionDependency('read','allow',permANUCtrl.newPermissionsStruct)"/>
							<label for="allow_read"></label>
						</td>
						<td class="padding-cell-edit-permissions padding-left-15">
							<input id="deny_read" type="checkbox" ng-model="permANUCtrl.newPermissionsStruct.details.deny.read" data-ng-change="permANUCtrl.permissionDependency('read','deny',permANUCtrl.newPermissionsStruct)"/>
							<label for="deny_read"></label>
						</td>
					</tr>
					<tr>
						<td>
							<cv:msg key="title.write" bundle="userPermissions"/>
						</td>
						<td class="padding-cell-edit-permissions padding-left-15">
							<input id="allow_write" type="checkbox" ng-model="permANUCtrl.newPermissionsStruct.details.allow.write" data-ng-change="permANUCtrl.permissionDependency('write','allow',permANUCtrl.newPermissionsStruct)"/>
							<label for="allow_write"></label>
						</td>
						<td class="padding-cell-edit-permissions padding-left-15">
							<input id="deny_write" type="checkbox" ng-model="permANUCtrl.newPermissionsStruct.details.deny.write" data-ng-change="permANUCtrl.permissionDependency('write','deny',permANUCtrl.newPermissionsStruct)"/>
							<label for="deny_write"></label>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
		<div data-ng-if="permANUCtrl.showInProgress">
			<img src="${pageContext.request.contextPath}/common/img/ajax-loader.gif"/>
				<cv:msg key="message.newUser.save.progress" bundle="userPermissions" />
		</div>
		<div class="serverMessage" data-ng-class="permANUCtrl.isError ? 'error' : 'green-font'" data-ng-if="permANUCtrl.showMessage" ng-bind-html="permANUCtrl.serverMessage"></div>
	</div>
	<!--div class="add-user-btn-info">
		<p class="small"><cv:msg key="message.add.info" bundle="userPermissions"/></p>
	</div-->
	<div class="modal-footer add-user-modal-footer">
		<button id="permissionsAddNewUserModal_button_#4369" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="permANUCtrl.cancel()"  data-ng-hide="permANUCtrl.showOk">
			<cv:msg key="action.cancel" bundle="profiles"/>
		</button>
		<button id="permissionsAddNewUserModal_button_#4567" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="permANUCtrl.add()"  data-ng-hide="permANUCtrl.showOk" data-ng-disabled="permANUCtrl.showInProgress">
			<cv:msg key="action.add" bundle="profiles"/>
		</button>
		<button id="permissionsAddNewUserModal_button_#0856" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="permANUCtrl.ok()" data-ng-show="permANUCtrl.showOk">
			<cv:msg key="action.ok" bundle="userPermissions" />
		</button>
	</div>
</form>