<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div id="customInventoryReport" data-ng-controller = "inventoryDetailsController">
	<div id="inventoryHeader">
		<h1 class="page-title">
			<span data-ng-bind="inventoryDetails.inventoryName" data-ng-show="serverMessage.message==''"></span> 
			<span data-ng-bind="serverMessage.message"></span>
		</h1>
		<span class="margin-left-10" data-ng-if="showJobRunningMsg">
			<span class="spinner-sm inline-block vertical-middle"></span>
			<span class="margin-left-5"><cv:msg key="label.assets.dataCollectionJobRunning" bundle="ediscovery" /></span>
		</span>
		<a data-ng-if="showJobRunningMsg" data-ng-click="refreshReport()" class="page-action-item" title="<cv:msg key='CustomReport.Refresh' bundle='ReportsPlusMessages'/>"><cv:msg key='CustomReport.Refresh' bundle='ReportsPlusMessages'/></a>
	</div>
	
	<div id="reportArea" ng-if="$state.is('inventoryReport')">
		<div id="ng-app" data-ng-app="reports" data-ng-controller="reportsCtrl" data-ng-init="init(null, 'CA Inventory Dashboard')">
			<div id="pageDiv" data-ng-controller="pageController" class="maskLayer" data-ng-class="{'isMasked':masked}" >
				<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/viewerPage.jsp'"></div>
			</div>
		</div>
	</div>
	<div id="detailsArea" ng-if="$state.is('inventoryDetails')">
		<div class="row">
			<div class="col-md-6">
				<cv-tile-component data-ac-id="inventoryDetails-label_configuration-ediscovery" 			title='<cv:msg key="label.configuration" bundle="ediscovery"/>'>
				<ul class="list-style-secondary">
					
					<li class="group"><span class="pageDetailColumn"><cv:msg
								key="label.analyticsEngine" bundle="ediscovery" /></span> <span
						class="pageDetailColumn">{{inventoryDetails.analyticsEngineCloud.cloudDisplayName}}</span></li>
					<li class="group"><span class="pageDetailColumn"><cv:msg
								key="label.createdOn" bundle="ediscovery" /></span> <span
						class="pageDetailColumn">{{(inventoryDetails.createDateTime !=null) ? (inventoryDetails.createDateTime * 1000 | date:"hh:mm a on MMMM dd, yyyy") : ""}}</span></li>
					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="label.schedule" bundle="ediscovery" /></span>
						<span class="pageDetailColumn" data-ng-if="inventoryDetails.inventoryName">
							<schedule entity-id="inventoryId" entity-type="entityType" entity-name="inventoryDetails.inventoryName" />
						</span>
					</li>
				</ul>
				</cv-tile-component>
			</div>
			<div class="col-md-6">
				<cv-ds-security-component entity-type='entityType' generic-entity = 'genericEntity' associations='formattedSecurityAssociations' associations-loaded='associationsLoaded'>
				</cv-ds-security-component>
			</div>
		</div>
		<cv-kendo-grid data-cv-grid-options="inventoryAssetsGridOptions"></cv-kendo-grid>
	</div>
</div>