<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="label.inventorymanager.add" bundle="ediscovery" />
	</h1>
</div>
<div class="setup-content medium-width" data-ng-controller="complianceSetupController">
	<span class="{{serverMessage.type}} serverMessage"
		data-ng-bind="serverMessage.message"></span>
	<div class="bootstrap-wrapper form-horizontal">
		<form name="addInventoryForm"
			cv-hide-api data-cv-submit="createInventory()" autocomplete="off"
			class="edit-users-grid-form">
		<div class="panel panel-default">
		<div class="panel-body">
		<div class="form-group">
			<label class="col-xs-12 col-md-3 col-lg-3" for="name"><cv:msg key="label.name" bundle="collections" /></label>
			<div class="col-xs-12 col-md-9 col-lg-9">
				<input type="text"
						id="name"
						name="name"
						data-ng-model="selectedInventoryName" required autofocus data-ng-pattern="/^[A-Za-z0-9_\- ]*$/"
						ng-maxlength="50"
						data-ng-class="{'has-error': cv.addInventoryForm.needsAttention(addInventoryForm.name)}" />
					<span class="help-block" data-ng-show="addInventoryForm.name.$error.pattern"><cv:msg key="error.invalidName" bundle="ediscovery" /></span>
					<span class="help-block" data-ng-show="addInventoryForm.name.$error.maxlength"><cv:msg	key="error.maxlength" bundle="ediscovery" /></span>
			</div>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-md-3 col-lg-3" for="analyticsEngine"><cv:msg key="label.analyticsEngine" bundle="ediscovery" /></label>
			<div class="col-xs-12 col-md-9 col-lg-9">
					<select required
							id="analyticsEngine"
							name="analyticsEngine"
							data-ng-model="selectedAnalyticsEngine"
							data-ng-options="analyticsEngine.engineName for analyticsEngine in analyticsEngines"
							data-ng-class="{'has-error': cv.addServerPLanForm.needsAttention(addServerPLanForm.analyticsEngine)}">
						<option value=""><cv:msg key="placeholder.selectAnalyticsEngine" bundle="ediscovery" /></option>
					</select>
			</div>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-md-3 col-lg-3" for="nameServer"><cv:msg key="label.assets.nameserver" bundle="ediscovery" /></label>
			<div class="col-xs-12 col-md-9 col-lg-9">
							<isteven-multi-select
				   				  input-model="nameServers"
				   				  output-model="selectedNameServers"
				  				  button-label="connectName"
				  				  item-label="connectName"
				   				  tick-property="ticked"
				   				  class="isteven-multi-select user-group-select"
				   				  id="nameServer"
				   				  name="nameserver"
				   				  helper-elements="all none reset filter"
				   				  max-labels="1"
				   				  translation="nameServerText"
				   				  disable-property="disabled"
				   				  on-item-click="validateGroupSelection()"
				   				  on-select-none="validateGroupSelection()"
				   				  on-select-all="validateGroupSelection()"
				   				  on-reset="validateGroupSelection()">
							</isteven-multi-select>
							<span class="help-block" data-ng-show="showNameServerErrorMessage"><cv:msg key="selectNameServer" bundle="messages" /></span>
			</div>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-md-3 col-lg-3">&nbsp;</label>
			<div class="col-xs-12 col-md-9 col-lg-9 text-right">
				<a data-ng-click="addNameServerWindow()"><cv:msg key="label.createNameServer" bundle="ediscovery" /></a>
			</div>
		</div>
		</div></div>
			<div class="button-container">
					<button id="gettingStartedInventory_button_#4717" type="button" 
						class="btn btn-default cvBusyOnAjax setup-btn--hidden"
						data-ng-click="cancel()">
						<cv:msg key="Cancel" bundle="messages" />
					</button>
					<button id="gettingStartedInventory_button_#6133" type="submit" class="btn btn-primary cvBusyOnAjax"> 
						<cv:msg key="Save" bundle="messages" />
					</button>
			</div>
		</form>
	</div>
</div>
