<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="label.assets.database.connectionDetails"
			bundle="ediscovery" />
	</h1>
</div>
<div class="setup-content">
	<div class="{{generalSetupMessage.type}} serverMessage">{{generalSetupMessage.message}}</div>
</div>
<div
	class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2 bootstrap-wrapper">
	<div class="row ng-scope">
		<div class="col-md-12">
			<div class="panel panel-default">
				<div class="panel-body">
					<div class="form-group">
						<label class="col-xs-12 col-md-3 col-lg-3" for="databaseAssetName"><cv:msg
								key="label.name" bundle="ediscovery" /></label>
						<div class="col-xs-12 col-md-9 col-lg-9">
							<input id="databaseAssetName" type="text"
								name="databaseAssetName" data-ng-model="databaseAssetInfo.name"
								required autofocus />
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="row ng-scope">
		<div class="col-md-12">
			<cv-tile-component data-ac-id="label_assets_database_selectDatabase-ediscovery" 				data-title='<cv:msg key="label.assets.database.selectDatabase" bundle="ediscovery"/>'>
			<div class="panel panel-default no-border">
				<div class="panel-body">
					<div class="form-group">
						<div class="component-container">
							<div class="content-wrapper">
								<label for="commcellDatabase" class="radio-label"> <input
									id="commcellDatabase" type="radio" name="commcellDatabase"
									data-ng-value="true"
									data-ng-model="databaseAssetInfo.isCommcell"
									data-ng-change="onCommcellDatabaseSelection(true)" />
								<cv:msg key="label.assets.database.commcellDatabase"
										bundle="ediscovery" />
								</label> <label for="otherDatabase"
									class="radio-label parent-radio-need-margin"> <input
									id="otherDatabase" type="radio" name="otherDatabase"
									data-ng-value="false"
									data-ng-model="databaseAssetInfo.isCommcell"
									data-ng-change="onCommcellDatabaseSelection(false)" />
								<cv:msg key="label.assets.database.otherDatabase"
										bundle="ediscovery" />
								</label>
							</div>
						</div>
						<!-- Commcell database selection -->
						<div class="form-group "
							data-ng-if="databaseAssetInfo.isCommcell == true">
							<label class="col-xs-12 col-md-3 col-lg-3" for="selectedCommcell"><cv:msg
									key="label.assets.database.commcell" bundle="ediscovery" /></label>
							<div class="col-xs-12 col-md-9 col-lg-9">
								<select id="selectedCommcell" name="selectedCommcell"
									data-ng-model="databaseAssetInfo.selectedCommcell"
									data-ng-options="commcell as commcell.aliasName for commcell in databaseAssetInfo.commcellList"
									class="no-float-auto tile-large-width">
									<option value=""><cv:msg
											key="placeholder.assets.database.selectCommcell"
											bundle="ediscovery" /></option>
								</select>
							</div>
						</div>
						<!-- Commcell database selection -->
						<!-- Create a New Database -->
						<div name="databaseTypeForm"
							data-ng-if="databaseAssetInfo.isCommcell == false">
							<div class="form-group">
								<label class="col-xs-12 col-md-3 col-lg-3" for="databaseTypes"><cv:msg
										key="label.assets.database" bundle="ediscovery" /></label>
								<div class="col-xs-12 col-md-9 col-lg-9">
									<select id="databaseTypes" name="databaseTypes"
										data-ng-model="databaseAssetInfo.selectedDatabaseType"
										data-ng-options="database.name for database in databaseAssetInfo.databaseTypes"
										class="no-float-auto tile-large-width">
									</select>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			</cv-tile-component>
		</div>
	</div>
	<div class="row ng-scope" data-ng-if="databaseAssetInfo.isCommcell == false"">
		<div class="col-md-12">
			<cv-tile-component data-ac-id="label_assets_database_databaseDetails-ediscovery" 				data-title='<cv:msg key="label.assets.database.databaseDetails" bundle="ediscovery"/>'>
			<div class="panel panel-default no-border">
				<div class="panel-body">
					<div class="form-group">
						<!-- Create a New Database -->
							<!-- // Common for all types: user name password START //-->
							<div class="form-group">
								<label class="col-xs-12 col-md-3 col-lg-3" for="userName"><cv:msg
										key="label.userName" bundle="ediscovery" /></label>
								<div class="col-xs-12 col-md-9 col-lg-9">
									<input type="text" class="network-path" name=userName
										id="userName"
										data-ng-model="databaseAssetInfo.userName" required />
								</div>
							</div>
							<div class="form-group">
								<label class="col-xs-12 col-md-3 col-lg-3" for="password"><cv:msg
										key="label.password" bundle="ediscovery" /></label>
								<div class="col-xs-12 col-md-9 col-lg-9">
									<input type=password class="network-path" name=password
										id="password"
										data-ng-model="databaseAssetInfo.password" />
								</div>
							</div>
							<!-- // user name password END //-->
							
							<!-- // For DB type Microsoft SQL //-->
							<div class="form-group"
								data-ng-if="databaseAssetInfo.selectedDatabaseType.type == 'mssql'">
								<label class="col-xs-12 col-md-3 col-lg-3" for="hostName"><cv:msg
										key="label.assets.database.hostName" bundle="ediscovery" /></label>
								<div class="col-xs-12 col-md-9 col-lg-9">
									<input type="text" class="network-path" name=hostName
										id="msSqlHostName"
										data-ng-model="databaseAssetInfo.hostName" required />
								</div>
								<label class="col-xs-12 col-md-3 col-lg-3" for="instanceName"><cv:msg
										key="label.assets.database.instanceName" bundle="ediscovery" /></label>
								<div class="col-xs-12 col-md-9 col-lg-9">
									<input type="text" class="network-path" name=instanceName
										id="instanceName"
										data-ng-model="databaseAssetInfo.instanceName" required />
								</div>
								<label class="col-xs-12 col-md-3 col-lg-3" for="databaseName"><cv:msg
										key="label.assets.database.name" bundle="ediscovery" /></label>
								<div class="col-xs-12 col-md-9 col-lg-9">
									<input type="text" class="network-path" name=databaseName
										id="msSqlDatabaseName"
										data-ng-model="databaseAssetInfo.databaseName" required />
								</div>
							</div>
							
							<!-- // For DB type My SQL //-->
							<div class="form-group"
								data-ng-if="databaseAssetInfo.selectedDatabaseType.type == 'mysql'">
								<label class="col-xs-12 col-md-3 col-lg-3" for="hostName"><cv:msg
										key="label.assets.database.hostName" bundle="ediscovery" /></label>
								<div class="col-xs-12 col-md-9 col-lg-9">
									<input type="text" class="network-path" name=hostName
										id="mySqlhostName"
										data-ng-model="databaseAssetInfo.hostName" required />
								</div>
								<label class="col-xs-12 col-md-3 col-lg-3" for="databaseName"><cv:msg
										key="label.assets.database.name" bundle="ediscovery" /></label>
								<div class="col-xs-12 col-md-9 col-lg-9">
									<input type="text" class="network-path" name=databaseName
										id="msSqlDatabaseName"
										data-ng-model="databaseAssetInfo.databaseName" required />
								</div>
								<label class="col-xs-12 col-md-3 col-lg-3" for="port"><cv:msg
										key="label.assets.database.port" bundle="ediscovery" /></label>
								<div class="col-xs-12 col-md-9 col-lg-9">
									<input type="text" class="network-path" name=port
										id="portNumber"
										data-ng-model="databaseAssetInfo.port" required />
								</div>
							</div>
							
							<!-- // For DB type Oracle //-->
							<div class="form-group"
								data-ng-if="databaseAssetInfo.selectedDatabaseType.type == 'oracle'">
								<label class="col-xs-12 col-md-3 col-lg-3" for="driverType"><cv:msg
										key="label.assets.database.driverType" bundle="ediscovery" /></label>
								<div class="col-xs-12 col-md-9 col-lg-9">
									<input type="text" class="network-path" name=driverType
										id="driverType"
										data-ng-model="databaseAssetInfo.driverType" required />
								</div>
								<label class="col-xs-12 col-md-3 col-lg-3" for="databaseName"><cv:msg
										key="label.assets.database.name" bundle="ediscovery" /></label>
								<div class="col-xs-12 col-md-9 col-lg-9">
									<input type="text" class="network-path" name=databaseName
										id="oracleDatabaseName"
										data-ng-model="databaseAssetInfo.databaseName" required />
								</div></div>
						</div>
					</div>
				</div>
			</cv-tile-component>
		</div>
	</div>
</div>
<!-- // end  bootstrap-wrapper // -->
<div class="button-container no-margin">
	<button id="connectionDetailsDatabaseAsset_button_#9521" type="button" 
		class="btn btn-default cvBusyOnAjax skip-btn--hidden"
		data-ng-if="isCurrentStepCompleted()" data-ng-click="skip()">
		<cv:msg key="Skip" />
	</button>
	<button id="connectionDetailsDatabaseAsset_button_#7022" type="button" data-ng-click="saveConnectionDetailsTab()" 
		class="btn btn-primary cvBusyOnAjax setup-btn--hidden">
		<cv:msg key="label.next" bundle="ediscovery" />
	</button>
</div>
<div class="button-container centered" data-ng-show="formStorage.hide">
	<button id="connectionDetailsDatabaseAsset_button_#5170" type="button" 
		class="btn btn-default cvBusyOnAjax skip-btn--hidden"
		data-ng-click="skip()">
		<cv:msg key="Continue" />
	</button>
</div>