<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>

<div class="modal-header">
	<h1>
		<cv:msg key="label.assets.addNameServer" bundle="ediscovery" />
	</h1>
</div>

<form name="addNameServerAssetForm" novalidate cv-hide-api data-cv-submit="addNameServerAsset()" autocomplete="off" class="edit-users-grid-form">
	<div class="modal-body padding-bottom-10">
		<span class="{{serverMessage.type}} serverMessage" data-ng-bind="serverMessage.message"></span>
		<div class="form-group row">
			<label for="nameServer" class="col-xs-12 col-sm-4">
				<cv:msg key="label.assets.nameserver" bundle="ediscovery"/>
			</label>
			<div class="col-xs-12 col-sm-8">  
				<isteven-multi-select
							input-model="nameServers"
							output-model="selectedNameServers"
							button-label="connectName"
							item-label="connectName"
							tick-property="ticked"
							class="isteven-multi-select user-group-select"
							id="nameServer"
							name="nameserver"
							helper-elements="all none reset filter"
							max-labels="1"
							translation="nameServerText"
							disable-property="disabled"
							on-item-click="validateGroupSelection()"
							on-select-none="validateGroupSelection()"
							on-select-all="validateGroupSelection()"
							on-reset="validateGroupSelection()">
				</isteven-multi-select>
			</div>
			<span class="help-block" data-ng-show="showNameServerErrorMessage">{{ 'selectNameServer' | cvLoc }}</span>
		</div>
		<div class="padding-left-15">
			<schedule-data-crawl schedule-exists="inventoryScheduleExists" follow-schedule-crawl="followScheduleCrawl"></schedule-data-crawl>
		</div>
	</div>

	<div class="modal-footer padding-top-0 padding-right-20">
		<button id="addNameServerAssetModal_button_#2690" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()">
			<cv:msg key="Cancel" bundle="messages" />
		</button>
		<button id="addNameServerAssetModal_button_#2434" type="submit" class="btn btn-primary cvBusyOnAjax"> 
			<cv:msg key="Save" bundle="messages" />
		</button>
	</div>
</form>
