<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="setup-title">
    <h1>
		<span>
			<cv:msg key="label.update.roles" bundle="ediscovery"/>
		</span>
	</h1>
</div>
<form name="updateRolesForm" cv-hide-api data-cv-submit="urCtlr.updateRoles()" autocomplete="off" novalidate class="bootstrap-wrapper form-horizontal">
	<div class="modal-body">
		<div class="form-group margin-top-10">
			<label class="col-lg-2 margin-left-0 line-height-initial" for="roles">
				<cv:msg key="label.roles" bundle="ediscovery" />
			</label>
			<div  class="col-lg-10">
				<isteven-multi-select
					input-model="urCtlr.roles"
					output-model="urCtlr.selectedRoles"
					button-label="name"
					item-label="name"
					tick-property="selected"
					selection-mode="multiple"
					class="isteven-multi-select user-group-select"
					helper-elements="all none filter"
					max-labels="3"
					translation="urCtlr.localLang"
					on-item-click="urCtlr.roleSelectionChanged()"
					on-select-all="urCtlr.roleSelectionChanged()"
					on-select-none="urCtlr.roleSelectionChanged()">
				</isteven-multi-select>
				<input type="text" ng-model="urCtlr.selectedRoles" class="display-none" name="roles" required />
				<span class="help-block" data-ng-show="updateRolesForm.$submitted && updateRolesForm.roles.$error.required">
					<cv:msg key="error.select.roles" bundle="ediscovery"/>
				</span>
			</div>
		</div>
	</div>
	<div class="modal-footer">
		<button type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="$dismiss()">
	    	<cv:msg key="Cancel" bundle="messages" />
	    </button>
        <button type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="!urCtlr.allowUpdate">
        	<cv:msg key="label.update" bundle="ediscovery" />
        </button>
    </div>
</form>