<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div class="setup-title">
    <h1>
		<span data-ng-if="!epCtlr.isAdd">
			<cv:msg key="label.edit.plan" bundle="ediscovery"/>
		</span>
		<span data-ng-if="epCtlr.isAdd">
			<cv:msg key="label.assign.plan" bundle="ediscovery"/>
		</span>
	</h1>
</div>
<div class="setup-content">
	<section>
		<form name="editPlanForm" cv-hide-api data-cv-submit="epCtlr.save()" autocomplete="off" novalidate class="bootstrap-wrapper form-horizontal">
			<div class="form-group" data-ng-if="epCtlr.errorMessage">
				<div class="text-align-center">
					<span class="server-message error" data-ng-bind="epCtlr.errorMessage">
					</span>
				</div>
			</div>
			<label class="form-group no-margin" for="plan">
        		<span class="col-md-4">
        			<cv:msg key="label.casemanager.serverPlan" bundle="ediscovery"/>
        		</span>
		        <div class="col-md-8">
					<isteven-multi-select
						input-model="epCtlr.plans"
						output-model="epCtlr.selectedPlans"
						button-label="planName"
						item-label="planName"
						tick-property="selected"
						disable-property="disabled"
						selection-mode="single"
						class="isteven-multi-select user-group-select single-select"
						helper-elements="all none filter "
						translation="epCtlr.localLang">
					</isteven-multi-select>
					<input type="text" ng-model="epCtlr.selectedPlans" class="display-none" name="plan" required />
					<span class="help-block" data-ng-show="editPlanForm.$submitted && editPlanForm.plan.$error.required">
						<cv:msg key="error.noServerPlanFound" bundle="ediscovery"/>
					</span>
				</div>
    		</label>
			<div class="button-container">
	            <button type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="$dismiss()">
	                <cv:msg key="Cancel" bundle="messages"/>
	            </button>
	            <button type="submit" class="btn btn-primary cvBusyOnAjax">
	                <cv:msg key="action.save" bundle="ediscovery"/>
	            </button>
           	</div>
		</form>
	</section>
</div>