<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
  <cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
  <cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-md-12">
		<h1 class="float-left" data-ng-bind="IdxSrvCfgCtrl.indexServerName"></h1>
		<span><a class="page-action-item" href="" data-ng-click="IdxSrvCfgCtrl.deleteIndexServer()"><cv:msg key="label.delete" bundle="ediscovery" /></a></span>
	</div>
</div>
<cv-tab-nav></cv-tab-nav>
<div class="row">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="indexServerDetails-title_general" data-title='<cv:msg key="label.general" bundle="ediscovery" />' loader="IdxSrvCfgCtrl.generalInfo">
			<ul class="list-style-secondary">
				<li class="group">
				    <span class="pageDetailColumn">
				    	<cv:msg key="label.analyticsEngine" bundle="ediscovery" />
				    </span>
				    <span class="pageDetailColumn" data-ng-bind="IdxSrvCfgCtrl.indexServerName"></span>
				</li>
				<li class="group">
				    <span class="pageDetailColumn"><cv:msg key="label.operatingSystem" bundle="ediscovery" /></span>
				    <span class="pageDetailColumn" data-ng-bind="IdxSrvCfgCtrl.generalInfo.OS"></span>
				</li>
				<li class="group" data-ng-if="!IdxSrvCfgCtrl.generalInfo.storagePolicyName">
				    <span class="pageDetailColumn">
				    	<cv:msg key="label.casemanager.serverPlan" bundle="ediscovery" />
				    </span>
				    <div class="pageDetailColumn">
				    	<span data-ng-if="IdxSrvCfgCtrl.generalInfo.planName">
				    		<a href="#/profileDetails/{{IdxSrvCfgCtrl.generalInfo.planId}}" data-ng-bind="IdxSrvCfgCtrl.generalInfo.planName">
				    		</a>
				    		<span>
						        <a href="" class="pull-right" ng-click="IdxSrvCfgCtrl.editPlan(false)">
						            <span><cv:msg key="label.edit" bundle="ediscovery" /></span>
						        </a>
	    					</span>
				    	</span>
						<span data-ng-if="!IdxSrvCfgCtrl.generalInfo.planName">
				    		<cv:msg key="info.notAssigned" bundle="ediscovery" />
				    		<span>
						        <a href="" class="pull-right" ng-click="IdxSrvCfgCtrl.editPlan(true)">
									<span>
						            	<cv:msg key="label.assign" bundle="ediscovery" />
						            </span>
						        </a>
	    					</span>
				    	</span>
				    </div>
				</li>
				<li class="group" data-ng-if="IdxSrvCfgCtrl.generalInfo.storagePolicyName">
				    <span class="pageDetailColumn">
				    	<cv:msg key="label.storagePolicy" bundle="capps" />
				    </span>
				    <div class="pageDetailColumn">
				    	<span>
				    		<span data-ng-bind="IdxSrvCfgCtrl.generalInfo.storagePolicyName"></span>
				    		<span>
						        <a href="" class="pull-right" ng-click="IdxSrvCfgCtrl.editPlan(true)">
									<span>
						            	<cv:msg key="label.assign.plan" bundle="ediscovery" />
						            </span>
						        </a>
	    					</span>
				    	</span>
					</div>
				</li>
			</ul>
		</cv-tile-component>
	</div>
	<div class="col-md-6">
		<cv-tile-component data-ac-id="indexServerDetails-roles" data-title='<cv:msg key="label.roles" bundle="ediscovery" />' loader="IdxSrvCfgCtrl.roles">
			<ul class="list-style-secondary list-overflow-scroll margin-top-10">
				<li data-ng-repeat="role in IdxSrvCfgCtrl.roles">
					<span>
						{{role.name}}
					</span>
				</li>
			</ul>
			<div class="page-details-box-links">
				<a href="" data-ng-click="IdxSrvCfgCtrl.editRoles()" title="<cv:msg key="label.edit.roles" bundle="ediscovery" />">
					<cv:msg key="label.edit" bundle="ediscovery" />
				</a>
			</div>
		</cv-tile-component>
	</div>
	<div class="col-md-6"  data-ng-if="false">
		<cv-tile-component data-ac-id="indexServerDetails-roles" data-title='<cv:msg key="label.applications" bundle="ediscovery" />' loader="IdxSrvCfgCtrl.applications">
			<ul class="list-style-secondary list-overflow-scroll margin-top-10">
				<li data-ng-repeat="application in IdxSrvCfgCtrl.applications">
					<span>
						{{application.displayName}}
					</span>
				</li>
			</ul>
			<div class="page-details-box-links">
				<a href="" data-ng-click="IdxSrvCfgCtrl.editApplications()" title="<cv:msg key="label.edit.applications" bundle="ediscovery" />">
					<cv:msg key="label.edit" bundle="ediscovery" />
				</a>
			</div>
		</cv-tile-component>
	</div>
</div>
<div  class="row">
	<div class="col-md-12">
		<cv-kendo-grid data-cv-grid-options="IdxSrvCfgCtrl.nodesGridOptions"></cv-kendo-grid>
	</div>
</div>

