<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div class="setup-title">
    <h1>
		<span>
			<cv:msg key="label.add.node" bundle="ediscovery"/>
		</span>
	</h1>
</div>
<div class="setup-content">
	<section>
		<form name="addNodeForm" cv-hide-api data-cv-submit="anCtlr.addNode()" autocomplete="off" novalidate class="bootstrap-wrapper form-horizontal">
			<div class="form-group" data-ng-if="anCtlr.errorMessage">
				<div class="text-align-center">
					<span class="server-message error" data-ng-bind="anCtlr.errorMessage">
					</span>
				</div>
			</div>
			<label class="form-group no-margin" for="name">
        		<span class="col-md-4">
        			<cv:msg key="label.nodes" bundle="ediscovery"/>
        		</span>
		        <div class="col-md-8">
					<isteven-multi-select
						input-model="anCtlr.inputNodes"
						output-model="anCtlr.selectedNodes"
						button-label="displayName"
						item-label="displayName"
						tick-property="selected"
						selection-mode="single"
						class="isteven-multi-select user-group-select single-select"
						helper-elements="all none filter "
						translation="anCtlr.localLang">
					</isteven-multi-select>
					<input type="text" ng-model="anCtlr.selectedNodes" class="display-none" name="node" required />
					<span class="help-block" data-ng-show="addNodeForm.$submitted && addNodeForm.node.$error.required">
						<cv:msg key="error.node" bundle="ediscovery"/>
					</span>
				</div>
    		</label>
    		<label class="form-group no-margin" for="indexDirectory">
        		<span class="col-md-4">
        			<cv:msg key="label.node.indexDirectory" bundle="ediscovery"/>
        		</span>
		        <div class="col-md-8">
					<div class="input-group">
						<input type="text" name="indexDirectory" data-ng-model="anCtlr.indexDirectory" title="{{anCtlr.indexDirectory}}"required/>
						<span class="input-group-btn" title="<cv:msg key="label.browse" bundle="ediscovery"/>">
							<button type="button" class="icon-style cv-material-button browse" data-ng-click="anCtlr.browse()">
								<div class="cv-material-button-icon cursor-pointer">
									<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
										<path d="M0 0h24v24H0z" fill="none"></path>
										<path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"></path>
									</svg>
								</div>
							</button>
						</span>
					</div>
					<span class="help-block" data-ng-show="addNodeForm.$submitted && addNodeForm.indexDirectory.$error.required">
						<cv:msg key="error.node.indexDirectory" bundle="ediscovery"/>
					</span>
				</div>
    		</label>
    		<label class="form-group no-margin" for="javaMemory">
        		<span class="col-md-4">
        			<cv:msg key="label.node.javaMemory.allocation" bundle="ediscovery"/>
        		</span>
		        <div class="col-md-8" data-ng-if="!anCtlr.showCustomJavaMemory">
			    	<cv-help-text help-text="text.help.javaMemory.default" help-label="label.help.javaMemory.default"></cv-help-text>
			    	<span title="<cv:msg key="label.custom.memory.allocation" bundle="ediscovery"/>" class="cursor-pointer margin-left-10 k-icon k-i-edit" data-ng-click="anCtlr.setCustomJavaMemoryInfo()">
	                </span>
			    </div>
			    <div class="col-md-8" data-ng-if="anCtlr.showCustomJavaMemory">
           			<input type="number" name="javaMemory" data-ng-model="anCtlr.customJavaMemory" class="width-auto" min="{{anCtlr.minJavaMemory}}" max="{{anCtlr.maxJavaMemory}}" step="1" required>
               		<span title="<cv:msg key="label.reset.default" bundle="ediscovery"/>" class="cursor-pointer margin-top-5 k-icon k-i-reset" data-ng-click="anCtlr.unSetCustomJavaMemoryInfo()">
            		</span>
                    <div class="help-block" data-ng-show="!anCtlr.customJavaMemory">
                       <cv:msg key="error.add.node.javaMemory" bundle="ediscovery"/>
                   	</div>
                </div>
    		</label>
    		<label class="form-group no-margin" for="portNo">
        		<span class="col-md-4">
        			<cv:msg key="label.node.port" bundle="ediscovery"/>
        		</span>
		        <div class="col-md-8">
		            <input type="number" name="portNo" data-ng-model="anCtlr.portNo" title="{{anCtlr.portNo}}" class="width-auto" min="1" step="1" required>
		            <span class="help-block" data-ng-show="addNodeForm.$submitted && !anCtlr.portNo">
						<cv:msg key="error.node.portNo" bundle="ediscovery"/>
					</span>
		        </div>
    		</label>
     		<cv-plain-accordion accordion-label="<cv:msg key="title.add.node.loadBalance" bundle="ediscovery"/>" collapsed="false" class="margin-right-5 margin-left-5 margin-top-10">
            	<div>
                	<input id="autoScaling" type="checkbox" ng-model="anCtlr.allowAutoScaling"/>
	                <label for="autoScaling">
	                    <cv-help-text help-text="info.add.index.rebalance" help-label="label.enable.index.rebalance"></cv-help-text>
	                </label>
         		</div>
            </cv-plain-accordion>
    		<div class="button-container">
                <button type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="$dismiss()">
                    <cv:msg key="Cancel" bundle="messages"/>
                </button>
                <button type="submit" class="btn btn-primary cvBusyOnAjax">
                    <cv:msg key="action.save" bundle="ediscovery"/>
                </button>
            </div>
		</form>
	</section>
</div>