<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<form name="addIdxGeneralForm" novalidate autocomplete="off" data-cv-submit="">
	<div class="bootstrap-wrapper no-padding">
		<div class="form-group" data-ng-if="idxGnCtrl.model.errorMessage">
			<div class="text-align-center">
				<span class="server-message error">
					{{idxGnCtrl.model.errorMessage}}
				</span>
			</div>
		</div>
		<div class="panel panel-default no-border">
			<div class="panel-body">
				<div class="form-group">
					<label for="indexServerName" class="col-md-3">
						<cv:msg key="label.name" bundle="ediscovery"/>
					</label>
					<div class="col-md-9">
						<input type="text" autofocus name="indexServerName" data-ng-model="idxGnCtrl.indexServerName" minlength=1 maxlength="128" data-ng-pattern="/^[a-zA-Z0-9_-]*$/" required>
						<span class="help-block" data-ng-show="addIdxGeneralForm.$submitted && addIdxGeneralForm.indexServerName.$error.required">
							<cv:msg key="error.name.required" bundle="ediscovery"/>
						</span>
						<span class="help-block" data-ng-show="addIdxGeneralForm.$submitted  && addIdxGeneralForm.indexServerName.$error.pattern">
							<cv:msg key="error.name.pattern" bundle="ediscovery"/>
						</span>
					</div>
				</div>
			</div>
		</div>
		<div class="panel panel-default no-border">
			<div class="panel-body">
				<div class="text-align-center margin-bottom-10">
					<cv:msg key="add.wizard.info.plan" bundle="ediscovery" />
				</div>
				<div class="alert alert-sign-detail text-center" data-ng-if="idxGnCtrl.showNoPlanSelectedWarning">
					<span class="alert-detail-icon k-icon k-i-warning"></span>
					<cv:msg key="warning.noPlanSelected" bundle="ediscovery" />
				</div>
				<div>
					<h4 class="inline-block">
						<cv:msg key="title.backup.configuration" bundle="ediscovery" />
					</h4>
					<span class="optional-text">
							<cv:msg key="label.optional" bundle="ediscovery" />
					</span>
				</div>
				<div class="form-group">
					<label for="indexServerName" class="col-md-3">
						<cv:msg key="label.plan" bundle="ediscovery" />
					</label>
					<div class="col-md-9">
						<isteven-multi-select
							input-model="idxGnCtrl.plans"
							output-model="idxGnCtrl.selectedPlan"
							button-label="planName"
							item-label="planName"
							tick-property="selected"
							selection-mode="single"
							class="isteven-multi-select user-group-select single-select"
							helper-elements="filter"
							max-labels="1"
							translation="idxGnCtrl.localLang"
							on-item-click="idxGnCtrl.onPlanSelected(data)">
						</isteven-multi-select>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="cv-wizard-default-actions add-alert-wizard-actions row">
		<div class="col-xs-12">
			<div class="col-xs-3 col-xs-offset-9 col-md-2 col-md-offset-10">
				<cv-wizard-button data-cv-type="next" data-cv-label="{{idxGnCtrl.nextBtnLabel}}">

				</cv-wizard-button>
			</div>
		</div>
	</div>
</form>