<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<form name="addIdxNodesForm" novalidate autocomplete="off" data-cv-submit="" class="form-horizontal">
	<div class="bootstrap-wrapper no-padding">
		<div class="form-group" data-ng-if="addNdCtrl.model.errorMessage">
			<div class="text-align-center">
				<span class="server-message error">
					{{addNdCtrl.model.errorMessage}}
				</span>
			</div>
		</div>
		<div class="panel panel-default no-border">
			<div class="panel-body">
				<div class="form-group">
					<label for="nodes" class="col-md-3">
						<cv:msg key="label.nodes" bundle="ediscovery"/>
					</label>
					<div class="col-md-9">
						<isteven-multi-select
							input-model="addNdCtrl.inputNodes"
							output-model="addNdCtrl.selectedNodes"
							button-label="name"
							item-label="name"
							tick-property="selected"
							class="isteven-multi-select"
							helper-elements="all none filter"
							min-search-length="1"
							translation="addNdCtrl.localLang"
							on-close="addNdCtrl.selectionComplete()">
						</isteven-multi-select>
						<input type="text" ng-model="addNdCtrl.selectedNodes" class="display-none" name="nodes" required />
						<span class="help-block" data-ng-show="addIdxNodesForm.$submitted && addIdxNodesForm.nodes.$error.required">
							<cv:msg key="error.node" bundle="ediscovery"/>
						</span>
					</div>
				</div>
				<div class="form-group" data-ng-repeat="node in addNdCtrl.nodes">
					<div class="col-md-12 margin-top-20">
						<cv-plain-accordion accordion-label="{{node.name}}" collapsed="addNdCtrl.accordianStatus[node.name]">
	        				<div class="padding-5">
								<h4 class="text-align-center">
									<cv:msg key="label.node.configuration" bundle="ediscovery"/>
								</h4>
							</div>
	        				<div class="form-group">
								<label class="col-xs-4 col-md-4 col-lg-4" for="indexDirectory">
									<cv:msg key="label.node.indexDirectory" bundle="ediscovery"/>
								</label>
								<div class="col-xs-8 col-md-8 col-lg-8">
									<div class="input-group">
										<input type="text" name="indexDirectory" data-ng-model="node.indexDirectory"/>
										<span class="input-group-btn" title="<cv:msg key="label.browse" bundle="ediscovery"/>">
											<button type="button" class="icon-style cv-material-button browse" data-ng-click="addNdCtrl.browse(node)">
												<div class="cv-material-button-icon cursor-pointer">
													<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
														<path d="M0 0h24v24H0z" fill="none"></path>
														<path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"></path>
													</svg>
												</div>
											</button>
										</span>
									</div>
									<span class="help-block" data-ng-show="addIdxNodesForm.$submitted && (!node.indexDirectory || node.indexDirectory.length == 0)">
										<cv:msg key="error.node.indexDirectory" bundle="ediscovery"/>
									</span>
								</div>
							</div>
							<div class="form-group">
								<span class="col-md-4">
									<cv:msg key="label.node.javaMemory.allocation" bundle="ediscovery"/>
								</span>
								<div class="col-md-8 margin-top-10" data-ng-if="!node.showCustomJavaMemory">
       		 						<cv-help-text help-text="text.help.javaMemory.default" help-label="label.help.javaMemory.default"></cv-help-text>
		        		 		 	<span title="<cv:msg key="label.custom.memory.allocation" bundle="ediscovery"/>" class="cursor-pointer margin-left-10 k-icon k-i-edit" data-ng-click="addNdCtrl.setCustomJavaMemoryInfo(node)">
                                  	</span>
			        		 	</div>
			        		 	<div class="col-md-8" data-ng-if="node.showCustomJavaMemory">
	                                <input type="number" name="javaMemory" data-ng-model="node.customJavaMemory" class="width-auto" min="{{addNdCtrl.minJavaMemory}}" max="{{addNdCtrl.maxJavaMemory}}" step="1" required>
	                                <span title="<cv:msg key="label.reset.default" bundle="ediscovery"/>" class="cursor-pointer margin-top-5 k-icon k-i-reset" data-ng-click="addNdCtrl.unSetCustomJavaMemoryInfo(node)">
	                                </span>
	                                <div class="help-block" data-ng-show="!node.customJavaMemory">
	                                   <cv:msg key="error.add.node.javaMemory" bundle="ediscovery"/>
                               		</div>
                       			</div>
							</div>
							<div class="form-group">
								<label class="col-md-4" for="portNo">
									<cv:msg key="label.node.port" bundle="ediscovery"/>
								</label>
								<div class="col-md-8">
									<input type="number" name="portNo" data-ng-model="node.portNo" class="width-auto" min="1" step="1" required>
									<span title="<cv:msg key="label.reset.default" bundle="ediscovery"/>" class="cursor-pointer margin-top-5 k-icon k-i-reset" data-ng-click="addNdCtrl.reset(2,node)" data-ng-if="addIdxNodesForm.portNo.$dirty">
				        		 	</span>
				        		 	<span class="help-block" data-ng-show="addIdxNodesForm.$submitted && !node.portNo">
										<cv:msg key="error.node.portNo" bundle="ediscovery"/>
									</span>
			        		 	</div>
							</div>
	        			</cv-plain-accordion>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="cv-wizard-default-actions row">
		<div class="col-xs-12">
			<div class="col-xs-3 col-xs-offset-6 col-md-2 col-md-offset-8">
				<cv-wizard-button data-cv-type="previous" data-cv-disabled="addNdCtrl.model.inProgress">
				</cv-wizard-button>
			</div>
			<div class="col-xs-3 col-md-2">
				<cv-wizard-button data-cv-type="finish">
				</cv-wizard-button>
			</div>
		</div>
	</div>
</form>
