<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
    <cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
</script>
<form name="addIdxApplicationsForm" class="form-horizontal" novalidate autocomplete="off" data-cv-submit="">
	<div class="bootstrap-wrapper no-padding">
		<div class="form-group" data-ng-if="addAppCtrl.model.errorMessage">
			<div class="text-align-center">
				<span class="server-message error">
					{{addAppCtrl.model.errorMessage}}
				</span>
			</div>
		</div>
		<div class="cv-wizard-step-header">
        	<h3 class="cv-wizard-step-title">
        		<cv:msg key="title.add.step.roles" bundle="ediscovery"/>
        	</h3>
    	</div>
		<div class="panel panel-default no-border">
			<div class="panel-body">
				<div class="text-align-center margin-bottom-20">
					<cv:msg key="add.wizard.info.applications" bundle="ediscovery"/>
				</div>
				<div class="form-group">
					<label for="applications" class="col-md-3">
						<cv:msg key="label.applications" bundle="ediscovery"/>
					</label>
					<div class="col-md-9">
						<isteven-multi-select
							input-model="addAppCtrl.applications"
							output-model="addAppCtrl.selectedApplications"
							button-label="name"
							item-label="name"
							tick-property="selected"
							selection-mode="multiple"
							class="isteven-multi-select user-group-select"
							helper-elements="all none filter"
							max-labels="3"
							translation="addAppCtrl.localLang"
							on-item-click="addAppCtrl.onApplicationsSelection(data)">
						</isteven-multi-select>
						<input type="text" ng-model="addAppCtrl.selectedApplications" class="display-none" name="applications" ng-required="!addAppCtrl.selectedRoles || addAppCtrl.selectedRoles.length == 0"/>
						<span class="help-block" data-ng-show="addIdxApplicationsForm.$submitted && addIdxApplicationsForm.applications.$error.required">
							<cv:msg key="error.applications" bundle="ediscovery"/>
						</span>
					</div>
				</div>
				<div class="margin-top-20">
					<cv-plain-accordion accordion-label="Advanced" collapsed="false" is-disabled="false">
						<div class="text-align-center margin-top-10">
						</div>
						<div class="form-group">
							<span class="col-lg-2 col-lg-offset-1 margin-top-5">
								<cv:msg key="label.roles" bundle="ediscovery"/>
							</span>
							<div class="col-lg-8">
								<isteven-multi-select
									input-model="addAppCtrl.roles"
									output-model="addAppCtrl.selectedRoles"
									button-label="name"
									item-label="name"
									tick-property="selected"
									disable-property="disabled"
									selection-mode="multiple"
									class="isteven-multi-select user-group-select"
									helper-elements="all none filter"
									max-labels="3"
									translation="addAppCtrl.localLang"
									group-property="appGroup"
									on-item-click="addAppCtrl.onRolesSelected()">
								</isteven-multi-select>
							</div>
						</div>
					</cv-plain-accordion>
				</div>
			</div>
		</div>
	</div>
	<div class="cv-wizard-default-actions row">
		<div class="col-xs-12">
			<div class="col-xs-3 col-xs-offset-6 col-md-2 col-md-offset-8">
				<cv-wizard-button data-cv-type="previous">
				</cv-wizard-button>
			</div>
			<div class="col-xs-3 col-md-2">
				<cv-wizard-button data-cv-type="next">
				</cv-wizard-button>
			</div>
		</div>
	</div>
</form>
