<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div class="entity-list">
	<div data-ng-show="multiSelectCtrl.entityHierarchyList.length > 0">
		<div class="search-bar">
			<input type="text" class="form-control" placeholder="Search" data-ng-model="multiSelectCtrl.filterText"/>
			<span data-ng-click="multiSelectCtrl.filterText=''" data-ng-show="multiSelectCtrl.filterText!=='' && angular.isDefined(multiSelectCtrl.filterText)" class="form-control-clear glyphicon glyphicon-remove form-control-feedback" title="Clear"></span>
		</div>
		<div id="additionalFilters">
			<div class="uib-dropdown" data-ng-class="{'selected' : filter.showFilterClear}" data-ng-repeat="filter in multiSelectCtrl.entityFilters" data-uib-dropdown dropdown-append-to-body="true">
		        <span class="uib-dropdown-toggle" data-uib-dropdown-toggle>
		           <span data-ng-attr-title="{{multiSelectCtrl.getFilterHeader(filter)}}" data-ng-bind="multiSelectCtrl.getFilterHeader(filter)" class="chip-text"> </span>
		            <span data-ng-if="!filter.showFilterClear" class="k-icon k-i-arrow-chevron-down icon-style"/>
		            <span data-ng-click="multiSelectCtrl.clearFilter(filter)" data-ng-if="filter.showFilterClear" class="k-icon k-i-close icon-style"/>
		        </span>
		        <ul data-ng-click="filter.name !== 'state' && $event.stopPropagation()" role="menu" data-uib-dropdown-menu class="dropdown-menu entity-manager-filter-menu cv-dropdown-style-2 views-menu k-context-menu no-margin cv-material-dropdown-menu">
		            <li class="k-item" data-ng-repeat="val in filter.values | orderBy:'toString()'" data-ng-class="{'selected' : multiSelectCtrl.isFilterValSelected(filter.name,val)}" data-ng-click="multiSelectCtrl.onFilterValChange(filter.name,val)">
		            	<span data-ng-attr-title="{{val}}"><span data-ng-bind="val"></span></span>
					</li>
		        </ul>
		    </div>
		</div>
		<div data-ng-if=" multiSelectCtrl.selectionMode !== 'single' && !multiSelectCtrl.readOnly" class="entity-btn-wrapper">
			<span>
                <input id="selectAll" type="checkbox" data-ng-checked="multiSelectCtrl.isSelectAllEntities()" data-ng-click="multiSelectCtrl.selectAllEntities()">
                <label class="no-margin" for="selectAll" title="<fmt:message key='label.entitymanger.selectAll' bundle='ediscovery'/>"><cv:msg key="label.entitymanger.selectAll" bundle="ediscovery"/></label>
       		</span>
	        <span class="show-selected-elm">
                <input id="showSelected" type="checkbox" data-ng-model="multiSelectCtrl.isShowSelected">
                <label class="no-margin" for="showSelected" title="<fmt:message key='label.entitymanger.showSelected' bundle='ediscovery'/>"><cv:msg key="label.entitymanger.showSelected" bundle="ediscovery"/></label>
			</span>
		   <div class="min-height-20">
		   <span class="display-block text-align-right" data-ng-show="multiSelectCtrl.selectedEntities.length > 0">
				<a href="" data-ng-click="multiSelectCtrl.clear()"><cv:msg key='label.clear' bundle='messages' /></a>
		   </span>
		   </div>
		</div>
	</div>

	<div class="list-group" data-ng-class="{'multi-select' : multiSelectCtrl.selectionMode !== 'single'}" >
		<div data-ng-show="multiSelectCtrl.showNoDataElement" id="noDataElm"><cv:msg key="label.noresults" bundle="ediscovery"/></div>

		<div data-ng-repeat="category in multiSelectCtrl.entityHierarchyList | categoryFilter : multiSelectCtrl.filterText : multiSelectCtrl | orderBy : (multiSelectCtrl.preventContainerSort ? '' : 'containerName')">
			<div class="list-group-parent list-group-item" data-ng-class="{'selected':multiSelectCtrl.isCategorySelected(category)}">
				<span class="entity-item-headline" data-ng-click=" multiSelectCtrl.selectionMode !== 'single' && multiSelectCtrl.selectEntities(category)">{{category.containerName}}</span>
			</div>
			<div data-ng-repeat="subCategory in category.subCategories | subCategoryFilter : multiSelectCtrl.filterText : category : multiSelectCtrl | orderBy : 'containerName'" class="padding-left-20">
				<div class="list-group-item" data-ng-class="{'selected': multiSelectCtrl.isSubCategorySelected(subCategory)}">
					<span data-ng-click="multiSelectCtrl.selectionMode !== 'single' && multiSelectCtrl.selectEntities(subCategory,category)" class="entity-item-headline">{{subCategory.containerName}}</span>
				</div>
				<a data-ng-if="!multiSelectCtrl.showSelected || multiSelectCtrl.isEntitySelected(entity)" data-ng-repeat="entity in subCategory.entities | entityFilter : multiSelectCtrl.filterText : category : subCategory : multiSelectCtrl| orderBy : 'displayName'" class="list-group-item" data-ng-class="{'entity-selected': multiSelectCtrl.isEntitySelected(entity),'single-selection' : multiSelectCtrl.selectionMode === 'single'}" data-ng-click="multiSelectCtrl.selectEntity(entity)">
					<span data-ng-if="multiSelectCtrl.selectionMode === 'single'">
						<img data-ng-if="entity.icon" class="entity-icon" ng-src="ediscovery/common/img/sensitivity-icons/{{entity.icon}}.svg"/>
						<span class="entity-item-title">{{entity.displayName}}</span>
					</span>
					<span data-ng-if="multiSelectCtrl.selectionMode !== 'single'">
						<input id="entity_{{entity.entityId}}" type="checkbox" ng-checked="multiSelectCtrl.isEntitySelected(entity)">
						<label class="no-margin" for="entity_{{entity.entityId}}" ng-title="entity.displayName">{{entity.displayName}}</label>
		       		</span>

				</a>
			</div>
		</div>

	</div>
</div>
