<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<form name="createClassifierForm" novalidate autocomplete="off" data-cv-submit="">
    <div class="bootstrap-wrapper no-padding">
        <div class="panel panel-default no-border">
            <div class="panel-body">
                <div class="text-align-center padding-bottom-50">
                    <span>
                        <cv:msg key="info.classifiermanager.wizardstep1.detail" bundle="ediscovery" />
                    </span>
                </div>
                <div class="form-group padding-bottom-10">
                    <div class="row">
                        <div class="col-md-3 col-md-offset-2">
                            <label for="contentAnalyzer">
                                <cv:msg key="label.contentAnalyzer" bundle="ediscovery" />
                            </label>
                        </div>
                        <div class="col-md-5">
                            <isteven-multi-select
                                directive-id="classifierWizardContentAnalyzer"
                                input-model="classifierCrtnCtrl.contentAnalyzers"
                                output-model="classifierCrtnCtrl.selectedContentAnalyzer"
                                button-label="cloudName"
                                item-label="cloudName"
                                tick-property="selected"
                                selection-mode="single"
                                helper-elements="filter"
                                min-search-length="3"
                                search-property="cloudName"
                                max-labels="1"
                                translation="classifierCrtnCtrl.localLang"
                                output-properties="cloudId cloudName caUrl clientId">
                            </isteven-multi-select>
                            <input type="text" ng-model="classifierCrtnCtrl.selectedContentAnalyzer" name="selectedContentAnalyzer" style="display:none" required />
                            <span class="help-block" data-ng-if="createClassifierForm.$submitted && createClassifierForm.selectedContentAnalyzer.$error.required">
                                <cv:msg key="error.noContentAnalyzerSelected" bundle="ediscovery" />
                            </span>
                        </div>
                    </div>
				</div>
                <div class="form-group padding-bottom-10">
                    <div class="row">
                        <div class="col-md-3 col-md-offset-2">
                            <label for="classifierName">
                                <cv:msg key="label.entitymanager.name" bundle="ediscovery"/>
                            </label>
                        </div>
                        <div class="col-md-5">
                            <input type="text" ng-readonly="classifierCrtnCtrl.model.isClassifierCreated" autofocus name="classifierName" data-ng-model="classifierCrtnCtrl.model.classifierObj.entityName" required data-ng-pattern="/^[\w-\s]+$/">
                            <span class="help-block" data-ng-if="createClassifierForm.$submitted && createClassifierForm.classifierName.$error.required">
                                <cv:msg key="error.entitymanager.name.required" bundle="ediscovery"/>
                            </span>
                            <span class="error" data-ng-if="createClassifierForm.classifierName.$error.pattern">
                                <cv:msg key="error.entitymanager.specialCharsNotAllowed" bundle="ediscovery" />
                            </span>
                        </div>
                    </div>
                </div>
                <div class="form-group padding-bottom-20">
                    <div class="row">
                        <div class="col-md-3 col-md-offset-2">
                            <label for="classifierDescription">
                                <cv:msg key="label.description" bundle="ediscovery"/>
                            </label>
                        </div>
                        <div class="col-md-5">
                            <textarea placeholder="<cv:msg key='info.classifiermanager.createclassifier.description' bundle='ediscovery' />" data-ng-model="classifierCrtnCtrl.model.classifierObj.description"></textarea>
                        </div>
                    </div>
				</div>
            </div>
        </div>
    </div>
    <div class="cv-wizard-default-actions add-alert-wizard-actions row">
		<div class="col-xs-12">
			<div class="col-xs-3 col-xs-offset-9 col-md-2 col-md-offset-10">
				<cv-wizard-button data-cv-type="next"></cv-wizard-button>
			</div>
		</div>
	</div>
</form>