<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>

<div class="modal-header">
	<h1>
		{{ $ctrl.title }}
	</h1>
</div>

<div class="bootstrap-wrapper">
	<form id="addScheduleForm" name="addScheduleForm" class="schedule-form text-align-left" data-ng-submit="$ctrl.save(addScheduleForm.$valid)" novalidate>
		<div class="modal-body">
			<!-- Frequency -->
			<div class="form-group row">
				<label for="scheduleFrequency" class="col-xs-12 col-sm-5">{{ 'label.scheduleFrequency' | cvLoc }}</label>
				<div class="col-xs-12 col-sm-7">
					<isteven-multi-select
						id="scheduleFrequency"
						input-model="$ctrl.frequencies"
						output-model="$ctrl.freqTypeObj"
						on-item-click="$ctrl.selectFrequency( data )"
						button-label="label"
						item-label="label"
						tick-property="selected"
						class="isteven-multi-select user-group-select"
						selection-mode="single"
						translation="$ctrl.localLang"
						prevent-sort="true"
					/>
					<div class="error no-margin" data-ng-show="addScheduleForm.$submitted && $ctrl.scheduleFrequencyInvalid">{{ 'error.scheduleFrequency' | cvLoc }}</div>
				</div>
			</div>

			<!-- One Time Calendar -->
			<div class="form-group row" data-ng-if="$ctrl.freqType && $ctrl.freqType === 'ONE_TIME'">
				<label class="col-xs-12 col-sm-12">{{ 'label.schedule.selectDateTime' | cvLoc }}</label>
				<div uib-datepicker data-ng-model="$ctrl.oneTimeDate" datepicker-options="$ctrl.datepickerOptions"></div>
			</div>

			<!-- Time -->
			<div class="form-group row" data-ng-if="$ctrl.freqType">
				<label for="scheduleTime" class="col-xs-12 col-sm-5">{{ 'entities.time' | cvLoc }}</label>
				<div class="col-xs-12 col-sm-7">
					<div uib-timepicker
						id="scheduleTime"
						name="scheduleTime"
						data-ng-model="$ctrl.scheduleTime"
						hour-step="1"
						minute-step="15"
						show-spinners="false"
					></div>
					<div class="error no-margin" data-ng-show="addScheduleForm.$submitted && addScheduleForm.scheduleTime.$invalid">{{ 'error.scheduleTime' | cvLoc }}</div>
				</div>
			</div>

			<!-- Weekly -->
			<div class="form-group row" data-ng-if="$ctrl.freqType && $ctrl.freqType === 'WEEKLY'">
				<label for="weeklyScheduleDays" class="col-xs-12 col-sm-5">{{ 'label.daysOfWeek' | cvLoc }}</label>
				<div class="col-xs-12 col-sm-7">
					<isteven-multi-select
						id="weeklyScheduleDays"
						input-model="$ctrl.daysOfWeek"
						output-model="$ctrl.selectedDaysOfWeek"
						button-label="label"
						item-label="label"
						tick-property="ticked"
						class="isteven-multi-select user-group-select"
						max-labels="2"
						translation="$ctrl.localLang"
						prevent-sort="true">
					</isteven-multi-select>
					<div class="error no-margin" data-ng-show="addScheduleForm.$submitted && $ctrl.selectedDaysOfWeek.length === 0">{{ 'error.weeklySchedule' | cvLoc }}</div>
				</div>
			</div>

			<!-- Monthly -->
			<div data-ng-if="$ctrl.freqType && ($ctrl.freqType === 'MONTHLY' || $ctrl.freqType === 'MONTHLY_RELATIVE')">
				<div class="form-group row">
					<label class="col-xs-12 col-sm-5" for="monthlyScheduleOnDay"><input id="monthlyScheduleOnDay" type="radio" value="MONTHLY" data-ng-model="$ctrl.freqType" />{{ 'option.onDay' | cvLoc }}</label>
					<div class="col-xs-12 col-sm-7">
						<input type="number" name="monthlyScheduleDayOfMonth" min="1" max="31" data-ng-disabled="$ctrl.freqType !== 'MONTHLY'" data-ng-model="$ctrl.monthlyScheduleDayOfMonth" />
						<div class="error no-margin" data-ng-show="addScheduleForm.$submitted && addScheduleForm.monthlyScheduleDayOfMonth.$invalid">{{ 'error.monthlyScheduleOnDay' | cvLoc }}</div>
					</div>
				</div>
				<div class="form-group row">
					<label class="col-xs-12 col-sm-5" for="monthlyScheduleCustom"><input id="monthlyScheduleCustom" type="radio" value="MONTHLY_RELATIVE" data-ng-model="$ctrl.freqType" />{{ 'option.customWeekOrDay' | cvLoc }}</label>
					<div class="col-xs-12 col-sm-7 row no-right-padding">
						<div class="col-xs-12 col-sm-6 no-right-padding">
							<isteven-multi-select
								id="monthlyScheduleWeekOfMonth"
								is-disabled="$ctrl.freqType !== 'MONTHLY_RELATIVE'"
								input-model="$ctrl.weeksInMonth"
								output-model="$ctrl.monthlyScheduleWeekOfMonth"
								button-label="label"
								item-label="label"
								tick-property="selected"
								class="isteven-multi-select user-group-select"
								selection-mode="single"
								translation="$ctrl.localLang"
								prevent-sort="true"
							/>
						</div>
						<div class="col-xs-12 col-sm-6 no-right-padding">
							<isteven-multi-select
								id="monthlyScheduleDayOfWeek"
								is-disabled="$ctrl.freqType !== 'MONTHLY_RELATIVE'"
								input-model="$ctrl.days"
								output-model="$ctrl.monthlyScheduleDayOfWeek"
								button-label="label"
								item-label="label"
								tick-property="selected"
								class="isteven-multi-select user-group-select"
								selection-mode="single"
								translation="$ctrl.localLang"
								prevent-sort="true"
							/>
						</div>
						<div class="error no-margin" data-ng-show="addScheduleForm.$submitted && $ctrl.freqType === 'MONTHLY_RELATIVE' && $ctrl.monthlyScheduleWeekOfMonth.length === 0">{{ 'error.monthlyScheduleCustomWeek' | cvLoc }}</div>
						<div class="error no-margin" data-ng-show="addScheduleForm.$submitted && $ctrl.freqType === 'MONTHLY_RELATIVE' && $ctrl.monthlyScheduleDayOfWeek.length === 0">{{ 'error.monthlyScheduleCustomDay' | cvLoc }}</div>
					</div>
				</div>
			</div>

			<div data-ng-if="$ctrl.freqType && $ctrl.freqType !== 'ONE_TIME'">
				<!-- Repeat -->
				<h4 class="margin-top-20">{{ 'label.repeat' | cvLoc }}</h4>
				<div class="form-group row">
					<label class="col-xs-12 col-sm-5">{{ 'label.every' | cvLoc }}</label>
					<div class="col-xs-12 col-sm-7">
						<input type="number" name="repeatDuration" min="1" id="repeatFrequency" data-ng-model="$ctrl.repeatDuration" />
						<span data-ng-if="$ctrl.freqType === 'DAILY'">
							<span>&nbsp;</span><label for="repeatFrequency" class="inline-label">{{ 'label.days' | cvLoc }}</label>
						</span>
						<span data-ng-if="$ctrl.freqType === 'WEEKLY'">
							<span>&nbsp;</span><label for="repeatFrequency" class="inline-label">{{ 'label.weeks' | cvLoc }}</label>
						</span>
						<span data-ng-if="$ctrl.freqType === 'MONTHLY' || $ctrl.freqType === 'MONTHLY_RELATIVE'">
							<span>&nbsp;</span><label for="repeatFrequency" class="inline-label">{{ 'label.repeatMonths' | cvLoc }}</label>
						</span>
						<div class="error no-margin" data-ng-show="addScheduleForm.$submitted && addScheduleForm.repeatDuration.$invalid">{{ 'error.repeatDuration' | cvLoc }}</div>
					</div>
				</div>

				<!-- Exceptions -->
				<div class="form-group row">
					<div class="col-xs-12 col-sm-12">
						<cv-toggle-accordion accordion-label="{{ 'label.exceptions' | cvLoc }}" click-header="$ctrl.toggleException()" collapsed="$ctrl.exceptionsEnabled" help-text="'info.scheduleException' | cvLoc">
							<div data-ng-include="appUtil.appRoot + 'ediscovery/components/schedule/templates/scheduleExceptions.template.html'"></div>
						</cv-toggle-accordion>
					</div>
				</div>
			</div>
		</div>

		<div class="modal-footer padding-right-20">
			<button type="button" class="btn btn-default cvBusyOnAjax" data-ng-if="$ctrl.scheduleExists && !$ctrl.hideDelete" data-ng-click="$ctrl.deleteSchedule()">{{ 'label.action.delete' | cvLoc }}</button>
			<button type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="$ctrl.cancelSchedule()">{{ 'action.cancel' | cvLoc }}</button>
			<button type="submit" class="btn btn-primary cvBusyOnAjax">{{ 'action.save' | cvLoc }}</button>
		</div>
	</form>
</div>
