<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<!-- Spinner -->
<div data-ng-if="!ctrl.pageReady && !ctrl.error" class="ajax-loader-container">
	<img class="ajax-loader" src="common/img/loader.gif">
</div>

<!-- Error -->
<div data-ng-if="ctrl.error">
	<span data-ng-bind="ctrl.errorMessage" class="error"></span>
</div>

<!-- Ready, now load page-->
<div data-ng-if="ctrl.pageReady">
	<!-- KPIs -->
	<div class="row custom-data-cube-query-row">
		<div class="col-xs-12">
			<cv-tile-component included-svg="false">
				<div class="kpi text-align-center padding-top-15">
					<cv-entity-pane entities="ctrl.kpiObject"></cv-entity-pane>
				</div>
			</cv-tile-component>
		</div>
	</div>

	<!-- OR filters -->
	<div data-ng-repeat="orFilter in ctrl.orFilters track by $index" class="row custom-data-cube-query-row">
		<div class="col-xs-12">
			<cv-tile-component included-svg="false">
				<div class="row text-align-right margin-top-10-minus" data-ng-if="$index !== 0">
					<span class="glyphicon glyphicon-remove cursor-pointer" data-ng-click="ctrl.removeOrFilter($index)"></span>
				</div>
				<!-- AND filters -->
				<div data-ng-repeat="andFilter in orFilter.andFilters track by $index">
					<div class="row custom-data-cube-query-row">
						<div class="col-xs-4">
							<isteven-multi-select
								class="isteven-multi-select user-group-select"
								input-model="andFilter.fields"
								button-label="displayName"
								item-label="displayName"
								output-model="andFilter.selectedFields"
								tick-property="selected"
								translation="ctrl.localLang"
								helper-elements="filter"
								selection-mode="single"
								prevent-sort="true"
								search-limit="1"
								on-item-click="ctrl.onFieldSelect(andFilter)"
							/>
						</div>

						<!-- Date type -->
						<div data-ng-if="andFilter.isDateType">
							<div class="col-xs-3">
								<isteven-multi-select
									class="isteven-multi-select user-group-select"
									input-model="andFilter.operators"
									button-label="name"
									item-label="name"
									output-model="andFilter.selectedOperators"
									tick-property="selected"
									translation="ctrl.localLang"
									helper-elements=""
									selection-mode="single"
									prevent-sort="true"
								/>
							</div>
							<div class="col-xs-2">
								<input type="number" data-ng-model="andFilter.fieldValue" placeholder="Value">
							</div>
							<div class="col-xs-2">
								<isteven-multi-select
									class="isteven-multi-select user-group-select"
									input-model="andFilter.units"
									button-label="name"
									item-label="name"
									output-model="andFilter.selectedUnits"
									tick-property="selected"
									translation="ctrl.localLang"
									helper-elements=""
									selection-mode="single"
									prevent-sort="true"
								/>
							</div>
						</div>

						<!-- Size type -->
						<div data-ng-if="andFilter.isSizeType">
							<div class="col-xs-3">
								<isteven-multi-select
									class="isteven-multi-select user-group-select"
									input-model="andFilter.operators"
									button-label="name"
									item-label="name"
									output-model="andFilter.selectedOperators"
									tick-property="selected"
									translation="ctrl.localLang"
									helper-elements=""
									selection-mode="single"
									prevent-sort="true"
								/>
							</div>
							<div class="col-xs-2">
								<input type="number" data-ng-model="andFilter.fieldValue" placeholder="Value" data-ng-disabled="andFilter.selectedOperators[0].disableInput">
							</div>
							<div class="col-xs-2">
								<isteven-multi-select
									class="isteven-multi-select user-group-select"
									input-model="andFilter.units"
									button-label="name"
									item-label="name"
									output-model="andFilter.selectedUnits"
									tick-property="selected"
									translation="ctrl.localLang"
									helper-elements=""
									selection-mode="single"
									prevent-sort="true"
									is-disabled="andFilter.selectedOperators[0].disableInput"
								/>
							</div>
						</div>

						<!-- Number type -->
						<div data-ng-if="andFilter.isNumberType">
							<div class="col-xs-3">
								<isteven-multi-select
									class="isteven-multi-select user-group-select"
									input-model="andFilter.operators"
									button-label="name"
									item-label="name"
									output-model="andFilter.selectedOperators"
									tick-property="selected"
									translation="ctrl.localLang"
									helper-elements="filter"
									selection-mode="single"
									prevent-sort="true"
								/>
							</div>
							<div class="col-xs-4">
								<input type="number" class="min-width-100" data-ng-model="andFilter.fieldValue" placeholder="Value" data-ng-disabled="andFilter.selectedOperators[0].disableInput">
							</div>
						</div>

						<!-- String type -->
						<div data-ng-if="andFilter.isStringType">
							<div class="col-xs-3">
								<isteven-multi-select
									class="isteven-multi-select user-group-select"
									input-model="andFilter.operators"
									button-label="name"
									item-label="name"
									output-model="andFilter.selectedOperators"
									tick-property="selected"
									translation="ctrl.localLang"
									helper-elements="filter"
									selection-mode="single"
									prevent-sort="true"
								/>
							</div>
							<div class="col-xs-4">
								<input type="text" data-ng-model="andFilter.fieldValue" placeholder="Value" data-ng-disabled="andFilter.selectedOperators[0].disableInput">
							</div>
						</div>

						<!-- Spacing -->
						<div data-ng-if="!andFilter.isNumberType && !andFilter.isDateType && !andFilter.isSizeType && !andFilter.isStringType">
							<div class="col-xs-7"></div>
						</div>

						<div class="col-xs-1 padding-top-10 padding-left-0 padding-right-0">
							<span class="glyphicon glyphicon-minus cursor-pointer margin-right-5 vertical-bottom" data-ng-click="ctrl.removeAndFilter($index, $parent.$parent.$index)" data-ng-if="$index !== 0"></span>
							<span class="glyphicon glyphicon-plus cursor-pointer vertical-bottom" data-ng-click="ctrl.addAndFilter($parent.$parent.$index)" data-ng-if="$index === orFilter.andFilters.length - 1"></span>
						</div>
						<div class="col-xs-12" data-ng-if="orFilter.andFilters.length > 1 && $index !== orFilter.andFilters.length - 1">
							<h4 class="margin-bottom-5"><cv:msg key="label.casemanager.filter.and" bundle="ediscovery"/></h4>
						</div>
					</div>
				</div>
				<!-- AND filters loop END -->
			</cv-tile-component>
			<div class="col-xs-12" data-ng-if="ctrl.orFilters.length > 1 && $index !== ctrl.orFilters.length - 1">
				<h4 class="margin-top-0"><cv:msg key="label.casemanager.filter.or" bundle="ediscovery"/></h4>
			</div>
		</div>
	</div>
	<!-- OR filters loop END -->

	<div class="row custom-data-cube-query-row padding-top-10">
		<div class="col-xs-3">
			<button type="button" class="btn btn-default btn-block cvBusyOnAjax" data-ng-click="ctrl.addOrFilter()"><cv:msg key="label.casemanager.addCriteria" bundle="ediscovery"/></button>
		</div>
		<div class="col-xs-3">
			<button type="button" class="btn btn-primary btn-block cvBusyOnAjax" data-ng-click="ctrl.search()"><cv:msg key="label.test" bundle="settings"/></button>
		</div>
    </div>
</div>
