<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div class="setup-title">
   <h3>
	  <cv:msg key="label.saveQuery" bundle="ediscovery" /> {{saveQueryCtrl.display}}
   </h3>
</div>
<div class="setup-content">
  <div class="bootstrap-wrapper form-horizontal">
		 <p class="{{saveQueryCtrl.serverMessage.type}} serverMessage" data-ng-bind="saveQueryCtrl.serverMessage.message"></p>
		<form id="saveQueryForm" name="saveQueryForm" class="form-horizontal" cv-hide-api data-cv-submit="saveQueryCtrl.saveQuery()" novalidate	autocomplete="off">
		<div class="panel-body">
		<div class="form-group row">
				<label class="col-xs-12 col-md-4" for="queryName">
					<cv:msg key="label.queryName" bundle="ediscovery" /></label>
				<div class="col-xs-12 col-md-8">
					<input name="queryName" id="queryName" class="crop" type="text" data-ng-model="saveQueryCtrl.queryName" required/>
				</div>
		</div>

		<div class="form-group row" data-ng-show='!saveQueryCtrl.isCaseSearch'>
			<label class="col-xs-12 col-md-4 col-lg-4"><cv:msg
					key="label.querySet" bundle="ediscovery" /></label>
			<div class="col-xs-12 col-md-7 col-lg-7">
				<isteven-multi-select id="saveQuery_isteven-multi-select_#9992"
					input-model="saveQueryCtrl.querySetList"
					output-model="saveQueryCtrl.selectedQuerySet"
					selection-mode="single"
					button-label="containerFullName" item-label="containerFullName"
					selection-mode="single" tick-property="selected"
					helper-elements="filter" is-required="!saveQueryCtrl.isCaseSearch">
				</isteven-multi-select>
				</div>
			<div class="col-xs-12 col-md-1 col-lg-1">
				<a title='<cv:msg key="label.createQuerySet" bundle="ediscovery" />'>
					<span class="k-icon k-i-plus-outline cursor-pointer"
					data-ng-click="saveQueryCtrl.openQuerySetModal()"></span>
				</a>
			</div>
      </div>


		<div class="button-container">
				<button id="createExportSet_button_#8018" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="saveQueryCtrl.cancel()">
					<cv:msg key="action.cancel" bundle="ediscovery" /></button>
				<button id="createExportSet_button_#0510" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled ="saveQueryForm.$invalid || saveQueryCtrl.disableSubmit">
					<cv:msg key="action.save" bundle="profiles" /></button>
			</div>
		</form>
	</div>
</div>
