<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div class='setup-title'>
    <h1><cv:msg key="label.refreshInventory" bundle="ediscovery"/> - {{inventoryName}} </h1>
</div>
<span class="serverMessage error" data-ng-class="alert-danger" data-ng-if="isLoaded && errorMsg">{{errorMsg}}</span>
<div class="modal-body">
    <span data-ng-show="!isLoaded" class="grid-data-spinner ng-hide">
		<img src="${pageContext.request.contextPath}/common/img/ajax-loader.gif" alt='<cv:msg key="Loading" bundle="messages"/>'>
	</span>
        <div class="form-group" data-ng-if="isLoaded && errorMsg === null">
            <div data-ng-if="hasAsset">
                <span><cv:msg key="label.refreshInventoryModal" bundle="ediscovery"/></span>
                <ul class="margin-top-20 margin-left-20">
                    <li data-ng-repeat="asset in asset_list track by $index" class="margin-top-10"><a href="${pageContext.request.contextPath}/#/{{asset.link}}" target="_blank">{{$index + 1}}. {{asset.name}}</a></li>
                </ul>
            </div>
            <div data-ng-if="!hasAsset">
                <span><cv:msg key="label.refreshInventoryNoAsset" bundle="ediscovery"/></span>
            </div>
        </div>
        <div class='modal-footer'>
            <button type='button' class='btn' data-ng-click='cancel()'><cv:msg key="Cancel" bundle="messages"/></button> 
            <button type='submit' class='btn btn-primary' data-ng-click="startJob()" ng-disabled="errorMsg"><cv:msg key="label.datasource.startJob" bundle="ediscovery"/></button>
        </div>
    </div>
</div>