
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.userPermissions"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<h2 class="page-title"><cv:msg key="label.userPermissions" bundle="ediscovery" /></h2>
<div class="permission-report-content bootstrap-wrapper form-horizontal">
<div class="form-group">
<div class="top-filter-wrapper">
	<div class="filter-btn" id="client-filter" data-ng-click="permCtrl.setShowClientFilter($event, true)" data-ng-class="{selected:permCtrl.isClientSelected()}"
		data-ng-disabled="permCtrl.isClientGroupSelected()"  >
		<span class="filter-btn-label">{{permCtrl.getClientLabel()}} </span>
		<span class="filter-btn-icon caret" data-ng-if="!permCtrl.isClientSelected()" ></span>
		<span class="filter-btn-icon cross-mark" data-ng-if="permCtrl.isClientSelected()" data-ng-click="permCtrl.clearClientSelection($event)">X</span>
		<div class="filter-content" data-ng-show="permCtrl.isShowClientFilter()">
			<ul>
				<li data-ng-repeat="client in permCtrl.clientList" data-ng-click="permCtrl.onClientSelect($event,  client)"  class="filter-list-item">
					<span> &#10004;</span>
					{{client.hostName}}
				</li>
			</ul>
		</div>
	</div>
</div>
<div class="top-filter-wrapper">
	<div class="filter-btn" id="client-group-filter" data-ng-click="permCtrl.setShowClientGroupFilter($event, true)" data-ng-class="{selected:permCtrl.isClientGroupSelected()}"
		data-ng-disabled="permCtrl.isClientSelected()">
		<span class="filter-btn-label">{{permCtrl.getClientGroupLabel()}} </span>
		<span class="filter-btn-icon caret" data-ng-if="!permCtrl.isClientGroupSelected()" ></span>
		<span class="filter-btn-icon cross-mark" data-ng-if="permCtrl.isClientGroupSelected()" data-ng-click="permCtrl.clearClientGroupSelection($event)">X</span>
		<div class="filter-content" data-ng-show="permCtrl.isShowClientGroupFilter()">
			<ul>
				<li data-ng-repeat="clientGroup in permCtrl.clientGroupList" data-ng-click="permCtrl.onClientGroupSelect($event,  clientGroup)"  class="filter-list-item">
					<span> &#10004;</span>
					{{clientGroup.name}}
				</li>
			</ul>
		</div>
	</div>
</div>
<div class="top-filter-wrapper">
<button class="apply-btn btn btn-primary cvBusyOnAjax" 
	id="permissionsReport_button_#7524"
	data-ng-class="{disabled:(!permCtrl.isClientSelected() && !permCtrl.isClientGroupSelected())}" 
	ng-click="permCtrl.applyInputs()">
	<cv:msg key="label.apply" bundle="userPermissions" />
</button>
</div>
<div class="top-filter-wrapper">
	<div class="filter-btn post-filter"  data-ng-click="permCtrl.setShowPostFilter($event, true)">
		<span class="filter-btn-label"><cv:msg key="label.filters" bundle="userPermissions" /></span>
		<span class="filter-btn-icon caret"></span>
		<div class="filter-content" data-ng-show="permCtrl.isShowPostFilter()">
			<div class="filter-header">
				<span><cv:msg key="label.filters" bundle="userPermissions" /></span>
				<span class="filter-btn-icon close-filter-btn" data-ng-click="permCtrl.closePostFilter($event)">X</span>
			</div>
			<div class="post-filter-content-wrapper">
				<div class="post-filter-nav col-lg-3">
					<ul>
						<li class="post-filter-item" data-ng-click="permCtrl.onSelectPostFilter($event, 'owners')"  data-ng-class="{selected:permCtrl.selectedPostFilter == 'owners'}">
							<span><cv:msg key="label.owners" bundle="userPermissions" /></span>
						</li>
						<li class="post-filter-item" data-ng-click="permCtrl.onSelectPostFilter($event, 'extensions')"  data-ng-class="{selected:permCtrl.selectedPostFilter == 'extensions'}">
							<span><cv:msg key="label.extensions" bundle="userPermissions" /></span>
						</li>
					</ul>
				</div>
				<div class="post-filter-side-panel col-lg-9">
					<div class="post-filter-content user-content" data-ng-show="permCtrl.selectedPostFilter == 'owners'">
						<cv-file-owners
							ctrl="permCtrl.ctrl">
						</cv-file-owners>
					</div>
					<div class="post-filter-content" data-ng-show="permCtrl.selectedPostFilter == 'extensions'">
						<div class="margin-top-10">
							<label for="extensionsToggle"><h5 class="font-weight-bold"><cv:msg key="label.allExtensions" bundle="userPermissions" /></h5></label>
							<toggle-control id="extensionsToggle" status="permCtrl.filters.extensions.allExtensions" data-ng-click="permCtrl.onAllExtensionSelect()" true-property="true" false-property="false" class="margin-left-20" title="Toggle to change extensions"></toggle-control>
						</div>
						<div  class="margin-top-10">
							<ul>
								<li class="extension-item col-sm-3 col-md-3" data-ng-repeat="ext in permCtrl.filters.extensions.list">
									<input id="{{ext.name}}" type="checkbox" data-ng-model="ext.selected" data-ng-disabled="!permCtrl.isExtensionEditable()"/>
									<label for="{{ext.name}}">{{ext.name}}</label>
								</li>
							</ul>
						</div>
					</div>
					<div class="button-container">
						<button id="permissionsReport_button_#8920" type="button" data-ng-if="!setup" class="btn btn-default" data-ng-click="permCtrl.closePostFilter($event)"><cv:msg key="label.cancel" bundle="userPermissions" /></button> 
						<button id="permissionsReport_button_#6161" type="submit" class="btn btn-primary" data-ng-click="permCtrl.applyPostFilters()"><cv:msg key="label.apply" bundle="userPermissions" /></button> 
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
</div>
<div class="form-group panel permissions-report-top">
<div class="col-lg-12 filter-summary" data-ng-if="permCtrl.isFilterApplied()">
	<h4><cv:msg key="label.filtersApplied" bundle="userPermissions" /></h4>
	<div data-ng-if="permCtrl.filteredUsers !=''">
		<label class="col-lg-1"><cv:msg key="label.owners" bundle="userPermissions" /></label>
		<label class="col-lg-11">{{permCtrl.filteredUsers}}</label>
	</div>
	<div data-ng-if="permCtrl.isFilterExtension()">
		<label class="col-lg-1"><cv:msg key="label.extensions" bundle="userPermissions" /></label>
		<label class="col-lg-11">{{permCtrl.filteredExtensions}}</label>
	</div>
</div>
<div class="col-lg-6">
	<div  data-ng-app="reports" data-ng-controller="reportsCtrl" data-ng-init="init(null, 'Directory Tree')" class="permissions-report">
	<div id="pageDiv" data-ng-controller="pageController" class="maskLayer" data-ng-class="{'isMasked':masked}" >
	<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/viewerPage.jsp'"></div>
	</div>
	</div>
</div>
<div class="col-lg-6">
<div>
<div class="form-group edit-permissions">
<div class="col-lg-6">
<h4><cv:msg key="label.permissions" bundle="userPermissions" /></h4>
</div>
<div class="col-lg-6">
<span class="float-right">

<button class="btn btn-primary"
	id="permissionsReport_button_#7925"
	data-ng-if="permCtrl.Utils.keys(permCtrl.user_permissions).length > 0" 
	ng-click="permCtrl.editPermissions(permCtrl.user_permissions,permCtrl.url)">
	<cv:msg key="label.editPermissions" bundle="userPermissions" />
</button>

</span>
</div>
</div>
<label class="edit-permissions-label"><span data-ng-bind="permCtrl.url"></span></label>
<table class="edit-permissions-table table table-striped">
	<tr class="permissions-modal-table-row" data-ng-repeat="(key,value) in permCtrl.user_permissions">
		<td>{{key}}</td>
		<td ng-class="{permissionsAdded: value.read, permissionsRevoked: !value.read}"><cv:msg key="label.read" bundle="userPermissions" /></td>
		<td ng-class="{permissionsAdded: value.write, permissionsRevoked: !value.write}"><cv:msg key="label.write" bundle="userPermissions" /></td>
		<td ng-class="{permissionsAdded: value.execute, permissionsRevoked: !value.execute}"><cv:msg key="label.execute" bundle="userPermissions" /></td>
		<td ng-class="{permissionsAdded: value.full, permissionsRevoked: !value.full}"><cv:msg key="label.full" bundle="userPermissions" /></td>
	</tr>
</table>
<label class="permissions-help" data-ng-if="permCtrl.Utils.keys(permCtrl.user_permissions).length > 0"><cv:msg key="message.permissions.help" bundle="userPermissions"/></label>
</div>
</div>
</div>
</div>
