<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="form-group">
	<label class="col-xs-12 col-md-3 col-lg-3" for="addTaskMultiSelect">
    	<cv:msg key="label.taskmanager.selectFields" bundle="ediscovery" />
    </label>
    <div class="col-xs-12 col-md-9 col-lg-9">
        <isteven-multi-select max-labels="3" input-model="categorizedEntities" output-model="selectedEntities" button-label="displayName" item-label="displayName" tick-property="ticked" class="isteven-multi-select user-group-select" id="addEntityMultiSelect" name="addEntityMultiSelect" helper-elements="filter" translation="entitiesText" group-property="group">
        </isteven-multi-select>
    </div>
</div>
<div class="row">
    <hr class="col-xs-12 col-md-12 col-lg-12" data-ng-show="selectedEntities.length > 0">
</div>
<div class="limit-modal-height margin-0 hide-x-scrollbar">
    <div class="form-group" data-ng-repeat="entity in selectedEntities">
        <label class="col-xs-12 col-md-3 col-lg-3 word-break-rule" for="{{entity.entityId}}" title="{{entity.displayName}}">{{entity.displayName}}</label>
        <div class="col-xs-11 col-md-8 col-lg-8">
            <input type="{{entity.validator.type}}" id="{{entity.entityId}}" name="{{entity.entityId}}" data-ng-model="entity.value" data-ng-model-options="{ debounce : 100}" data-ng-attr-placeholder="<cv:msg key='label.enter' bundle='ediscovery' /> {{entity.displayName}}" ng-required="entity.entityType != 4" ng-disabled="entity.entityType == 4"/>
        </div>
        <a data-ng-click="removeEntity(entity)" class="col-xs-1 col-md-1 col-lg-1" title="<cv:msg key='label.remove' bundle='ediscovery' /> {{entity.displayName}}"><i class="glyphicon glyphicon-remove" style="padding-top: 13px;"></i></a>
    </div>
</div>