<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.tags"></cv:cvMessages>
</script>
<div class="row report-review">
	<div class="col-md-12">
		<div class="row">
			<div data-ng-class="(hideDetailsPane && !dataSource.enableMonitoring)  ? 'col-md-12' : 'col-md-9'">
				<cvfilterandsearch filter-search-config="filterSearchConfig" on-loaded="onLoaded" show-filters="showFilters" on-grid-data-bound="onGridDataBound">
				</cvfilterandsearch>
			</div>
			<div class="col-md-3 details-right-pane" data-ng-if="!hideDetailsPane || dataSource.enableMonitoring">
				<div class="margin-top-10 all-files-toggle" data-ng-if="showSensitivityToggle">
					<cv-toggle toggle-name="displaySensitiveFilesOnly" on-click="toggleFileListDisplay()" toggle-label="{{toggleLabel}}" value="displaySensitiveFilesOnly" help-text="toggleHintLabel"></cv-toggle>
				</div>
				<div id="action-icons-tab" data-ng-if="showResolveActions">
                    <cv-resolve-actions ds-type="dsType" get-selected-items="getSelectedItems()" get-data-source-name="getDataSourceName()"
						handler-Id="handlerId" client-Id="clientId" risk-list="riskList" handler-url="dataHandlerUrl" selected-tab="'projectReview'"
						include-sensitive="includeSensitive" refresh-grid-event="refreshGridEvent()">
					</cv-resolve-actions>
                </div>
				<div class="details-pane-content">
					<div class="count-selected-items">
						<span>
							{{selectedRows.length}} <cv:msg key="label.taskdetail.itemsSelected" bundle="ediscovery" />
						</span>
					</div>
					<div class="none-selected" data-ng-show="selectedRows.length == 0">
						<h4><cv:msg key="label.taskdetail.selectItem" bundle="ediscovery" /></h4>
					</div>
					<div data-ng-if="!hideDetailsPane && !isFSO">
						<div data-ng-if="numRisks.total>0 && showRisks">
							<uib-accordion>
							<div uib-accordion-group is-open="true">
								<uib-accordion-heading>
								<div class="detail-header">
									<h4 class="no-margin">
										<span><cv:msg key="label.taskdetail.risks"
												bundle="ediscovery" /></span> <span
											class="badge badge-wide pull-right">{{numRisks.total}}</span>
									</h4>
								</div>
								</uib-accordion-heading>
								<div class="{{performActionMessage.type}} performActionMessage"
									data-ng-bind="performActionMessage.message"></div>
								<div class="category-filter-buttons">
									<label data-ng-show="numRisks.critical>0" for="criticalRisk"
										class="btn btn-sm btn-risk risk-critical"><img
										class="risk-icon"
										src="ediscovery/common/img/critical-risk-icon.svg"></img><span
										class="risk-btn-name"><cv:msg
												key="label.taskDetail.critical" bundle="ediscovery" /></span><input
										type="checkbox"
										data-ng-click="filterRisks(criticalRisk, 'critical')"
										data-ng-model="criticalRisk" id="criticalRisk" class="badgebox"><span
										class="risk-selected">&check;</span></label> <label
										data-ng-show="numRisks.high>0" for="highRisk"
										class="btn btn-sm btn-risk risk-high"><img
										class="risk-icon" src="ediscovery/common/img/high-risk-icon.svg"></img><span
										class="risk-btn-name"><cv:msg key="label.taskDetail.high"
												bundle="ediscovery" /></span> <input type="checkbox" id="highRisk"
										data-ng-click="filterRisks(highRisk, 'high')"
										data-ng-model="highRisk" class="badgebox"><span
										class="risk-selected">&check;</span></label> <label
										data-ng-show="numRisks.moderate>0" for="moderateRisk"
										class="btn btn-sm btn-risk risk-moderate"><img
										class="risk-icon"
										src="ediscovery/common/img/moderate-risk-icon.svg"></img><span
										class="risk-btn-name"><cv:msg
												key="label.taskDetail.moderate" bundle="ediscovery" /></span><input
										type="checkbox"
										data-ng-click="filterRisks(moderateRisk, 'moderate')"
										data-ng-model="moderateRisk" id="moderateRisk" class="badgebox"><span
										class="risk-selected">&check;</span></label>
								</div>
								<uib-accordion class="text-left risk-category">
								<div uib-accordion-group is-open="status.open" class="risk-type"
									data-ng-repeat="(riskType, riskObj) in riskMap"
									data-ng-if="riskObj.items.length>0 && riskObj.isFiltered">
									<uib-accordion-heading> <span
										class="{{riskObj.level}}"><img class="risk-icon"
										src="ediscovery/common/img/{{riskObj.level}}-risk-icon.svg"></img>{{::'risks.'+riskType
										| cvLoc : dataSourceSuffixLabel}}</span> <i class="pull-right glyphicon"
										ng-class="{'glyphicon-chevron-down': status.open, 'glyphicon-chevron-right': !status.open}"></i>
									<span class="badge badge-wide pull-right">{{riskObj.items.length}}</span>
									</uib-accordion-heading>
									<div class="file-list">
										<form name="{{riskType}}-items">
											<div class="checkbox" data-ng-repeat="item in riskObj.items">
												<input type="checkbox" id="{{riskType + $index}}"
													data-ng-model="isFileSelected[riskType + $index]"
													data-ng-click="selectFileItem(item, isFileSelected[riskType + $index])"
													data-ng-checked="true"> <label
													for="{{riskType + $index}}">{{item.FileName}}</label>
											</div>
										</form>
									</div>
								</div>
								</uib-accordion>
							</div>
							</uib-accordion>
						</div>
						<div data-ng-if="numSensitive.total>0 && isSensitive">
							<uib-accordion>
							<div uib-accordion-group is-open="true">
								<uib-accordion-heading>
								<div class="detail-header">
									<h4 class="no-margin">
										<span><cv:msg key="label.taskdetail.sensitivity"
												bundle="ediscovery" /></span> <span
											class="badge badge-wide pull-right">{{numSensitive.total}}</span>
									</h4>
								</div>
								</uib-accordion-heading>
								<div class="category-filter-buttons">
									<label data-ng-show="numSensitive.critical>0"
										for="criticalSensitivity"
										class="btn btn-sm btn-risk risk-critical"><img
										class="risk-icon"
										src="ediscovery/common/img/critical-risk-icon.svg"></img><span
										class="risk-btn-name"><cv:msg
												key="label.taskDetail.critical" bundle="ediscovery" /></span><input
										type="checkbox"
										data-ng-click="filterSensitivity(criticalSensitivity, 'critical')"
										data-ng-model="criticalSensitivity" id="criticalSensitivity"
										class="badgebox"><span class="risk-selected">&check;</span></label>
									<label data-ng-show="numSensitive.high>0" for="highSensitivity"
										class="btn btn-sm btn-risk risk-high"><img
										class="risk-icon" src="ediscovery/common/img/high-risk-icon.svg"></img><span
										class="risk-btn-name"><cv:msg key="label.taskDetail.high"
												bundle="ediscovery" /></span> <input type="checkbox"
										id="highSensitivity"
										data-ng-click="filterSensitivity(highSensitivity, 'high')"
										data-ng-model="highSensitivity" class="badgebox"><span
										class="risk-selected">&check;</span></label> <label
										data-ng-show="numSensitive.moderate>0" for="moderateSensitivity"
										class="btn btn-sm btn-risk risk-moderate"><img
										class="risk-icon"
										src="ediscovery/common/img/moderate-risk-icon.svg"></img><span
										class="risk-btn-name"><cv:msg
												key="label.taskDetail.moderate" bundle="ediscovery" /></span><input
										type="checkbox"
										data-ng-click="filterSensitivity(moderateSensitivity, 'moderate')"
										data-ng-model="moderateSensitivity" id="moderateSensitivity"
										class="badgebox"><span class="risk-selected">&check;</span></label>
								</div>
								<uib-accordion class="text-left risk-category">
								<div uib-accordion-group is-open="sensitivityObj.open"
									class="risk-type"
									data-ng-repeat="sensitivityObj in sensitivityMap"
									data-ng-if="sensitivityObj.items.length>0 && sensitivityObj.isFiltered">
									<uib-accordion-heading> <span
										class="{{sensitivityObj.level}}"><img class="risk-icon"
										src="ediscovery/common/img/{{sensitivityObj.level}}-risk-icon.svg"></img>{{sensitivityObj.displayName}}</span>
									<i class="pull-right glyphicon"
										ng-class="{'glyphicon-chevron-down': sensitivityObj.open, 'glyphicon-chevron-right': !sensitivityObj.open}"></i>
									<span class="badge badge-wide pull-right">{{sensitivityObj.numItems}}</span>
									</uib-accordion-heading>
									<div class="file-list">
										<form name="{{sensitivityObj.name}}-items">
											<span class="alert-warning" data-ng-show="sensitivityObj.numItems>RESTRICT_NUM_ENTITIES">{{'info.listRestricted' | cvLoc : sensitivityObj.items.length : sensitivityObj.numItems}}</span>
											<div data-ng-repeat="item in sensitivityObj.items">
												<img class="sensitivity-icon"
													src="ediscovery/common/img/sensitivity-icons/{{sensitivityObj.icon}}.svg"></img>
												<label class="sensitivity-item-title"
													for="{{item.name + $index}}">{{item.name}}</label>
											</div>
										</form>
									</div>
								</div>
								</uib-accordion>
							</div>
						</uib-accordion>
						</div>
						<!-- <div data-ng-if="selectedRows.length === 1 && showUserAccessReport">
	                        <uib-accordion>
								<div uib-accordion-group is-open="true">
									<uib-accordion-heading>
									<div class="detail-header">
										<h4 class="no-margin">
											<span><cv:msg key="label.userAccess" bundle="ediscovery" /></span>
										</h4>
									</div>
									</uib-accordion-heading>
									<file-user-access access-info="userAccessInfo"></file-user-access>
								</div>
	                        </uib-accordion>
						</div> -->
					</div>
					<div data-ng-if="!hideTags && isFSO && selectedRows.length > 0">
						<uib-accordion>
							<div uib-accordion-group is-open="true">
								<uib-accordion-heading>
									<div class="deail-header">
										<h4 class="no-margin">
											<span><cv:msg key="label.tags" bundle="tags" /></span>
											<span class="badge badge-wide pull-right">{{numTags}}</span>
										</h4>
									</div>
								</uib-accordion-heading>
								<!-- single file selected -->
								<div data-ng-if="tags.length > 0">
									<ul class="review-page-tags">
										<li class="review-page-tag" data-ng-repeat="tag in tags track by $index" data-ng-mouseenter="hover = true" data-ng-mouseleave="hover = false">
											<span>{{tag.tagName}}</span>
											<span class="glyphicon glyphicon-remove review-page-tag-remove-icon" data-ng-if="hover" data-ng-click="onRemoveTag(tag, $event)"></span>
										</li>
									</ul>
								</div>
								<!-- multiple files selected -->
								<uib-accordion data-ng-if="groupedTags.length > 0">
									<div uib-accordion-group is-open="status.open" data-ng-repeat="tag in groupedTags track by $index" class="review-page-tag-accordion">
										<uib-accordion-heading>
											<span class="review-page-tag no-margin" data-ng-mouseenter="hover = true" data-ng-mouseleave="hover = false">
												{{tag.tagName}}
												<span class="glyphicon glyphicon-remove review-page-tag-remove-icon" data-ng-if="hover" data-ng-click="onRemoveTag(tag, $event)"></span>
											</span>
											<i class="pull-right glyphicon" ng-class="{'glyphicon-chevron-down': status.open, 'glyphicon-chevron-right': !status.open}"></i>
											<span class="badge badge-wide pull-right">{{tag.files.length}}</span>
										</uib-accordion-heading>
										<ul class="review-page-tag-list">
											<li data-ng-repeat="file in tag.files">
												<span class="glyphicon glyphicon-file padding-right-5"></span>
												<span>{{file.fileName}}</span>
											</li>
										</ul>
									</div>
								</uib-accordion>
								<div class="pull-right padding-right-5">
									<a href="" data-ng-if="numTags > 0" data-ng-click="onRemoveAllTags()"><cv:msg key="label.removeAll" bundle="profiles" /></a>
								</div>
							</div>
						</uib-accordion>
					</div>
					<div data-ng-if="selectedRows.length === 1 && (projectReview || dataSource.enableMonitoring)">
						<file-monitoring datasource-id="dsId" content-id="selectedSingleRow.contentid" project-review="projectReview"></file-monitoring>
					</div>
			</div>
		</div>	
	</div>
</div>