<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	var getDetailedReport =  function(CountryCode) {
		var scope = angular.element($("#customDatasourceReport")).scope();
		if(scope)        
			scope.getDetailedReport(CountryCode);
	};
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.errorMap"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.tags"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ReportsPlusMessages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvEnum name="JobManager.JMBackupLevel"></cv:cvEnum>
	// Load ediscovery bundle last so same name keys have a priority over the rest
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div id="customDatasourceReport" data-ng-controller="datasourceDetailsController">
	<!-- To avoid jumping effect, show when data source name is available -->
	<div class="details-header">
		<h1 class="page-title">
			<span ng-if="!$state.is('failedFileReport') && !$state.is('fileMonitoringReport')"><img data-ng-show="!datasourceName" src="./img/loading.gif"></img>{{datasourceName}}</span>
			<span ng-if="$state.is('failedFileReport')"><cv:msg key="label.datasource.collectionReport" bundle="ediscovery"/>: {{datasourceName}}</span>
			<span data-ng-if="$state.is('fileMonitoringReport')"><cv:msg key="label.datasource.FileMonitoringReport" bundle="ediscovery"/>: {{datasourceName}}
			<span data-ng-if="showMonitoringAlert" data-ng-click="displayMonitoringAlert()" class="error alert-icon alert-icon-lg k-icon k-i-warning"></span></span>

		</h1>
		<a ng-if="(!($state.is('failedFileReport') || $state.is('fileMonitoringReport') || $state.is('inventoryAssetDetails'))) && !$state.is('analyticsAssetDetails')" data-ng-click="initiateDownloadReviewSet()" data-ng-disabled="disableDownload" class="cvBusyOnAjax">
			&nbsp;
			<span>{{'label.taskmanager.type.export' | cvLoc}}</span>
			<span class="glyphicon glyphicon-export"></span>
		</a>
		<a class="page-action-item margin-0 margin-right-10" data-ng-if="isDiscover()" data-ng-click="refreshDashboard()">{{'label.refresh' | cvLoc}}</a>
		<custom-data-cube-query-search class="float-right margin-0 margin-right-10 padding-top-2" data-ng-if="isFSO && isDiscover()" datasource-id="dataSource.id" refresh="refreshDashboard()"></custom-data-cube-query-search>
		
		<span class="grid-data-spinner" data-ng-show="disableDownload">
			<img src="common/img/ajax-loader.gif">
		</span>
		<ul data-ng-if="$state.is('datasourceReport')" class="nav nav-tabs reports-nav" role="tablist">
	        <li class="nav-item" data-ng-class="{'active': selectedTab == sensitiveReport}">
	            <a class="nav-link" data-toggle="tab" role="tab" data-ng-click="selectTab(sensitiveReport)">{{'label.dashboard' | cvLoc}}</a>
	        </li>
	        <li class="nav-item" data-ng-class="{'active': selectedTab == 'review'}">
	            <a class="nav-link" data-toggle="tab" role="tab" data-ng-click="selectTab('review')">{{'label.review' | cvLoc}}</a>
			</li>
			<li class="pull-right">
				<cv-resolve-actions data-ng-if="dataSource" ds-type="dsType" get-selected-items="getSelectedItems()" get-data-source-name="getDataSourceName()"
					handler-Id="dataSchema.handlerId" client-Id="dataSourceClientId" risk-list="riskList" selected-tab="selectedTab"
					sensitive-report="sensitiveReport" handler-url="dataSchema.searchUrl" refresh-grid-event="refreshGridEvent()"
					disabled-actions="disabledActions" include-sensitive="includeSensitive" datasource="dataSource">
				</cv-resolve-actions>
			</li>
		</ul>
	    <ul data-ng-if="$state.is('analyticsAssetDiscover')" class="nav nav-tabs reports-nav" role="tablist">
	        <li class="nav-item" data-ng-class="{'active': selectedTab !== 'review'}" data-ng-if="reportsObj && searchViews.length > 0">
	            <a data-toggle="dropdown" class="nav-link" data-toggle="tab" role="tab" data-ng-click="selectTab(reportsObj.searchViewName)">{{reportsObj.displayName}} <span class="caret" data-ng-if="searchViews.length > 1"></span></a>
	        	<ul class="dropdown-menu report-selection-dropdown" role="menu">
					<li data-ng-repeat="view in searchViews"><a href="" data-ng-click="setAnalyticsReportObj(view)">{{view.displayName}}</a></li>
				</ul>
			</li>
			<li class="nav-item" data-ng-class="{'active': selectedTab === 'review'}">
	            <a class="nav-link" data-toggle="tab" role="tab" data-ng-click="selectTab('review')">{{'label.review' | cvLoc}}</a>
	        </li>
			<li class="pull-right">
				<cv-resolve-actions data-ng-if="dataSource" ds-type="dsType" get-selected-items="getSelectedItems()" get-data-source-name="getDataSourceName()"
					handler-Id="dataSchema.handlerId" client-Id="$state.params.clientId" risk-list="riskList" selected-tab="selectedTab"
					sensitive-report="sensitiveReport" handler-url="dataSchema.searchUrl" include-sensitive="false" refresh-grid-event="refreshGridEvent()" hide-create-review-request="true" hidden-actions="hiddenActions"
					datasource="dataSource" disabled-actions="disabledActions">
				</cv-resolve-actions>
			</li>
	    </ul>
	</div>
	<div id="detailsArea" data-ng-if="$state.is('datasourceDetails') || $state.is('inventoryAssetDetails') || $state.is('analyticsAssetDetails')">
		<div class="row">
			<div class="col-md-6">
				<cv-tile-component data-ac-id="datasourceDetails-label_details-ediscovery" title='<cv:msg key="label.details" bundle="ediscovery"/>'>
				<ul class="list-style-secondary">
					<cv-data-source-property label="'label.datasourcename'" value="dataSource.displayName"></cv-data-source-property>
					<cv-data-source-property label="'label.type'" value="dataSource.typeDisplayName"></cv-data-source-property>
					<cv-data-source-property label="'label.assets.database.hostName'" value="dataSource.hostName"></cv-data-source-property>
					<cv-data-source-property label="'label.createdOn'" value="dataSource.createdTime"></cv-data-source-property>
					<cv-data-source-property label="'label.lastModified'" value="dataSource.modifiedTime"></cv-data-source-property>
				</ul>
				</cv-tile-component>
			</div>
			<div class="col-md-6">
				<cv-tile-component data-ng-if="ediscoveryInfo" data-ac-id="datasourceDetails-label_configuration-ediscovery" title='<cv:msg key="label.configuration" bundle="ediscovery"/>'>
					<div data-ng-if="dataSource.isEditable" class="page-details-box-links">
						<a href="" data-ng-click="editDatasource()">
							<cv:msg key="label.edit" bundle="ediscovery" />
						</a>
                    </div>
				<div data-ng-include="dataSource.configTemplatePath"></div>
				</cv-tile-component>
			</div>
		</div>
		<div class="ds-jobs-list" data-ng-if="!isInventory && dataSourceLoaded">
			<ul>
				<li class="action-item" data-ng-if="!isJobRunning">
					<a data-ng-click="dsJobModal()">{{'label.datasource.startJob' | cvLoc}}</a>
				</li>
				<li class="action-item" data-ng-if="isJobRunning">
					<a data-ng-click="initDataSourceJob(1)">{{'label.datasource.stopJob' | cvLoc}}</a>
				</li>
				<li class="action-item">
					<a data-ng-click="displayFailedReport()">{{'label.datasource.collectionReport' | cvLoc}}</a>
				</li>
				<li class="action-item" data-ng-if="isFSO && enableNetappMonitoring && dataSource.enableMonitoring && showMonitoringInfo">
					<a data-ng-click="displayFileMonitoringReport()">{{'label.datasource.FileMonitoringReport' | cvLoc}}</a>
					<span data-ng-if="showMonitoringAlert" data-ng-click="displayMonitoringAlert()" class="alert-icon k-icon k-i-warning"></span>
				</li>
				<li class="action-item" data-ng-if="dataSource.crawlType === '4'">
					<a data-ng-click="convertToFullScan()">{{ 'label.datasource.convertToFullScan' | cvLoc }}</a>
				</li>
			</ul>
			<ul class="nav-breadcrumbs__sub-tabs">
				<li ng-repeat="tab in jobsTabData track by $index" ng-class="{selected:selectedJobsTab==tab.id}" class="ng-scope" style="">
					<a data-ng-click="selectJobsTab(tab.id)">{{tab.title}}</a>
				</li>
			</ul>
            <div data-ng-controller="kendoController" data-ng-if="selectedJobsTab==='activeJobs'">
                <cv-kendo-grid data-cv-grid-options="gridOptions"></cv-kendo-grid>
            </div>
            <div data-ng-controller="jobListController" data-ng-if="selectedJobsTab==='jobHistory'">
                <cv-kendo-grid data-cv-grid-options="gridOptions"></cv-kendo-grid>
            </div>
		</div>
		<cv-grid data-ng-if="isInventory" cv-grid-options="crawlHistoryGridOptions"></cv-grid>
	</div>
	<div data-ng-if="$state.is('datasourceReport') || $state.is('analyticsAssetDiscover')">
		<div id="fileDetails">
			<div data-ng-if="reportsObj" id="reportArea">
				<div data-ng-if="selectedTab==view.reportName || selectedTab==view.searchViewName" data-ng-repeat="view in searchViewTabs">
					<div id="ng-app" data-ng-app="reports"
						data-ng-controller="reportsCtrl"
						data-ng-init="init(reportsObj.searchViewId, reportsObj.searchViewName, null, null, reportsObj.queryString, filterAcrossReports)">
						<div id="pageDiv" data-ng-controller="pageController"
							class="maskLayer" data-ng-class="{'isMasked':masked}">
							<report-filters data-ng-if="filterAcrossReports" class="position-relative" custom-classes="['padding-left-10', 'margin-top-15', 'margin-bottom-10-minus']"></report-filters>
							<div
								data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/viewerPage.jsp'"></div>
							<div data-ng-controller="reportsEventInterceptor"></div>
						</div>
					</div>
				</div>
			</div>
			<div data-ng-if="selectedTab=='review'">
				<div data-ng-controller="dataSourceReviewController">
					<!-- Need to wait for 'getColumnDefinitions' to be defined before initializing the filepreviewandaction directive -->
					<div data-ng-if="showGridControl && getColumnDefinitions" class="review-tab-content">
						<filepreviewandaction></filepreviewandaction>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div id="reportArea"  data-ng-if="$state.is('failedFileReport')">
		<div id="ng-app" data-ng-app="reports" data-ng-controller="reportsCtrl" data-ng-init="init(null, collectionReportName)">
			<div id="pageDiv" data-ng-controller="pageController" class="maskLayer" data-ng-class="{'isMasked':masked}" >
				<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/viewerPage.jsp'"></div>
			</div>
		</div>
	</div>
	<div id="reportArea" data-ng-if="$state.is('fileMonitoringReport') && queryString">
		<div id="ng-app" data-ng-app="reports" data-ng-controller="reportsCtrl" data-ng-init="init(null, 'File Monitoring',null,null,queryString)">
			<div id="pageDiv" data-ng-controller="pageController" class="maskLayer" data-ng-class="{'isMasked':masked}" >
				<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/viewerPage.jsp'"></div>
			</div>
		</div>
	</div>
</div>
