<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script>
	<cv:cvMessages bundle="localization.alerts"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div class="setup-title">
	<h3><cv:msg key="pageHeader.security" bundle="users" /></h3>
</div>
<div class="setup-content security-modal remove-top-padding">
	<span class="server-message {{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
		<div id="subclient-content-tab">
			<div class="add-users group extra-top-padding row">
				<div class="user-suggestion-single-select-wrapper">
					<input id="userList" name="userList" data-ng-model="userOrGroupInfo.user.userOrGroupName" data-ng-change="nameAndRoleSelected()" class="add-user-type" placeholder="<cv:msg key='placeholder.enterUserOrGroup' bundle='alerts' />">
				</div>
					<%-- <select name="permissions" id="adduserId" class="add-user-type" data-ng-options="permission.permissionName for permission in availablePermissions | orderBy : 'permissionName'" data-ng-model="userOrGroupInfo.permission" data-ng-change="clearErrorMessage()" >
						<option value=""><cv:msg key="label.security.selectPermission" bundle="ediscovery" /></option>
					</select> --%>
				<div class="col-lg-5">
					<isteven-multi-select input-model="availablePermissions"
					output-model="userOrGroupInfo.permission" button-label="localizedName"
					item-label="localizedName" tick-property="ticked" on-reset="reset()"
					class="isteven-multi-select user-group-select"
					id="adduserId" name="permissions"
					on-item-click="clearErrorMessage()" helper-elements=""
					translation="permissionsText" prevent-sort="true"> </isteven-multi-select>
				</div>
				<div class="col-lg-1">				
					<button id="dataSourceSecurityAssociations_button_#6471" data-ng-click="addNewUserGroup()" data-ng-disabled="!nameAndRoleSelected()" class="btn btn-primary"><cv:msg key="Add" bundle="messages" /></button> 
				</div>
			</div>
			<div data-ng-if="isFSO" class="eventsIconSelector info-wrapper">
				<div class="info info-content">
					<cv:msg key='info.implicitBrowse' bundle='ediscovery' />
				</div>
			</div>
			<div data-ng-if="(inheritedAssociations.length + usersAndRolesList.length + creatorAssociations.length)==0" class="horz-center extra-top-padding"><cv:msg key="info.noSecurityAssociationsDefined" bundle="users" /></div>
			<div data-ng-if="(inheritedAssociations.length + usersAndRolesList.length + creatorAssociations.length)>0">
				<div class="peopleInfos ownerInfo modal-version">
					<div class="users-list limit-modal-height">
						<ul class="users-list__user group" data-ng-repeat="user in inheritedAssociations">
							<li><span class="{{user.cssName}}">
								<label data-id="{{user.userOrGroupId}}" class="inheritedSecurityAssociation ellipsis-parent ellipsis-content" data-ng-bind="user.userOrGroupName" title="{{user.userOrGroupName}}"></label>
									<label data-id="{{user.roleId}}" class="inheritedSecurityAssociation ellipsis-parent ellipsis-content" data-ng-bind="user.roleName" title="{{user.roleName}}"></label>
							</span></li>
						</ul>
						<ul class="users-list__user group" data-ng-repeat="user in creatorAssociations">
							<li><span class="{{user.cssName}}">
								<label data-id="{{user.userOrGroupId}}" class="inheritedSecurityAssociation ellipsis-parent ellipsis-content" data-ng-bind="user.userOrGroupName" title="{{user.userOrGroupName}}"></label>
									<label data-id="{{user.roleId}}" class="inheritedSecurityAssociation ellipsis-parent ellipsis-content larger-label" data-ng-bind="user.roleName" title="{{user.roleName}}"></label>
							</span></li>
						</ul>
						<ul class="users-list__user group" data-ng-repeat="user in usersAndRolesList">
							<li><span class="{{user.cssName}}">
								<label data-id="{{user.userOrGroupId}}" class="ellipsis-parent ellipsis-content user" data-ng-bind="user.userOrGroupName" title="{{user.userOrGroupName}}"></label>
								<label data-id="{{user.categoryPermission.categoriesPermissionList[0].permissionId}}" class="ellipsis-parent ellipsis-content role" data-ng-bind="user.roleName" title="{{user.roleName}}"> </label>
								<span class="delete-row"> <a href="" data-ng-click="removeUserAndRole(user)" title="Delete {{user.userOrGroupName}}">&times;</a></span>
							</span></li>
						</ul>
					</div>
				</div>
			</div>
		</div>
		<div class="button-container">
		  <button id="dataSourceSecurityAssociations_button_#7758" class="btn btn-default cvBusyOnAjax" data-ng-click="cancelUserOrGroupModal()"><cv:msg key="Cancel" bundle="messages" /></button> 
		  <button id="dataSourceSecurityAssociations_button_#8681" class="btn btn-primary cvBusyOnAjax" data-ng-click="submitUserOrGroupModal()"><cv:msg key="Save" bundle="messages" /></button> 
		</div>
</div>
