<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<cv-tile-component data-title='<cv:msg key="heading.Security" bundle="clients"/>' data-min-height="true" loader="associationsLoaded">
		<div>
			<span data-ng-show="associationsLoaded && !hasAnyAssociationsAvailable()">
				<p class="info-place-holder center"><cv:msg key="info.noSecurityAssociationsDefined" bundle="users" /> </p>
			</span>
			<div data-ng-show="associationsLoaded && hasAnyAssociationsAvailable()">
				<ul class="list-style-secondary">
					<li class="group">
						<span class="pageDetailColumn userGroupColumn"><b><cv:msg key="label.userOrGroupName" bundle="users" /></b></span>
						<span class="pageDetailColumn"><b><cv:msg key="label.permission" bundle="ediscovery" /></b></span>
					</li>
				</ul>
				<ul class="list-style-secondary" data-ng-repeat="user in associations.creatorAssociations">
					<li class="group" title="{{user.entityType}}">
						<span class="pageDetailColumn inheritedSecurityAssociation {{user.cssName}} userGroupColumn ellipsis-parent ellipsis-content" data-ng-bind="user.userOrGroupName" title="{{user.userOrGroupName}}"></span>
						<span class="pageDetailColumn inheritedSecurityAssociation ellipsis-parent ellipsis-content" data-ng-bind="user.roleName" title="{{user.roleName}}"></span>
					</li>
				</ul>
				<ul class="list-style-secondary" data-ng-repeat="user in associations.associations">
					<li class="group" title="{{user.entityType}}">
						<span class="pageDetailColumn {{user.cssName}} userGroupColumn ellipsis-parent ellipsis-content" data-ng-bind="user.userOrGroupName" title="{{user.userOrGroupName}}"></span>
						<span class="pageDetailColumn ellipsis-parent ellipsis-content" data-ng-bind="user.roleName" title="{{user.roleName}}"></span>
					</li>
				</ul>
				<ul data-ng-if="!hideInheritedAssociations" class="list-style-secondary" data-ng-repeat="user in associations.inheritedAssociations">
					<li class="group" title="{{user.entityType}}">
						<span class="pageDetailColumn inheritedSecurityAssociation {{user.cssName}} userGroupColumn ellipsis-parent ellipsis-content" data-ng-bind="user.userOrGroupName" title="{{user.userOrGroupName}}"></span>
						<span class="pageDetailColumn inheritedSecurityAssociation ellipsis-parent ellipsis-content" data-ng-bind="user.roleName" title="{{user.roleName}}"></span>
					</li>
				</ul>
			</div>
			<span data-ng-if="!hideInheritedAssociations && associationsLoaded && !loadedInheritedAssociation" class="tile-link-wrapper">
				<a data-ng-if="!loadingInheritedAssociation" class="tile-content-link" data-ng-click="getInheritedAssociation()"><cv:msg key="label.showInheritedAssociation" bundle="clients" /></a>
				<span data-ng-if="loadingInheritedAssociation" class="tile-content-link"><cv:msg key="Loading" bundle="messages" /></span>
			</span>
		</div>
	<div class="page-details-box-links" data-ng-if="showEdit">
		<a href="" data-ng-click="modifySecurityAssociations()">
			<cv:msg key="action.edit" bundle="collections" />
		</a>
	</div>
</cv-tile-component>