<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ReportsPlusMessages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>

<div data-ng-if="!ctrl.pageReady">
	<div class="details-header">
		<h1 class="page-title">
			<cv:msg key="label.archiveCriteria" bundle="ediscovery"/>
		</h1>
	</div>
	<div class="file-server-lookup-spinner-wrapper">
		<div class="spinner-lg"></div>
	</div>
</div>

<div id="customDatasourceReport" data-ng-if="ctrl.pageReady">
	<div class="details-header">
		<h1 class="page-title">
			<cv:msg key="label.archiveCriteria" bundle="ediscovery"/>
		</h1>
		<custom-data-cube-query-search data-ng-if="ctrl.reportsObj" class="float-right margin-0 margin-right-10 padding-top-2" 
			datasource-id="ctrl.datasourceId" fq-string="{{ctrl.advFq}}" refresh="ctrl.refreshDashboard()"></custom-data-cube-query-search>
		
		<ul class="nav nav-tabs reports-nav" role="tablist">
			<li class="nav-item" data-ng-class="{'active': ctrl.selectedTab !== 'review'}" data-ng-if="ctrl.reportsObj && ctrl.reports.length > 0">
				<a data-toggle="dropdown" class="nav-link" data-toggle="tab" role="tab">
					{{ ctrl.reportsObj.displayName }}<span class="caret" data-ng-if="ctrl.reports.length > 1"></span>
				</a>
				<ul class="dropdown-menu report-selection-dropdown" role="menu">
					<li data-ng-repeat="report in ctrl.reports">
						<a href="" data-ng-click="ctrl.setReportsObject(report)">{{ report.displayName }}</a>
					</li>
				</ul>
			</li>
			<li class="nav-item" data-ng-class="{'active': ctrl.selectedTab === 'review'}">
				<a class="nav-link" data-toggle="tab" role="tab" data-ng-click="ctrl.selectTab('review')">{{ 'label.review' | cvLoc }}</a>
			</li>
			<li class="nav-item pull-right button-container">
				<button type="button" class="btn btn-primary cvBusyOnAjax margin-0 padding-top-7 padding-bottom-7" data-ng-click="ctrl.updateCriteria()"><cv:msg key="label.updateCriteria" bundle="ediscovery"/></button>
			</li>
		</ul>
	</div>
	
	<div data-ng-if="ctrl.reportsObj" id="reportArea">
		<div data-ng-if="ctrl.selectedTab == report.reportName" data-ng-repeat="report in ctrl.reports">
			<div id="ng-app" data-ng-app="reports" data-ng-controller="reportsCtrl" data-ng-init="init(ctrl.reportsObj.reportId, ctrl.reportsObj.reportName, null, null, ctrl.reportsObj.queryString, ctrl.filterAcrossReports)">
				<div id="pageDiv" data-ng-controller="pageController" class="maskLayer" data-ng-class="{'isMasked':masked}">
					<report-filters data-ng-if="ctrl.filterAcrossReports" class="position-relative" custom-classes="['padding-left-10', 'margin-top-15', 'margin-bottom-10-minus']"></report-filters>
					<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/viewerPage.jsp'"></div>
				</div>
			</div>
		</div>
	</div>

	<div data-ng-if="ctrl.selectedTab == 'review'">
		<div data-ng-controller="dataSourceReviewController">
			<div data-ng-if="showGridControl && getColumnDefinitions" class="review-tab-content">
				<filepreviewandaction></filepreviewandaction>
			</div>
		</div>
	</div>
</div>
