<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.ediscovery">
<div class="row bootstrap-wrapper">
	<div class="col-lg-offset-3 col-lg-6 col-xs-12 col-xs-12 ediscovery-addasset-content form-horizontal margin-top-15">
		<h3>{{model.entityName}}</h3>
		<span class="serverMessage {{errorMessage.type}}">{{errorMessage.message}}</span>
		<form name="form.addFileServerForm" novalidate cv-hide-api data-cv-submit="save()" autocomplete="off" id="addFileServerForm" class="edit-users-grid-form">
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
			<div class="form-group" data-ng-if="(createDataSource && selectedFileServers.length <=1) && clientType !== 'client'">
				<label class="col-xs-12 col-md-4 col-lg-4" for="displayName">
					<cv:msg key="label.displayName"  bundle="ediscovery" />
				</label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<div data-ng-if="isClientGroup">
						<label>{{model.displayName}}</label>				
					</div>
					<div data-ng-if="!isClientGroup">
						<input type="text" id="displayName" name="displayName" data-ng-model="model.displayName" ng-model-options="{ updateOn: 'blur' }" />
					</div>
				</div>
			</div>
			<div class="form-group" data-ng-if="(createDataSource && selectedFileServers.length <=1) && clientType === 'client'">
				<label class="col-xs-12 col-md-4 col-lg-4">
					<cv:msg key="label.clientName"  bundle="ediscovery" />
				</label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<input type="text" id="displayName" name="displayName" data-ng-model="model.displayName" />
				</div>
			</div>
			<!--  -->
			<div class="form-group" data-ng-if="createInventory">
				<label class="col-xs-12 col-md-4 col-lg-4" for="name">
					<cv:msg key="label.serverName"  bundle="ediscovery" />
				</label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<input type="text" id="name" name="name" data-ng-model="model.name" data-ng-class="{'has-error': cv['form.addFileServerForm'].needsAttention(form.addFileServerForm.name)}" required autofocus />
					<span class="help-block" data-ng-show="cv['form.addFileServerForm'].needsAttention(form.addFileServerForm.name)"><fmt:message key="error.name" /></span>
				</div>
			</div>	
			<div class="form-group" data-ng-if="createInventory">
				<label class="col-xs-12 col-md-4 col-lg-4" for="domainName">
					<cv:msg key="label.domainName"  bundle="ediscovery" />
				</label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<input type="text" id="domainName" name="domainName" data-ng-model="model.domainName" ng-model-options="{ updateOn: 'blur' }" data-ng-class="{'has-error': cv['form.addFileServerForm'].needsAttention(form.addFileServerForm.domainName)}" />
				</div>
			</div>
			<div class="form-group" data-ng-if="createInventory">
				<label class="col-xs-12 col-md-4 col-lg-4" for="ipAddress">
					<cv:msg key="label.ipAddress"  bundle="ediscovery" />
				</label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<input type="text" id="ipAddress" name="ipAddress" data-ng-model="model.ipAddress" data-ng-class="{'has-error': cv['form.addFileServerForm'].needsAttention(form.addFileServerForm.ipAddress)}" required />
					<span class="help-block" data-ng-show="cv['form.addFileServerForm'].needsAttention(form.addFileServerForm.ipAddress)"><fmt:message key="error.ipAddress" /></span>
				</div>
			</div>		
			<div class="form-group" data-ng-if="createInventory">
				<label class="col-xs-12 col-md-4 col-lg-4" for="osTypeWINDOWS">
					<cv:msg key="label.osType"  bundle="serversJs" />
				</label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<select id="osTypeWINDOWS" name="osTypeWINDOWS" data-ng-model="model.selectedOSType"
						data-ng-options="os.name for os in osTypes"
						>
						<!-- <option value=""><cv:msg key="placeholder.addFileServer.selectCountry" bundle="ediscovery" /></option>  -->
					</select> 
				</div>
			</div>	
			<div class="form-group"  data-ng-show="(createInventory || createDataSource)">
				<label class="col-xs-12 col-md-4 col-lg-4" for="country">
					<cv:msg key="label.countryName"  bundle="ediscovery" />
				</label>
				<div class="col-xs-12 col-md-8 col-lg-8">
						<isteven-multi-select
						directive-id="country"
						input-model="inventoryCountries"
						output-model="selectedCountriesStub"
						button-label="countryName"
						item-label="countryName"
						selection-mode="single"
						tick-property="selected"
						translation="localLang"
						helper-elements="filter"
						search-property="countryName"
						min-search-length="1"
						on-item-click="assignCountry(data)"
						is-required="(createInventory || (createDataSource && selectedFileServers.length == 1))">
						</isteven-multi-select>
						<input type="text" id="country" ng-model="selectedCountriesStub" name="country" style="display:none" data-ng-required="(createInventory || (createDataSource && selectedFileServers.length == 1))" />

					<span class="help-block" data-ng-show="cv['form.addFileServerForm'].needsAttention(form.addFileServerForm.country)"><fmt:message key="error.selectCountry" /></span>
				</div>
			</div>
			<%-- In case of NAS systems, we don't need credentials for NDMP. If client id not NDMP and crawl type is source then ask for credentials--%>
			<div data-ng-if="(createDataSource && selectedServerClientId===undefined) || (isNetAppFiler && model.browseType === '3' && !model.isNDMP)">
				<div class="form-group">
					<label class="col-xs-12 col-md-4 col-lg-4" for="userName">
						<cv:msg key="label.userName"  bundle="ediscovery" />
					</label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<input type="text" class="cv-first-cursor-position" type="text" id="userName" name="userName" data-ng-model="model.username"  data-ng-class="{'has-error': cv['form.addFileServerForm'].needsAttention(form.addFileServerForm.userName)}" ng-required="isCredentialRequired" />
						<span class="help-block" data-ng-show="cv['form.addFileServerForm'].needsAttention(form.addFileServerForm.userName)"><fmt:message key="error.userName" /></span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-md-4 col-lg-4" for="password">
						<cv:msg key="label.password"  bundle="ediscovery" />
					</label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<input type="password" name="password" id="password" data-ng-model="model.password" data-ng-class="{'has-error': cv['form.addFileServerForm'].needsAttention(form.addFileServerForm.password)}" ng-required="isCredentialRequired" />
						<span class="help-block" data-ng-show="cv['form.addFileServerForm'].needsAttention(form.addFileServerForm.password)"><fmt:message key="error.password" /></span>
					</div>
				</div>
			</div>
			<div data-ng-if="createDataSource && selectedServerClientId!==undefined && backupGridData && !isClientGroup">
				<div class="form-group">
					<label class="col-xs-12 col-sm-4"><cv:msg key="label.type"  bundle="ediscovery" /></label>
					<div data-ng-if="!isClientGroup">
						<div class="col-xs-12 col-sm-8">
							<label><input id="localCrawl" name="localCrawl" value="3" class="" type="radio" data-ng-model="model.browseType" data-ng-change="updateError()"/><cv:msg key="label.localCrawl"  bundle="ediscovery" /></label>
						</div>
						<label class="col-xs-12 col-sm-4"></label>
						<div class="col-xs-12 col-sm-8">
							<label><input id="importFromBackup" name="importFromBackup" value="0" class="" type="radio" data-ng-model="model.browseType" data-ng-change="updateError()"/><cv:msg key="label.importFromBackup"  bundle="ediscovery" /></label>
						</div>
						<label class="col-xs-12 col-sm-4"></label>
					</div>
					<div data-ng-if="isFSO && model.browseType == 0" class="col-xs-12 col-sm-8 select-icon-longDesc" data-ng-init="model.browseSubtype = 'quick'">
						<label class="row select-oneType" data-ng-class="{checked:(model.browseSubtype === 'quick')}">
							<input class="no-float-auto col-md-1" type="radio" data-ng-model="model.browseSubtype" value="quick">
							<span class="col-md-2 font-weight-bold">{{ 'label.datasource.crawlType.quick' | cvLoc }}</span>
							<span class="col-md-9 select-desc">{{ 'info.datasource.crawlType.quick' | cvLoc }}</span>
						</label>
						<label class="row select-oneType"  data-ng-class="{checked:(model.browseSubtype === 'full')}">
							<input class="no-float-auto col-md-1"  type="radio" data-ng-model="model.browseSubtype" value="full">
							<span class="col-md-2 font-weight-bold">{{ 'label.datasource.crawlType.full' | cvLoc }}</span>
							<span class="col-md-9 select-desc">{{ 'info.datasource.crawlType.full' | cvLoc }}</span>
						</label>
					</div>
				</div>
				<div data-ng-if="model.browseType == 0 && !isClientGroup" class="padding-bottom-50">
					<div data-ng-if="initializingBackupGrid" class="spinner-sm"></div>
					<cv-kendo-grid data-ng-if="!initializingBackupGrid" data-cv-grid-options="backupGridOptions"></cv-kendo-grid>
				</div>
			</div>
			<div class="form-group" data-ng-hide="(model.browseType!==undefined && model.browseType==0 && backupGridData) || isClientGroup">
				<label class="col-xs-12 col-md-4 col-lg-4" for="directoryPath">
					<cv:msg key="label.directoryPath"  bundle="ediscovery" />
				</label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<div>
						<textarea id="directoryPath" data-ng-disabled="model.ContentIndexingStatus === 1" name="directoryPath" data-ng-attr-placeholder="{{getPlaceholderText()}}" data-ng-model="model.includedirectoriespath" ng-pattern="filePathValidation" ng-model-options="{ updateOn: 'blur' }"></textarea>
						<span class="help-block" data-ng-show="showDirectoryPathError">{{directoryPathError}}</span>
					</div>
					<span class="pull-right">
						<button id="addFileServer_button_#5268" type="button" data-ng-click="ediscoveryBrowse()" class="btn btn-default"> 
							<cv:msg key="Browse" bundle="storage"/>
						</button>
					</span>
				</div>
			</div>
			<div data-ng-if="(isNetAppFiler || (selectedServerClientId && isWindowsClient && model.browseType==='3' )) && enableNetappMonitoring">
				<div class="form-group">
					<div class="col-xs-12">
						<cv-toggle on-click="onMonitoringToggleChange()" toggle-name="enableMonitoring" toggle-label="label.enableMonitoring" help-text="label.enableMonitoringHelpText" value="model.enableMonitoring" toggle-model="model.enableMonitoring"></cv-toggle>
						<div data-ng-if="showMonitoringError" class="error">{{monitoringError}}</div>
					</div>
				</div>
			</div>
			<div data-ng-if="showAccessNodes || projectScheduleExists" class="padding-top-10">
				<cv-plain-accordion accordion-label="label.advancedSetting" collapsed="collapseAdvancedOptions">
					<div class="padding-top-10"></div>
					<div data-ng-if="showAccessNodes && indexServerClientId" class="form-group">
						<access-node-selector on-select="onAccessNodeSelection(selectedItems)" index-server-client-id="indexServerClientId" selected-nodes="model.selectedAccessNodes" 
						hint-Msg='isNetAppFiler && model.browseType === "3" ? "<cv:msg key="hint.accessNodeOrCredentials" bundle="ediscovery"/>" : ""'></access-node-selector>						
					</div>

					<div class="form-group">
						<div class="col-xs-12">
							<schedule-data-crawl schedule-exists="projectScheduleExists" follow-schedule-crawl="model.followScheduleCrawl"></schedule-data-crawl>
						</div>
					</div>
				</cv-plain-accordion>
			</div>
		</form>
	</div>
</div>
</fmt:bundle>
