<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.ediscovery">
<div class="row bootstrap-wrapper">
	<div class="col-lg-offset-3 col-lg-6 col-xs-12 col-xs-12 ediscovery-addasset-content form-horizontal margin-top-15">
	<h3>{{model.entityName}}</h3>
	<span class="serverMessage {{errorMessage.type}}">{{errorMessage.message}}</span>
		<form name="form.addFileServerForm" novalidate cv-hide-api data-cv-submit="save()" autocomplete="off" id="addFileServerForm" class="edit-users-grid-form">
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
			<div class="form-group" data-ng-show="(selectedFileServers.length <=1)">
				<label class="col-xs-12 col-md-4 col-lg-4" for="displayName">
					<cv:msg key="label.displayName"  bundle="ediscovery" />
				</label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<input type="text" id="displayName" name="displayName" data-ng-model="model.displayName" ng-model-options="{ updateOn: 'blur' }" />
				</div>
			</div>	
			<div class="form-group">
				<label class="col-xs-12 col-md-4 col-lg-4" for="country">
					<cv:msg key="label.countryName"  bundle="ediscovery" />
				</label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<isteven-multi-select
						directive-id="country"
						input-model="inventoryCountries"
						output-model="selectedCountriesStub"
						button-label="countryName"
						item-label="countryName"
						selection-mode="single"
						tick-property="selected"
						translation="localLang"
						helper-elements="filter"
						search-property="countryName"
						min-search-length="1"
						on-item-click="assignCountry(data)"
						is-required="selectedFileServers.length === 1">
						</isteven-multi-select>
						<input type="text" id="country" ng-model="selectedCountriesStub" name="country" style="display:none" data-ng-required="selectedFileServers.length === 1" />
					<span class="help-block" data-ng-show="cv['form.addFileServerForm'].needsAttention(form.addFileServerForm.country)"><fmt:message key="error.selectCountry" /></span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-sm-4"><cv:msg key="label.collection" bundle="ediscovery" /></label>
				<div class="col-xs-12 col-sm-8">
					<label><input id="allMailboxes" name="allMailboxes" value="all" class="" type="radio" data-ng-model="model.mailboxSelection"/><cv:msg key="label.datasource.exchange.allMailboxes"  bundle="ediscovery" /></label>
				</div>
				<label class="col-xs-12 col-sm-4"></label>
				<div class="col-xs-12 col-sm-8">
					<label><input id="selectMailboxes" name="selectMailboxes" value="select" class="" type="radio" data-ng-model="model.mailboxSelection" /><cv:msg key="label.datasource.exchange.selectMailboxes" bundle="ediscovery" /></label>
					<div data-ng-if="showBrowse && model.mailboxSelection === 'select'" class="padding-top-10">
						<cv-grid cv-grid-options="emailGrid"></cv-grid>
						<span class="help-block" data-ng-show="showMailboxError && model.emailContents.length === 0"><fmt:message key="error.selectMailbox" /></span>
						<span class="pull-right">
							<button type="button" data-ng-click="ediscoveryBrowse()" class="btn btn-default"  ng-disabled="disableBrowse">
								<cv:msg key="Browse" bundle="storage"/>
							</button>
						</span>
					</div>
				</div>
			</div>
			<div data-ng-if="projectScheduleExists" class="padding-top-10">
				<cv-plain-accordion accordion-label="label.advancedSetting">
					<div class="padding-top-10"></div>
					<div class="form-group">
						<div class="col-xs-12">
							<schedule-data-crawl schedule-exists="projectScheduleExists" follow-schedule-crawl="model.followScheduleCrawl"></schedule-data-crawl>
						</div>
					</div>
				</cv-plain-accordion>
			</div>
		</form>
	</div>
</div>
</fmt:bundle>
