<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<span class="{{ctrl.planMessage.type}} serverMessage" data-ng-bind="ctrl.planMessage.message"></span>
<span class="{{ctrl.inventoryMessage.type}} serverMessage" data-ng-bind="ctrl.inventoryMessage.message"></span>
<div class="global-options remove-border-padding" data-ng-if="!ctrl.hideName">
    <label class="row" for="name">
        <span class="col-xs-4"><cv:msg key="label.name" bundle="ediscovery" /></span>
        <div class="col-xs-8 padding-left-0">
            <input class="full-width" type="text" id="name" name="name" data-ng-model="ctrl.clientName" required autofocus data-ng-pattern="/^[A-Za-z0-9_\- ]*$/" ng-maxlength="50" data-ng-class="{'has-error': cv.addEditClientGroupForm.needsAttention(addEditClientGroupForm.name)}"/>
        </div>
        <span class="help-block" data-ng-show="addEditClientGroupForm.name.$error.pattern">
            <cv:msg key="error.invalidName" bundle="ediscovery" />
        </span>
        <span class="help-block" data-ng-show="addEditClientGroupForm.name.$error.maxlength">
            <cv:msg key="error.maxlength" bundle="ediscovery" />
        </span>
    </label>
</div>
<div class="global-options remove-border-padding">
    <label class="row">
        <span class="col-xs-4"><cv:msg key="label.profiles" bundle="profiles" /></span>
        <div class="col-xs-7 padding-0">
            <isteven-multi-select
                directive-id="ediscoveryPlan"
                html-template="true"                       
                input-model="ctrl.ediscoveryPlans"
                output-model="ctrl.planOutputModel"
                item-label="planName"
                button-label="planName"
                tick-property="selected"
                max-labels="1"
                selection-mode="single"                        
                helper-elements="filter"
                on-close="ctrl.onPlanSelection()">
            </isteven-multi-select>
        </div>
        <div class="col-xs-1">
            <a title='<cv:msg key="label.addPlan" bundle="ediscovery" />'>
                <span class="k-icon k-i-plus-outline cursor-pointer" data-ng-click="ctrl.onAddPlanClick()"></span>
            </a>
        </div>
    </label>
</div>
<div class="global-options remove-border-padding">
    <label class="row">
        <span class="col-xs-4"><cv:msg key="label.inventorymanager.name" bundle="ediscovery" /></span>
        <div class="col-xs-7 padding-0">
             <isteven-multi-select
                directive-id="ediscoveryInventory"
                input-model="ctrl.inventoryObjects"
                output-model="ctrl.inventoryOutputModel"
                item-label="inventoryName"
                button-label="inventoryName"
                tick-property="selected"
                max-labels="1"
                selection-mode="single"                        
                helper-elements="filter"
                on-close="ctrl.onInventorySelection()">
            </isteven-multi-select> 
        </div>
        <div class="col-xs-1">
            <a title='<cv:msg key="label.inventorymanager.add" bundle="ediscovery" />'>
                <span class="k-icon k-i-plus-outline cursor-pointer" data-ng-click="ctrl.onAddInventoryClick('addProject')"></span>
            </a>
        </div>
    </label>
</div>
