
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script>
    <cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div class="search-toolbar">
            <div class="inline-block">
                <isteven-multi-select
                    html-template="true"
                    input-model="model.searchParams.applicationTypes"
                    output-model="model.targetApp"
                    button-label="name"
                    item-label="name"
                    tick-property="ticked"
                    group-property="msGroup"
                    class="isteven-multi-select search-type-select"
                    id="applicationType"
                    name="applicationType"
                    max-labels="3"
                    translation="model.entitiesText"
                    selection-mode="single"
                    on-close="model.onApplicationTypeChanged()"
                    helper-elements="{{model.helperElements}}"
                    >
                </isteven-multi-select>
            </div>
            <div class="inline-block search-text-input">
                <input type="search" id="searchInput" class="search-text" ng-model="model.searchText"  ng-attr-placeholder="{{model.searchPlaceHolder}}" />
            </div>
            <div class="inline-block">
                <span class="k-icon k-i-close k-i-x search-close" data-ng-click="model.searchText='';" data-ng-show="model.searchText !== undefined && model.searchText.trim().length > 0" title='<cv:msg key="label.clear" bundle="messages" />'></span>
            </div>
        <div class="inline-block vertical-bottom">
            <button id="searchPreview_button_#5268" class="btn btn-primary search-btn" ng-click="model.onSearch(model.searchText)">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                    width="20px" height="20px" viewBox="0 0 446.25 446.25" style="enable-background:new 0 0 446.25 446.25;fill:#ffffff"
                    xml:space="preserve">
                <g>
                    <g id="search">
                        <path d="M318.75,280.5h-20.4l-7.649-7.65c25.5-28.05,40.8-66.3,40.8-107.1C331.5,73.95,257.55,0,165.75,0S0,73.95,0,165.75
                            S73.95,331.5,165.75,331.5c40.8,0,79.05-15.3,107.1-40.8l7.65,7.649v20.4L408,446.25L446.25,408L318.75,280.5z M165.75,280.5
                            C102,280.5,51,229.5,51,165.75S102,51,165.75,51S280.5,102,280.5,165.75S229.5,280.5,165.75,280.5z"/>
                    </g>
                </g>
                </svg>
            </button>
        </div>
        <div class="inline-block">
            <a data-ng-click="model.showAdvancedSearch()" class="margin-left-15" >
                <span>{{'label.advancedsearch' | cvLoc }}</span>
                <span data-ng-show="model.advancedSearchFilterCount > 0" ng-attr-title="{{'label.complianceSearch.numberOfFilters'|cvLoc}}" class="filter-prefix">({{model.advancedSearchFilterCount}})</span>
            </a>
        </div>

         <div class="inline-block">
            <a data-ng-click="model.saveQuery()" class="margin-left-15" >
                <span ng-bind-html="model.saveQueryIcon"></span>
                <span>{{'label.saveQuery' | cvLoc }}</span>
            </a>
        </div>

</div>
<div class="row">
    <div class="col-md-8 gdpr-chips filter-chips">
        <cv-report-filter  facets="model.facets" on-facet-toggled="model.onFacetToggled(open,facet)" on-filter-suggest="model.onSuggestChanged(value,filter)" on-filter-selection-changed="model.onFilterSelectionChanged(allFacets)"  ></cv-report-filter>
    </div>
</div>
<div class="compliance-search-icon horz-center" data-ng-show="model.items.length == 0" >
    <div class="margin-left-50" ng-bind-html="model.searchSvg">
    </div>
    <div data-ng-if="model.Loading">
        <h5>
            {{'label.complianceSearch.searchData' | cvLoc}} <span class="margin-left-5" data-ng-if="model.searchObject.getSearchRequest().listOfCIServer && model.searchObject.getSearchRequest().listOfCIServer.length > 0">({{model.searchObject.getSearchRequest().listOfCIServer[0].engineName}})</span>
        </h5>
    </div>
    <div data-ng-if="!model.Loading">
        <h3 class="margin-left-50">
        {{ model.emptySearchText }}
        </h3>
        <h5 data-ng-if="model.error.type != 'error'">
            {{'label.complianceSearch.resetSearch' | cvLoc }} <a class="margin-left-5" data-ng-click="model.resetFilters()">{{'label.complianceSearch.clearFilters' | cvLoc}}</a>.
        </h5>
        <h5 data-ng-if="(!model.searchParams.inputObj.client && model.error.type != 'error')">
            {{'label.complianceSearch.changeIndexserver' | cvLoc}} <a class="margin-left-5" data-ng-click="model.showAdvancedSearch()">{{'label.advancedsearch' | cvLoc }}</a>
        </h5>
        <div>
            <span class="{{model.error.type}} serverMessage" data-ng-bind="model.error.message"></span>
        </div>
    </div>
</div>
<div class="row search-preview-panel" data-ng-show="model.items.length > 0">
    <cv-kendo-grid data-ng-if="model.emailGridOptions" data-ng-show="model.searchParams.type===137" data-ng-class="model.listGridClass" class="search-list" data-cv-grid-options="model.emailGridOptions"></cv-kendo-grid>
    <cv-kendo-grid data-ng-if="model.fileGridOptions" data-ng-show="model.searchParams.type===33" data-ng-class="model.listGridClass" class="search-list" data-cv-grid-options="model.fileGridOptions"></cv-kendo-grid>
    <cv-kendo-grid data-ng-if="model.fileEmailGridOptions" data-ng-show="model.searchParams.type===0" data-ng-class="model.listGridClass" class="search-list" data-cv-grid-options="model.fileEmailGridOptions"></cv-kendo-grid>
    <div class="margin-top-40-minus cv-flex float-right margin-right-5">
        <div class="margin-top-10" data-ng-if="model.addtoCaseMenu" data-ng-disabled="model.selectedItems.length ==0">
            <span uib-dropdown>
                <a href id="simple-dropdown" uib-dropdown-toggle>
                        <span class="vertical-align-text-bottom"> {{'label.casemanager.addToCase' | cvLoc}}</span>
                        <span class="caret vertical-align-super"></span>
                </a>
                <ul class="dropdown-menu" uib-dropdown-menu>
                    <li ng-repeat="option in model.addtoCaseMenu">
                        <a data-ng-click="model.showAddToCase(option.type)">
                            <span class="margin-left-5 vertical-align-text-bottom">{{option.label}}</span>
                        </a>
                    </li>
                </ul>
            </span>
        </div>
        <div class="margin-top-10  margin-left-25">
            <span uib-dropdown data-ng-disabled="model.selectedItems.length ==0">
                <a href id="simple-dropdown" uib-dropdown-toggle>
                        <span ng-bind-html="model.exportIcon"></span>
                        <span class="vertical-align-text-bottom"> {{'label.exportTo' | cvLoc}} </span>
                        <span class="caret vertical-align-super"></span>
                </a>
                <ul class="dropdown-menu" uib-dropdown-menu>
                    <li ng-repeat="option in model.exportToMenu">
                        <a data-ng-click="model.showExportModal(option.type)">
                            <span ng-bind-html="option.image"></span>
                            <span class="margin-left-5 vertical-align-text-bottom">{{option.label}}</span>
                        </a>
                    </li>
                </ul>
            </span>
        </div>
        <div class="margin-top-10 margin-left-25" data-ng-show="model.isCaseSearch">
            <span>
                <a data-ng-click="model.viewQueriesMenu.onSelect()" >
                    <span ng-bind-html="model.querySetIcon"></span>
					<span class="vertical-align-text-bottom">{{'label.querySet' | cvLoc}}</span>
                </a>
            </span>
        </div>
         <div class="margin-top-10 margin-left-25" data-ng-if="!model.addtoCaseMenu && model.searchParams.type !== 0" data-ng-disabled="model.selectedItems.length ==0">
            <span>
                <a data-ng-click="model.applyTags()" class="cv-flex" >
                    <div class="compliance-search-tag-icon" data-ng-include="model.tagIcon"></div>
					<span class="vertical-align-text-bottom">{{model.applyTagsLabel}}</span>
                </a>
            </span>
        </div>
    </div>
    <div id="previewPane">
        <cv-file-preview data-ng-show="model.selectedItems.length ==1"  data-ng-class="model.previewSectionClass" class="email-preview-content search-preview-content" content="model.previewContent" on-tag-removed="model.onTagRemoved()" cv-search-filter-request="model.previewFilterRequest" search-request="model.searchObject.getSearchRequest()" is-loaded="model.isPreviewLoaded" header="model.previewHeader">
        </cv-file-preview>
            <div id="previewActionPane" style="background:#eeeeee;" data-ng-show="model.selectedItems.length ==0 || model.selectedItems.length > 1 " data-ng-class="model.previewSectionClass" class="horz-center">
        <div class="margin-top-50" ng-bind-html="model.objectSvg"> </div>
        <div data-ng-show="model.selectedItems.length ==0">
            <h4>
                {{'label.complianceSearch.selectItem'|cvLoc}}
            </h4>
        </div>
        <div data-ng-show="model.selectedItems.length > 1">
            <h4 class="margin-bottom-30">
                {{ model.multiSelectMessage }}
            </h4>
            <div id="actionPanel">
                <div data-ng-if="model.addtoCaseMenu" >
                    <span ng-bind-html="model.caseIconLarge"></span>
                    <span class="vertical-align-text-bottom">{{'label.casemanager.addToCase' | cvLoc}}</span>
                </div>
                 <ul>
                    <li ng-repeat="option in model.addtoCaseMenu" class="padding-5 padding-left-20">
                        <a data-ng-click="model.showAddToCase(option.type)">
                            <span class="vertical-align-text-bottom">{{option.label}}</span>
                        </a>
                    </li>
                </ul>
                <div class="margin-left-20-minus margin-top-10">
                    <span ng-bind-html="model.exportIconLarge"></span>
                    <span class="vertical-align-text-bottom"> {{'label.exportTo' | cvLoc}} </span>
                </div>
                <ul>
                    <li ng-repeat="option in model.exportToMenu" class="padding-5">
                        <a data-ng-click="model.showExportModal(option.type)">
                            <span ng-bind-html="option.image"></span>
                            <span class="vertical-align-text-bottom">{{option.label}}</span>
                        </a>
                    </li>
                </ul>
                    <div data-ng-if="!model.addtoCaseMenu" class="margin-top-10">
                        <div  data-ng-if="model.searchParams.type !== 0 && model.groupedTags.length > 0" >
                            <span>
                                <a data-ng-click="model.manageTags()" class="cv-flex horizontal-center" >
                                    <div class="compliance-search-tag-icon-large" data-ng-include="model.tagIcon"></div>
                                    <span class="vertical-align-text-bottom margin-left-5">{{'label.casemanager.manageTags' | cvLoc}}</span>
                                </a>
                            </span>
                        </div> 
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>

</div>


