<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="setup-title">
    <h1>
		<span>{{'label.casemanager.editCustodians' | cvLoc }}</span>
	</h1>
</div>
<script type="text/ng-template" id="customTemplate.html">
  <a class="custodianSuggestText">
      <span ng-bind-html="match.label | uibTypeaheadHighlight:query"></span> 
  </a>
</script>
<div class="setup-content">
    <span class="{{clientCtrl.serverMessage.type}} serverMessage" data-ng-bind="clientCtrl.serverMessage.message"></span>
    <section>
        <form name="addCaseClientForm" cv-hide-api data-cv-submit="clientCtrl.updateCustodians()" autocomplete="off" >
			<div class="col-lg-10 custodianWrapper" >
				<input type="text" 
				ng-model="clientCtrl.selectedCustodian" placeholder="{{'label.casemanager.searchUsersOrGroups' | cvLoc }}"
				uib-typeahead="custodian as custodian.name for custodian in clientCtrl.getCustodianSuggestion($viewValue)"
				typeahead-template-url="customTemplate.html"
				typeahead-loading="loadingLocations"
				typeahead-no-results="noResults"
				typeahead-on-select="clientCtrl.addCustodianFromSuggest($item, $model, $label);clientCtrl.selectedCustodian='';"
				class="form-control filter-text custodianLookupInput" /> 
				<i ng-show="loadingLocations" class="glyphicon glyphicon-refresh"></i>
				<div ng-show="noResults">
					<i class="glyphicon glyphicon-remove"></i> {{'label.noresults' | cvLoc}}
				</div>
			</div>
			<div data-ng-repeat="custodian in clientCtrl.custodiansList">
				<div class="col-lg-8 custodianText" >
					<span class="user-type custodianUser" >{{custodian.custodianName}}</span>
				</div>
				<div class="col-lg-2" ><a href="" data-ng-click="clientCtrl.deleteCustodian(custodian)" title="{{custodian.custodianName}}" >x</a></div>
			</div>
            <div class="button-container">
                <button id="addCustodianModal_button_#9265" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="clientCtrl.cancel()"> 
                    <cv:msg key="Cancel" bundle="messages" />
                </button>
                <button id="addCustodianModal_button_#2594" type="submit" class="btn btn-primary cvBusyOnAjax"> 
                    <cv:msg key="Save" bundle="messages" />
                </button>
            </div>
        </form>
    </section>
</div>
