<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
    <cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
</script>
<div class="col-xs-12 col-md-10 col-md-offset-1 col-lg-10 col-lg-offset-1 bootstrap-wrapper" data-ng-controller="AddCaseClientController as clientCtrl">
    <div>
        <h1>
            <span>{{clientCtrl.title}}</span><span> {{clientCtrl.caseTypeText}} <cv-help-component data-ng-show="clientCtrl.caseType === '2'" help-text="<cv:msg key="label.casemanager.reviewsetNote" bundle="ediscovery" />"></cv-help-component> </span>
        </h1>
    </div>
    <span class="{{clientCtrl.serverMessage.type}} serverMessage" data-ng-bind="clientCtrl.serverMessage.message"></span>
    <form class="bootstrap-wrapper form-horizontal" name="addCaseClientForm" cv-hide-api data-cv-submit="clientCtrl.createCaseAndDefinition()" autocomplete="off" novalidate>
        <div class="panel panel-default">
            <div class="panel-body">
                <div class="form-group">
                    <label class="col-xs-12 col-md-3 col-lg-3" for="clientName" >
                        <cv:msg key="label.name" bundle="collections" />
                    </label>
                    <div class="col-xs-12 col-md-9 col-lg-9">
                        <input type="text" id="clientName" name="clientName" data-ng-model="clientCtrl.caseClientName" required autofocus data-ng-pattern="/^[a-zA-Z0-9_-]*$/" ng-maxlength="50" />
                        <div data-ng-show="cv.addCaseClientForm.needsAttention(addCaseClientForm.clientName)">
                            <span class="help-block" data-ng-show="addCaseClientForm.clientName.$error.required">
                                <cv:msg key="error.emptyName" bundle="ediscovery" />
                            </span>
                            <span class="help-block" data-ng-show="addCaseClientForm.clientName.$error.pattern">
                                <cv:msg key="error.casemanager.noAppName" bundle="ediscovery" />
                            </span>
                            <span class="help-block" data-ng-show="addCaseClientForm.clientName.$error.maxlength">
                                <cv:msg key="error.maxlength" bundle="ediscovery" />
                            </span>
                        </div>
                    </div>
                </div>
			<div class="form-group">
					<label class="col-xs-12 col-md-3 col-lg-3" for="description"><cv:msg
							key="label.description" bundle="ediscovery" /></label>
					<div class="col-xs-12 col-md-9 col-lg-9">
						<input name="description" id="description" type="text" data-ng-model="clientCtrl.description"/>
					</div>
				</div>
				<div class="form-group">
                    <label for="ediscoveryPlan" class="col-xs-12 col-md-3 col-lg-3">
                        <cv:msg key="label.casemanager.dcPlan" bundle="ediscovery" /><cv-help-component help-text="<cv:msg key="info.casemanager.dcPlan" bundle="ediscovery" />"></cv-help-component>
                    </label>
                    <div class="col-xs-12 col-md-9 col-lg-9">
                        <isteven-multi-select
						html-template="true"
						input-model="clientCtrl.ediscoveryPlans"
						output-model="clientCtrl.selectedEdiscoveryPlan"
						button-label="planName"
						item-label="plan.isValid ? planName : template"
						tick-property="ticked"
						selection-mode="single"
						group-property="msGroup"
						disable-property="disabled"
						class="isteven-multi-select user-group-select edit-users-grid-form"
						id="ediscoveryPlan"
						name="ediscoveryPlan"
						max-labels="3"
						translation="clientCtrl.entitiesText"
						helper-elements="{{clientCtrl.helperElements}}"
						>
					</isteven-multi-select>
                    <input type="text" ng-model="clientCtrl.selectedEdiscoveryPlan" name="inputEdiscoveryPlan" class="display-none" required />
                        <div data-ng-show="cv.addCaseClientForm.needsAttention(addCaseClientForm.inputEdiscoveryPlan)">
                            <span class="help-block" data-ng-show="addCaseClientForm.inputEdiscoveryPlan.$error.required">
                                <cv:msg key="error.emptyDCPlan" bundle="ediscovery" />
                            </span>
                        </div>
                    </div>
                </div>
				<div class="form-group">
					<label for="plans" class="col-xs-12 col-md-3 col-lg-3"> <cv:msg
							key="label.casemanager.serverPlan" bundle="ediscovery" /><cv-help-component help-text="<cv:msg key="info.casemanager.serverPlan" bundle="ediscovery" />"></cv-help-component>
					</label>
					<div class="col-xs-12 col-md-9 col-lg-9">
						<isteven-multi-select html-template="true"
							input-model="clientCtrl.serverPlans"
							output-model="clientCtrl.selectedServerPlan"
							selection-mode="single" button-label="label" item-label="label"
							tick-property="ticked"
							class="isteven-multi-select user-group-select edit-users-grid-form"
							id="serverPlan" name="serverPlan" max-labels="3"
							translation="clientCtrl.entitiesText"
							helper-elements="{{clientCtrl.helperElements}}">
						</isteven-multi-select>
						<input type="text" ng-model="clientCtrl.selectedServerPlan"
							name="inputServerPlan" class="display-none" required />
						<div
							data-ng-show="cv.addCaseClientForm.needsAttention(addCaseClientForm.inputServerPlan)">
							<span class="help-block"
								data-ng-show="addCaseClientForm.inputServerPlan.$error.required">
								<cv:msg key="error.emptyServerPlan" bundle="ediscovery" />
							</span>
						</div>
					</div>
				</div>
				<div class="form-group">
                    <label for="holdType" class="col-xs-12 col-md-3 col-lg-3">
                        <cv:msg key="label.casemanager.solution" bundle="ediscovery" />
                    </label>
                    <div class="col-xs-12 col-md-9 col-lg-9">
                        <isteven-multi-select
										required
										input-model="clientCtrl.holdTypes"
										output-model="clientCtrl.selectedHoldTypes"
										on-close="clientCtrl.getRequiredDetails(clientCtrl.selectedHoldTypes)"
										selection-mode="multiple"
										button-label="name"
										item-label="name"
										tick-property="ticked"
										group-property="msGroup"
										class="isteven-multi-select user-group-select"
										id="holdType"
										name="holdType"
										max-labels="3"
										translation="clientCtrl.entitiesText"
										helper-elements="{{clientCtrl.helperElements}}"
										>
						</isteven-multi-select>
                        <input type="text" ng-model="clientCtrl.selectedHoldTypes" name="inputHoldType" class="display-none" required />
                        <div data-ng-show="cv.addCaseClientForm.needsAttention(addCaseClientForm.inputHoldType)">
                            <span class="help-block" data-ng-show="addCaseClientForm.inputHoldType.$error.required">
                                <cv:msg key="error.emptySolution" bundle="ediscovery" />
                            </span>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="dataCollection" class="col-xs-12 col-lg-3 col-md-3">
                        <cv:msg key="label.ingestion" bundle="ediscovery" />
                    </label>
                    <div class="col-xs-12 col-lg-9 col-md-9">
                        <isteven-multi-select
                            required
                            input-model="clientCtrl.ingestionMode"
                            output-model="clientCtrl.selectedIngestionMode"
                            button-label="text"
                            item-label="text"
                            tick-property="ticked"
                            group-property="msGroup"
                            selection-mode="single"
                            class="isteven-multi-select user-group-select"
                            id="dataCollection"
                            name="dataCollection"
                            max-labels="3"
                            translation="clientCtrl.entitiesText"
                            helper-elements="{{clientCtrl.helperElements}}"
                            >
                        </isteven-multi-select>
                    </div>
                </div>
            </div>
        </div>
        <div>
            <cv-case-definition hide-general="true" input-param="clientCtrl.definitionInput" on-load="clientCtrl.onDefinitionLoaded(definitionInstance)" ></cv-case-definition>
        </div>
        <div class="button-container">
            <button id="addCaseClientModal_button_#5124" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="clientCtrl.cancel()"><cv:msg key="action.cancel" bundle="exchange"/></button>
            <button id="addCaseClientModal_button_#5123" type="submit" class="btn btn-primary cvBusyOnAjax">
                <span>
                    {{'Save' | cvLoc }}
                </span>
            </button>
        </div>
    </form>
</div>
