<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.ediscovery" />
	<cv:cvMessages bundle="localization.messages" />
	<cv:cvMessages bundle="localization.reports" />
</script>
<h1 class="page-title">
	<span>
		{{ analyticsDashboardsController.localizedReportName }}
	</span>
</h1>
<a class="page-action-item margin-0 margin-right-10" data-ng-click="analyticsDashboardsController.refreshDashboard()">{{'label.refresh' | cvLoc}}</a>
<client-quick-start hide-title="true" goto-dashboard="analyticsDashboardsController.gotoDashboard(reportName)" disabled-tiles="analyticsDashboardsController.disabledTiles" active-tile="analyticsDashboardsController.activeTile"></client-quick-start>
<%-- Dashboards --%>
<div data-ng-if="analyticsDashboardsController.reportType && analyticsDashboardsController.reportType !== 'review'">
	<span data-ng-if="!analyticsDashboardsController.clientList">{{ 'Loading' | cvLoc }}<img src="./img/loading.gif"></img></span>
	<div data-ng-if="analyticsDashboardsController.clientList">
		<client-selector
			clients="analyticsDashboardsController.clientList"
			client-selected="analyticsDashboardsController.onDashboardClientSelect(client)"
			select-within-group="true"
			refresh-client-list="analyticsDashboardsController.getClientsAndClientGroups(selectedClients)">
		</client-selector>
	</div>
	<div id="reportArea" data-ng-if="analyticsDashboardsController.selectedClients !== undefined && analyticsDashboardsController.selectedClients.length > 0">
		<div id="ng-app" data-ng-app="reports" data-ng-controller="reportsCtrl"
			data-ng-init="init(null, analyticsDashboardsController.reportName, undefined, undefined, analyticsDashboardsController.reportInput, analyticsDashboardsController.filterAcrossReports)">
			<div id="pageDiv" data-ng-controller="pageController" class="maskLayer" data-ng-class="{'isMasked':masked}">
				<report-filters data-ng-if="analyticsDashboardsController.filterAcrossReports" class="position-relative" custom-classes="['padding-left-10', 'margin-top-15', 'margin-bottom-10-minus']"></report-filters>
				<div data-ng-include="appUtil.appRoot + 'reportsplus/templates/reportComponents/viewerPage.jsp'"></div>
			</div>
		</div>
	</div>
	<div data-ng-if="analyticsDashboardsController.selectedClients === undefined || analyticsDashboardsController.selectedClients.length < 1" class="horz-center">
		<div data-ng-include="appUtil.appRoot + 'ediscovery/analytics/img/clients.svg'"></div>
		<h3>{{ 'error.noClientOrClientGroupSelected' | cvLoc}}</h3>
	</div>
</div>
<%-- Review --%>
<div data-ng-if="analyticsDashboardsController.reportType === 'review'">
	<span data-ng-if="!analyticsDashboardsController.clientList">{{ 'Loading' | cvLoc }}<img src="./img/loading.gif"></img></span>
	<div data-ng-if="analyticsDashboardsController.clientList">
		<client-selector
			clients="analyticsDashboardsController.clientList"
			client-selected="analyticsDashboardsController.onReviewClientSelect(client)"
			select-within-group="true">
		</client-selector>
	</div>
	<div class="review-dashboard" data-ng-controller="AnalyticsDataSourceReview as ctrl" data-ng-show="analyticsDashboardsController.selectedClients !== undefined && analyticsDashboardsController.selectedClients.length > 0">
		<%-- Hidden report for showing current filters on top --%>
		<div id="reportArea">
			<div
				data-ng-if="analyticsDashboardsController.showFacets"
				data-ng-hide="true"
				id="ng-app"
				data-ng-app="reports"
				data-ng-controller="reportsCtrl"
				data-ng-init="init(undefined, analyticsDashboardsController.facetReportName, undefined, undefined, analyticsDashboardsController.reportInput, analyticsDashboardsController.filterAcrossReports)">
				<div data-ng-hide="true" id="pageDiv" data-ng-controller="pageController" class="maskLayer" data-ng-class="{'isMasked':masked}">
					<div
						id="pageDiv"
						data-ng-hide="true"
						data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/viewerPage.jsp'">
					</div>
				</div>
			</div>
			<report-filters custom-classes="['margin-bottom-10']"></report-filters>
		</div>
		<div data-ng-if="showGridControl" class="review-tab-content">
			<filepreviewandaction></filepreviewandaction>
		</div>
	</div>
	<div data-ng-show="analyticsDashboardsController.selectedClients === undefined || analyticsDashboardsController.selectedClients.length < 1" class="horz-center">
		<div data-ng-include="appUtil.appRoot + 'ediscovery/analytics/img/clients.svg'"></div>
		<h3>{{ 'error.noClientOrClientGroupSelected' | cvLoc}}</h3>
	</div>
</div>
