<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<h1 class="page-title">
    <span data-ng-if="!clientDetailsCtrl.gettingClientDetails">{{ clientDetailsCtrl.client.displayName }}</span>
    <span data-ng-if="clientDetailsCtrl.gettingClientDetails">{{ 'Loading' | cvLoc }}<img src="./img/loading.gif"></img></span>
</h1>
<div id="detailsArea">
    <div id="projectDetails">
        <div class="row">
            <div class="col-md-6">
                <cv-tile-component data-ac-id="casemanagerDetails-label_configuration-ediscovery" title='<cv:msg key="label.configuration" bundle="ediscovery"/>' loader="clientDetailsCtrl.client">
                    <ul class="list-style-secondary">
                        <li class="group">
                            <span class="pageDetailColumn">
                                <cv:msg key="label.assets.database.hostName" bundle="ediscovery" />
                            </span>
                            <span class="pageDetailColumn">
                                {{ clientDetailsCtrl.client.netHostName }}
                            </span>
                        </li>
                        <li class="group" data-ng-if="!clientDetailsCtrl.vmOnly">
                            <span class="pageDetailColumn">
                                <cv:msg key="label.schedule" bundle="ediscovery" />
                            </span>
                            <span class="pageDetailColumn" data-ng-if="clientDetailsCtrl.client">
                                <schedule entity-id="clientDetailsCtrl.client.clientId" entity-type="clientDetailsCtrl.entityType" entity-name="clientDetailsCtrl.client.hostName" />
                            </span>
                        </li>
                    </ul>
                </cv-tile-component>
            </div>
            <div class="col-md-6">
                <cv-ds-security-component
                entity-type='clientDetailsCtrl.entityType'
                generic-entity = 'clientDetailsCtrl.genericEntity'
                associations='clientDetailsCtrl.formattedSecurityAssociations'
                associations-loaded='clientDetailsCtrl.associationsLoaded'
                data-show-Owners='false'
                app-type='{{clientDetailsCtrl.appType}}'>
                </cv-ds-security-component>
            </div>
        </div>
        <cv-kendo-grid data-cv-grid-options="clientDetailsCtrl.datasourceGridOptions"></cv-kendo-grid>
    </div>
</div>
