<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.distributedSystem"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<span data-ng-if="!localDataObject.isEditMode"><cv:msg
				key="label.configureDistributedSystem" bundle="distributedSystem" /></span> <span
			data-ng-if="localDataObject.isEditMode"><cv:msg
				key="label.editDistributedSystem" bundle="distributedSystem" /></span>
	</h1>
</div>

<div class="text-center" data-ng-show="!localDataObject.showModal">
	<img
		src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
</div>
<div class="bootstrap-wrapper modal-margin margin-top-10 form-horizontal" id="divForm" >
<form novalidate autocomplete="off" id="distributedSystem"  cv-hide-Api
	name="distributedSystem" data-cv-submit="submitClick()"
	data-ng-if="localDataObject.showModal">
	<div class="">
		<br>


		<!-- Name : START -->
		<div class="form-group margin-bottom-20"  id="divClientGroupNameRow">

				<label for="clientGroupName" class="col-xs-12 col-sm-4"><cv:msg key="label.name" bundle="distributedSystem" /></label>

				<div class="col-xs-12 col-sm-8" data-ng-disabled="localDataObject.isEditMode"  id="divClientGroupName">
					<input type="text" name="clientGroupName" id="clientGroupName"
					placeholder="<cv:msg key="label.name" bundle="distributedSystem" />"
					data-ng-model="localDataObject.clientGroupName" required />
					<span class="help-block"
					data-ng-show="cv.distributedSystem.needsAttention(distributedSystem.clientGroupName)">
					<i class="ion-alert-circled"></i> <cv:msg
						key="error.defineConfigurationName" bundle="distributedSystem" />
				</span>

				</div>
			</div>
		<!-- Name : END -->



		<!-- Service type : START -->
<div class="panel panel-default" >
<div class="panel-body no-padding"  id="divServiceTypeRow">

<cv-plain-accordion  accordion-label="label.configureServices" collapsed="localDataObject.collapsed">

		<div class="form-group  margin-bottom-10" >
			<!--  for="serviceType" removed from below label because it allows to change even disabled isteven -->
			<label  class="col-xs-12 col-sm-4"><cv:msg
					key="label.serviceType" bundle="distributedSystem"></cv:msg></label>
			<div class="col-xs-12 col-sm-8" data-ng-disabled="localDataObject.editItemCommonId > 0">

				<isteven-multi-select id="dsServiceType"
				data-input-model="localDataObject.serviceTypes"
				data-output-model="localDataObject.selectedServiceType"
					data-tick-property="checked"
					data-item-label="serviceName"
					class="isteven-multi-select user-group-select"
					data-button-label="serviceName"
					data-helper-elements="filter"
					data-selection-mode="single"
					on-item-click="serviceTypeClick (data)"
					directive-id="serviceType"></isteven-multi-select>

					<!--
					keep this in case we need to display validation message for above isteven
				<input type="text" style="display: none"
					data-ng-model="localDataObject.selectedServiceType"
					name="validateSourceServer" required />
					<span class="help-block"
					data-ng-show="cv.distributedSystem.needsAttention(distributedSystem.validateSourceServer)">
					<i class="ion-alert-circled"></i> <cv:msg
						key="error.selectServiceType" bundle="distributedSystem" />
				</span>
				-->

			</div>
		</div>


<div   data-ng-if="localDataObject.selectedServiceType && localDataObject.selectedServiceType.length > 0">

<!-- PROPERTIES : START -->
<div ng-repeat="item in localDataObject.nameValueMap" data-ng-if="localDataObject.nameValueMap"  id="divDynamicFields">
			<!-- ng-attr-id="{{'title'+$index}}"  -->
			<div data-ng-if="!item.isPasswordField">
			<!--  This div is for any property, other than password type -->
					<div class="form-group  margin-bottom-10">
						<label for="{{'propName'+$index}}" class="col-xs-12 col-sm-4" >{{item.propertyDisplayName}}</label>
						<div class="col-xs-12 col-sm-8">
						<input type='text' id="{{'propName'+$index}}"
						placeholder="{{item.propertyDisplayName}}"
						data-ng-model="item.propertyValue" />
						<!-- display error message - START -->
								<span class="help-block" data-ng-if="localDataObject.showValidationMessage && !item.propertyValue" >
											<i class="ion-alert-circled" ></i>
											<cv:msg key="error.definePropertyValue" bundle="distributedSystem" params="<b>{{item.propertyDisplayName}}</b>"/>
										</span>
						<!-- display error message - END -->
					</div>
					</div>
			</div>
			<!--  SPECIFIC FOR PASSWORD FIELD - START  -->
			<div data-ng-if="item.isPasswordField">

			<div class="form-group  margin-bottom-10">
					<label for="{{'propName1'+$index}}" class="col-xs-12 col-sm-4">{{item.propertyDisplayName}}</label>
				<div class="col-xs-12 col-sm-8" >
					<input type="password" id="{{'propName1'+$index}}"
					placeholder="{{(localDataObject.isEditMode && !localDataObject.newlyAddedItemInEditMode && localDataObject.editItemCommonId > 0) ? localDataObject.passwordPlaceholder : item.propertyDisplayName}}" data-ng-model="item.propertyValue" />
					<!-- display error message -->
							<span class="help-block" data-ng-if="(localDataObject.showValidationMessage && !item.propertyValue && !localDataObject.isEditMode) ||  (localDataObject.showValidationMessage && !item.propertyValue && localDataObject.isEditMode && localDataObject.newlyAddedItemInEditMode)" >
										<i class="ion-alert-circled" ></i>
										<cv:msg key="error.definePropertyValue" bundle="distributedSystem" params="<b>{{item.propertyDisplayName}}</b>"/>
									</span>
					<!-- display error message -->
				</div>
			</div>

				<!--  This div is for any property which is password type, need to display confirm password for that property -->
				<div class="form-group  margin-bottom-10">
					<label for="{{'confirmPassword1'+$index}}" class="col-xs-12 col-sm-4" ><cv:msg
					key="label.confirmPassword" bundle="distributedSystem" /></label>
				<div class="col-xs-12 col-sm-8" >
					<input type="password" placeholder="<cv:msg
					key="label.confirmPassword" bundle="distributedSystem" />"
					id="{{'confirmPassword1'+$index}}" data-ng-model="item.confirmPasswordValue"  />
				<!-- display error message - Confirm Password - START -->
							<span class="help-block" data-ng-if="(localDataObject.showValidationMessage && !item.confirmPasswordValue && !localDataObject.isEditMode) ||  (localDataObject.showValidationMessage && !item.confirmPasswordValue && localDataObject.isEditMode && localDataObject.newlyAddedItemInEditMode)" >
										<i class="ion-alert-circled" ></i>
										<span data-ng-bind-html="localDataObject.defineConformPasswordValue"></span>
									</span>
							<span class="help-block" data-ng-if="item.showPasswordMatchMsg" >
										<i class="ion-alert-circled" ></i>
										<cv:msg key="error.showPasswordMismatch" bundle="distributedSystem" />
									</span>
				<!-- display error message - Confirm Password - END -->
				</div>
				</div>
			</div>

			<!--  SPECIFIC FOR PASSWORD FIELD - END  -->
	</div>
<!-- PROPERTIES : END -->

<!-- PROXY : START
TODO: keep this proxy dropdown, this will be needed later. For now just using first proxy
<div class="form-group" >
<label for="proxy1" class="col-xs-12 col-sm-4"><cv:msg key="label.name" bundle="distributedSystem" /></label>

	<div class="col-xs-12 col-sm-8">
		<cv-select-proxy
                        id="proxy1"
                        name="proxy1"
                        model="localDataObject.proxyList"
                        ctrl="localDataObject.ctrl"
                        selection="single">
                     </cv-select-proxy>

	</div>
					</div>
					-->
<!-- PROXY : END -->

<!-- ADD Mode Buttons : START -->
<div class="float-right margin-top-10"  data-ng-if="localDataObject.editItemCommonId === 0"  id="divAddButton">
	<button type="button" id="cancelAddComponent" class="btn btn-default cvBusyOnAjax" data-ng-click="cancelAddOREditItem()"
				>
				<cv:msg key="Cancel"  bundle="messages"/>
			</button>
			<button type="button" id="addComponent" class="btn btn-primary cvBusyOnAjax" data-ng-click="addComponent()"
				>
				<cv:msg key="Add" bundle="messages" />
			</button>

</div>
<!-- ADD Mode Buttons : END -->

<!-- EDIT Mode Buttons : START -->
<div class="float-right margin-top-10" data-ng-if="localDataObject.editItemCommonId > 0"  id="divEditButton">
	<button type="button"  id="cancelUpdateComponent" class="btn btn-default cvBusyOnAjax" data-ng-click="cancelAddOREditItem()"
				>
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button  type="button" id="editComponent" class="btn btn-primary cvBusyOnAjax" data-ng-click="updateComponent()"
				>
				<cv:msg key="update" bundle="distributedSystem" />
			</button>

</div>
<!-- EDIT Mode Buttons : START -->

</div>
</cv-plain-accordion>

</div>
</div>
<!-- Service type : END -->

<!-- Display Validation Message : START -->
<div class="form-group"  id="divValidationMessage">
	<span class="server-message margin-bottom-5 margin-left-5 {{serverMessage.type}}" data-ng-bind-html="serverMessage.message"></span>
</div>
<!-- Display Validation Message : END -->

		<!-- GRID : START -->
		<div class="form-group" >
			<div class="col-xs-12">
				<h4 class="margin-left-0">
					<cv:msg key="label.servicesConfigired" bundle="distributedSystem" />
				</h4>
			</div>
		</div>
		<div class="scrolling-div-300"  id="divDSGrid">
			<cv-kendo-grid id="gridDistributedSystem" cv-grid-options="gridOptions"></cv-kendo-grid>
		</div>
		<!-- GRID : END -->


		<!-- Validation message for GRID : START -->
		<div class="form-group"  id="divValidationMessageForDSGrid">
			<div class="col-lg-6 offset-lg-6">

				<span data-ng-if="!localDataObject.gridData || localDataObject.gridData.length === 0">
					<input
					type="text" style="display: none"
					data-ng-model="localDataObject.gridData"
					name="validateList" required />
					<span
						class="help-block"
						data-ng-show="cv.distributedSystem.needsAttention(distributedSystem.validateList)">
							<i class="ion-alert-circled"></i> <cv:msg
								key="error.configureAtleastOne" bundle="distributedSystem" />
					</span>
				</span>
			</div>
		</div>
		<!-- Validation message for GRID : END -->


		<!-- submit button : START -->
		<div class="button-container"  id="divSubmitButton">
			<button id="dsCancel" type="button"
				class="btn btn-default cvBusyOnAjax setup-btn--hidden"
				data-ng-click="cancel()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="dsSubmit" class="btn btn-primary cvBusyOnAjax" type="submit"
			data-ng-disabled="localDataObject.disableSubmitButton"
				>
				<cv:msg key="Save" bundle="messages" />
			</button>
		</div>
		<!-- submit button : END -->
	</div>
</form>
</div>