<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="label.updateReplicaServers" bundle="sqlserver" />
	</h1>
</div>
<div class="form-horizontal bootstrap-wrapper modal-margin">
	<form name="updateAgReplicaClientsForm" autocomplete="off">
		<div class="form-group">
			<div class="col-xs-12">
				<span class="server-message {{serverMessage.type}}"
					data-ng-bind="serverMessage.message"></span>
			</div>
		</div>

		<div class="form-group">
			<label class="col-sm-5" for="hostName">
				<cv-help-text help-label="label.primaryReplica"
					help-text="help.primaryReplica"></cv-help-text>
			</label>
			<div class="col-sm-7"
				data-ng-disabled="!enableClientDropDown">
				<isteven-multi-select
					data-input-model="physicalClientList"
					data-output-model="selectedClients" data-tick-property="selected"
					data-item-label="clientName"
					class="isteven-multi-select user-group-select modal-right"
					name="physicalClient" directive-id="sqlPhysicalClient"
					data-button-label="clientName" helper-elements="filter"
					max-labels="1" data-search-property="clientName"
					data-selection-mode="single"
					translation="localLang" id="sqlPhysicalClient"
					on-close="clientChanged(selectedClients)">
				</isteven-multi-select>
				<span class="help-block"
					data-ng-show="enableClientDropDown && attempted && !model.selectedPhysicalClient">
					<cv:msg key="label.selectServer" bundle="ebsApp" />
				</span>
			</div>
		</div>
		<div class="form-group">
			<label class="col-sm-5">
				<cv:msg key="label.sqlServerInstance" bundle="clients" />
			</label>
			<div class="col-sm-7"
				data-ng-disabled="!enableInstanceDropDown">
				<isteven-multi-select
					data-input-model="physicalInstanceList"
					data-output-model="selectedInstances" data-tick-property="selected"
					data-item-label="instanceName"
					class="isteven-multi-select user-group-select modal-right"
					name="physicalInstance" directive-id="sqlPhysicalInstance"
					data-button-label="instanceName" helper-elements="filter"
					max-labels="1" data-search-property="instanceName"
					data-selection-mode="single"
					translation="localLang" id="sqlPhysicalInstance"
					on-close="instanceChanged(selectedInstances)">
				</isteven-multi-select>
				<span class="help-block"
					data-ng-show="enableInstanceDropDown && attempted && !model.selectedPhysicalInstance">
					<cv:msg key="label.selectInstance" bundle="sqlserver" />
				</span>
			</div>
		</div>
			<div class="modal-footer">
		<button id="sqlCreateAGInstances_button_#9238" type="button"
			class="btn btn-default cvBusyOnAjax setup-btn--hidden"
			data-ng-click="cancelModel()">
			<span>
				<cv:msg key="Cancel" bundle="messages" />
			</span>
		</button>
		<button id="sqlCreateAGInstances_button_#8863" type="submit"
			class="btn btn-primary cvBusyOnAjax" data-ng-disabled="!sqlAvailabilityGroup || !SQLAvailabilityReplicasList" data-ng-
			data-ng-click="updateAgReplicaClients()">
			<span>
				<cv:msg key="OK" bundle="messages" />
			</span>
		</button>
	</div>
	</form>
</div>