<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>//also needed for displaying the toast message
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
</script>
<script type="text/ng-template" id="hardwareRevert.html">
	<cv-hardware-revert
		snap-backup-enabled="sqlRestoreCtrl.restoreData.isSnapBackupEnabled"
		is-inplace-restore="sqlRestoreCtrl.restoreData.isInplaceRestore"
		entity="sqlRestoreCtrl.entity"
		proxy-client="sqlRestoreCtrl.restoreData.hardwareRevertProxyClient"
		hardware-revert="sqlRestoreCtrl.restoreData.hardwareRevert"
		label-class="'col-xs-12 col-sm-4'"
		select-class="'col-xs-12 col-sm-8'">
	</cv-hardware-revert>
</script>

<form name="restoreForm" novalidate
	data-cv-submit="sqlRestoreCtrl.doRestore()" id="sqlRestoreForm"
	data-cv-validate="sqlRestoreCtrl.validateRestoreInputs()">
	<div class="modal-header">
		<h1 class="modal-title">{{sqlRestoreCtrl.dialogTile}}</h1>
	</div>
	<div class="modal-body bootstrap-wrapper form-horizontal">
		<div id="modern-tab">
			<cv-tabset-component control='sqlRestoreCtrl.tabControls'>
			<!-- TAB 1 : In place --> <cv-tab
				tabname="<cv:msg key="label.restoreInPlace" bundle="restore" />"
				data-ng-selected="sqlRestoreCtrl.onTabChanged()"
				hide-on="sqlRestoreCtrl.restoreData.hideInPlaceTab">
			<p class="restore-help-text padding-top-20">
				<cv:msg key="label.inPlaceRestoreDetails" bundle="restore" />
			</p>
			<div class="form-group"
				data-ng-if="!sqlRestoreCtrl.isSrcSqlCloudInstance">
				<div class="col-sm-4 margin-top-20 margin-bottom-10"
					for="destinationClient">
					<cv:msg key="label.destinationClient" bundle="sqlserver" />
				</div>
				<div class="col-sm-8 margin-top-20 margin-bottom-10">
					<span data-ng-if="!sqlRestoreCtrl.loadingInstances"
						data-ng-bind="sqlRestoreCtrl.destinationClient.clientName">
					</span>
					<span data-ng-if="sqlRestoreCtrl.loadingInstances">
						<cv:msg key="Loading" bundle="messages" />
					</span>
				</div>
			</div>
			<div class="form-group"
				data-ng-if="!sqlRestoreCtrl.restoreData.hideInPlaceTab">

				<div class="col-sm-4 margin-bottom-10" for="destinationInstance">
					<cv:msg key="label.destinationInstance" bundle="sqlserver" />
				</div>
				<div class="col-sm-8 margin-bottom-10">
					<span
						data-ng-bind="sqlRestoreCtrl.destinationInstance.instanceName"></span>
				</div>
			</div>
			<div class="form-group"
				data-ng-if="!sqlRestoreCtrl.restoreData.hideInPlaceTab">
				<div class="col-sm-4" for="destinationDatabase">
					<cv:msg key="label.destinationDatabase" bundle="saphana" />
				</div>
				<div class="col-sm-8">
					<ul>
						<li class="padding-top-0"
							data-ng-repeat="database in  sqlRestoreCtrl.databaseList | orderBy:'originalDatabaseName' | limitTo:sqlRestoreCtrl.databaseDisplayLimit">{{database.originalDatabaseName}}</li>
						<li
							data-ng-show="(sqlRestoreCtrl.databaseList.length > 3) && (sqlRestoreCtrl.databaseDisplayLimit !== sqlRestoreCtrl.databaseList.length)"
							class="tile-content-link padding-top-0">
							<a href=""
								data-ng-click="sqlRestoreCtrl.databaseDisplayLimit = sqlRestoreCtrl.databaseList.length">
								<cv:msg key="content.label.more.db" bundle="exchange" />
								(
								<cv:msg key="label.db.content.count" bundle="exchange" />
								{{sqlRestoreCtrl.databaseList.length}})
							</a>
						</li>
					</ul>
				</div>
			</div>
			<div data-ng-if="!sqlRestoreCtrl.restoreData.hideInPlaceTab"
				data-ng-include="'hardwareRevert.html'"></div>
			<div data-ng-if="!sqlRestoreCtrl.restoreData.hideInPlaceTab"
				class="global-options remove-border-padding padding-top-10">
				<cv-alert-me selected="false"
					text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
			</div>
			<div class="form-group"
				data-ng-if="!sqlRestoreCtrl.restoreData.hideInPlaceTab">
				<span for="overwrittenWarning" class="serverMessage error">
					{{sqlRestoreCtrl.overwrittenWarning}} </span>
			</div>
			</cv-tab> <!-- TAB 2 : out of place --> <cv-tab
				tabname={{sqlRestoreCtrl.tabNameSecond}}
				data-ng-selected="sqlRestoreCtrl.onTabChanged()">
			<p class="restore-help-text padding-top-20">
				{{sqlRestoreCtrl.oopRestoreHelpText}}</p>

			<!-- destination client -->
			<div class="form-group">
				<label class="col-sm-4 margin-top-20" for="destinationClient">
					<cv:msg key="label.destinationClient" bundle="sqlserver" />
				</label>
				<div class="col-sm-8 margin-top-20">
					<span data-ng-if="!sqlRestoreCtrl.loadingInstances"
						data-ng-bind="sqlRestoreCtrl.destinationClient.clientName">
					</span>
					<span data-ng-if="sqlRestoreCtrl.loadingInstances">
						<cv:msg key="Loading" bundle="messages" />
					</span>
				</div>
			</div>

			<!-- destination instance -->
			<div class="form-group">
				<label class="col-sm-4" for="destinationInstance">
					<cv:msg key="label.destinationInstance" bundle="sqlserver" />
				</label>
				<div class="col-sm-8">
					<select name="destinationInstance" required
						data-ng-disabled="sqlRestoreCtrl.loadingInstances"
						data-ng-model="sqlRestoreCtrl.destinationInstance"
						data-ng-options="ds as ds.instanceName for ds in sqlRestoreCtrl.destinationInstanceOOPList | orderBy:'instanceName' track by ds.instanceId"
						data-ng-change="sqlRestoreCtrl.destinationInstanceChanged(sqlRestoreCtrl.destinationInstance)">
						<option value=""><cv:msg key="label.selectInstance"
								bundle="sqlserver" /></option>
					</select>
					<div class="help-block"
						data-ng-show="sqlRestoreCtrl.attempted && !sqlRestoreCtrl.destinationInstance">
						<cv:msg key="label.selectInstance" bundle="sqlserver" />
					</div>
				</div>
			</div>

			<!-- proxy client -->
			<div class="form-group" data-ng-if="sqlRestoreCtrl.showProxyClient">
				<label class="col-sm-4" for="proxyClient">
					<cv:msg key="label.proxyClient" bundle="sqlserver" />
				</label>

				<!-- make proxy server display label only when staging server dropdown visible -->
				<label class="col-sm-8"
					data-ng-if="sqlRestoreCtrl.showstagingInstance">
					{{sqlRestoreCtrl.proxyClient.clientName}} </label>

				<!-- make proxy server dropdown list when staging server dropdown invisible-->
				<div class="col-sm-8"
					data-ng-if="!sqlRestoreCtrl.showstagingInstance">
					<select name="proxyClient" required
						data-ng-disabled="sqlRestoreCtrl.loadingStagingInstances"
						data-ng-model="sqlRestoreCtrl.proxyClient"
						data-ng-options="ds as ds.clientName for ds in sqlRestoreCtrl.proxyClientList | orderBy:'clientName' track by ds.clientId"
						data-ng-change="sqlRestoreCtrl.proxyClientChanged(sqlRestoreCtrl.proxyClient)">
						<option value=""><cv:msg key="label.selectServer"
								bundle="ebsApp" /></option>
					</select>
					<div class="help-block"
						data-ng-show="sqlRestoreCtrl.attempted && !sqlRestoreCtrl.proxyClient">
						<cv:msg key="label.selectServer" bundle="ebsApp" />
					</div>
				</div>

			</div>

			<!-- staging instance -->
			<div class="form-group"
				data-ng-if="sqlRestoreCtrl.showstagingInstance">
				<label class="col-sm-4" for="stagingInstance">
					<cv:msg key="label.stagingInstance" bundle="sqlserver" />
				</label>
				<div class="col-sm-8">
					<select name="stagingInstance" required
						data-ng-disabled="sqlRestoreCtrl.loadingStagingInstances"
						data-ng-model="sqlRestoreCtrl.stagingInstance"
						data-ng-options="ds as ds.instanceName for ds in sqlRestoreCtrl.stagingInstanceList | orderBy:'instanceName' track by ds.instanceId"
						data-ng-change="sqlRestoreCtrl.stagingInstanceChanged(sqlRestoreCtrl.stagingInstance)">
						<option value=""><cv:msg key="label.selectInstance"
								bundle="sqlserver" /></option>
					</select>
					<div class="help-block"
						data-ng-show="sqlRestoreCtrl.attempted && !sqlRestoreCtrl.stagingInstance">
						<cv:msg key="label.selectInstance" bundle="sqlserver" />
					</div>
				</div>
			</div>

			<div class="form-group" data-ng-if="sqlRestoreCtrl.showStagingPath">
				<label class="col-sm-4" for="stagingPath">
					{{sqlRestoreCtrl.stagingPath.label}} </label>
				<div class="col-sm-8">
					<div class="input-group">
						<input type="text" id="stagingPath" name="stagingPath"
							data-ng-model="sqlRestoreCtrl.stagingPath.value"
							data-ng-required="sqlRestoreCtrl.showStagingPath"
							title="{{sqlRestoreCtrl.stagingPath.value}}" />
						<span class="input-group-btn"
							data-ng-disabled="!sqlRestoreCtrl.stagingPathClient">
							<cv-machine-browse
								button-label='<cv:msg key="label.browse" bundle="restore"/>'
								client-id='{{sqlRestoreCtrl.stagingPathClient.clientId}}'
								result-function="sqlRestoreCtrl.stagingPathResultFunction">
							</cv-machine-browse>
						</span>

					</div>
					<div class="help-block"
						data-ng-show="sqlRestoreCtrl.attempted && sqlRestoreCtrl.showStagingPath && !sqlRestoreCtrl.stagingPath.value">
						{{sqlRestoreCtrl.stagingPath.error}}</div>
				</div>
			</div>

			<div class="form-group modalForm-overflow-scroll data-file-grid"
				data-ng-if="!(sqlRestoreCtrl.isSqlAnalysisServiceInstance)">
				<uib-accordion close-others="false" class="text-left">
				<div uib-accordion-group is-open="sqlRestoreCtrl.status.dataFiles">
					<uib-accordion-heading> <cv:msg
						key="label.dataFiles" bundle="sqlserver" /> <i
						class="pull-right glyphicon"
						data-ng-class="{'glyphicon-chevron-down': sqlRestoreCtrl.status.dataFiles, 'glyphicon-chevron-right': !sqlRestoreCtrl.status.dataFiles}"></i></uib-accordion-heading>

					<p data-ng-if="!sqlRestoreCtrl.isDestSqlCloudInstance"
						class="restore-help-text">
						<cv:msg key="help.OOPPath" bundle="sqlserver" />
					</p>
					<ul class="vm-full-restore-list sql restore-left-side">
						<li
							data-ng-repeat="database in sqlRestoreCtrl.databaseList | orderBy:'originalDatabaseName' ">
							<a class="btn"
								data-ng-click="sqlRestoreCtrl.setSelectedDatabase(database)"
								title="{{database.originalDatabaseName}}"
								data-ng-class="{'selected-value': database.originalDatabaseName == sqlRestoreCtrl.selectedDatabase.originalDatabaseName && sqlRestoreCtrl.isDatabaseNodeSelected}">{{database.originalDatabaseName}}
							</a>
							<ul data-ng-if="!sqlRestoreCtrl.isDestSqlCloudInstance">
								<li data-ng-repeat="sqlDbDeviceItem in database.files">
									<a class="btn"
										data-ng-click="sqlRestoreCtrl.setSelectedSqlDbdeviceItem(sqlDbDeviceItem)"
										title="{{sqlDbDeviceItem.logicalFileName}}"
										data-ng-class="{'selected-value': sqlDbDeviceItem.fileName == sqlRestoreCtrl.selectedSqlDbdeviceItem.fileName && !sqlRestoreCtrl.isDatabaseNodeSelected}">-{{sqlDbDeviceItem.logicalFileName}}
									</a>
								</li>
							</ul>
						</li>
					</ul>
					<div
						class="vm-full-restore-form form-horizontal bootstrap-wrapper restore-right-side padding-bottom-0">
						<div id="perFileOptions" class="mainFormContent">
							<span data-ng-if="sqlRestoreCtrl.isDatabaseNodeSelected">
								<div class="form-group">
									<label class="col-sm-4" for="destinationDatabase">
										<cv:msg key="label.destinationDatabase" bundle="saphana" />
									</label>
									<div class="col-sm-8">
										<input type="text" id="destinationDatabase"
											name="destinationDatabase"
											data-ng-model="sqlRestoreCtrl.selectedDatabase.databaseName"
											data-ng-required=true
											title="{{sqlRestoreCtrl.selectedDatabase.databaseName}}"
											data-ng-blur="sqlRestoreCtrl.changeAllDatabaseNames(sqlRestoreCtrl.selectedDatabase.databaseName)" />
										<div class="help-block"
											data-ng-show="sqlRestoreCtrl.attempted && !sqlRestoreCtrl.selectedDatabase.databaseName">
											<cv:msg key="error.dbName" bundle="oracle" />
										</div>
										<div class="help-block"
											data-ng-show="sqlRestoreCtrl.attempted && !sqlRestoreCtrl.isDestSqlCloudInstance && sqlRestoreCtrl.destinationInstance.instanceId === sqlRestoreCtrl.entity.instanceId &&
											sqlRestoreCtrl.selectedDatabase.databaseName === sqlRestoreCtrl.selectedDatabase.originalDatabaseName">
											<cv:msg key="error.changeDatabaseName" bundle="sqlserver" />
										</div>
									</div>
								</div>
								<div class="form-group"
									data-ng-if="!sqlRestoreCtrl.isDestSqlCloudInstance">
									<label class="col-sm-4" for="dataFilePath">
										<cv:msg key="label.dataFilePath" bundle="sqlserver" />
									</label>
									<div class="col-sm-8">
										<div class="input-group">
											<input type="text" id="dataFilePath" name="dataFilePath"
												data-ng-model="sqlRestoreCtrl.selectedDatabase.dataFilePath"
												data-ng-required=true
												data-ng-blur="sqlRestoreCtrl.changeAllDataFilePaths(sqlRestoreCtrl.selectedDatabase.dataFilePath)"
												title="{{sqlRestoreCtrl.selectedDatabase.dataFilePath}}" />
											<span class="input-group-btn"
												data-ng-disabled="!sqlRestoreCtrl.destinationClient">
												<cv-machine-browse
													button-label='<cv:msg key="label.browse" bundle="restore"/>'
													client-id='{{sqlRestoreCtrl.destinationClient.clientId}}'
													result-function="sqlRestoreCtrl.dataFilePathResultFunction">
												</cv-machine-browse>
											</span>
										</div>
										<div class="help-block"
											data-ng-show="sqlRestoreCtrl.attempted && !sqlRestoreCtrl.isDestSqlCloudInstance && (!sqlRestoreCtrl.selectedDatabase || !sqlRestoreCtrl.selectedDatabase.dataFilePath)">
											<cv:msg key="label.selectAPath" bundle="browse" />
										</div>
										<div class="help-block"
											data-ng-show="sqlRestoreCtrl.dataFilePathError.length > 0">
											{{sqlRestoreCtrl.dataFilePathError}}
										</div>
									</div>
								</div>
								<div class="form-group"
									data-ng-if="!sqlRestoreCtrl.isDestSqlCloudInstance">
									<label class="col-sm-4" for="logFilePath">
										<cv:msg key="label.logFilePath" bundle="sqlserver" />
									</label>
									<div class="col-sm-8">
										<div class="input-group">
											<input type="text" id="logFilePath" name="logFilePath"
												data-ng-model="sqlRestoreCtrl.selectedDatabase.logFilePath"
												data-ng-required=true
												data-ng-blur="sqlRestoreCtrl.changeAllLogFilePaths(sqlRestoreCtrl.selectedDatabase.logFilePath)"
												title="{{sqlRestoreCtrl.selectedDatabase.logFilePath}}" />
											<span class="input-group-btn"
												data-ng-disabled="!sqlRestoreCtrl.destinationClient">
												<cv-machine-browse
													button-label='<cv:msg key="label.browse" bundle="restore"/>'
													client-id='{{sqlRestoreCtrl.destinationClient.clientId}}'
													result-function="sqlRestoreCtrl.logFilePathResultFunction">
												</cv-machine-browse>
											</span>
										</div>
										<div class="help-block"
											data-ng-show="sqlRestoreCtrl.attempted && (!sqlRestoreCtrl.isDestSqlCloudInstance) && (!sqlRestoreCtrl.selectedDatabase || !sqlRestoreCtrl.selectedDatabase.logFilePath)">
											<cv:msg key="label.selectAPath" bundle="browse" />
										</div>
										<div class="help-block"
											data-ng-show="sqlRestoreCtrl.logFilePathError.length > 0">
											{{sqlRestoreCtrl.logFilePathError}}
										</div>
									</div>
								</div>
							</span>
							<span data-ng-if="!sqlRestoreCtrl.isDatabaseNodeSelected">
								<div class="form-group">
									<label class="col-sm-4" for="fileName">
										{{sqlRestoreCtrl.selectedSqlDbdeviceItem.fileNameLabel}} </label>
									<div class="col-sm-8">
										<input type="text" id="physicalFileName"
											name="physicalFileName"
											data-ng-model="sqlRestoreCtrl.selectedSqlDbdeviceItem.physicalFileName"
											title="{{sqlRestoreCtrl.selectedSqlDbdeviceItem.physicalFileName}}"
											data-ng-required=true />
										<div class="help-block"
											data-ng-show="sqlRestoreCtrl.attempted && !sqlRestoreCtrl.selectedSqlDbdeviceItem.physicalFileName">
											<cv:msg key="help.fileName" bundle="sqlserver" />
										</div>
									</div>
								</div>
								<div class="form-group"
									data-ng-if="!sqlRestoreCtrl.isDestSqlCloudInstance">
									<label class="col-sm-4" for="filePath">
										<cv:msg key="label.physicalPath" bundle="sqlserver" />
									</label>
									<label class="col-sm-8">
										<span
											data-ng-bind="sqlRestoreCtrl.selectedSqlDbdeviceItem.physicalFilePath"
											title="{{sqlRestoreCtrl.selectedSqlDbdeviceItem.physicalFilePath}}"></span>
									</label>
								</div>
								<div class="form-group">
									<label class="col-sm-4" for="fileSize">
										<cv:msg key="label.fileSize" bundle="sqlserver" />
									</label>
									<label class="col-sm-8">
										<span>
											{{sqlRestoreCtrl.selectedSqlDbdeviceItem.fileMaxSizeDisplay}}
										</span>
									</label>
								</div>
							</span>
						</div>
					</div>
				</div>
				<div uib-accordion-group
					is-open="sqlRestoreCtrl.status.additionalOptions"
					data-ng-if="!sqlRestoreCtrl.isDestSqlCloudInstance">
					<uib-accordion-heading> <cv:msg
						key="label.additionalOptions" bundle="restore" /> <i
						class="pull-right glyphicon"
						data-ng-class="{'glyphicon-chevron-down': sqlRestoreCtrl.status.additionalOptions, 'glyphicon-chevron-right': !sqlRestoreCtrl.status.additionalOptions}"></i></uib-accordion-heading>
					<div class="form-group"
						data-ng-if="!sqlRestoreCtrl.isDestSqlCloudInstance">
						<label class="col-xs-12 col-sm-4">
							<cv:msg key="label.recoveryTypes" bundle="sqlserver" />
						</label>
						<div class="col-xs-12 col-sm-8">
							<label>
								<input id="recovery" name="recoveryType" value="0"
									class="ng-valid ng-dirty ng-touched" type="radio"
									data-ng-model="sqlRestoreCtrl.restoreData.selectedRecoveryType"
									data-ng-change="sqlRestoreCtrl.recoveryTypeChanged()">
								<cv:msg key="label.recovery" bundle="sqlserver" />
							</label>
						</div>
						<div class="col-xs-12 col-sm-8 col-sm-offset-4">
							<label>
								<input id="noRecovery" name="recoveryType" value="1"
									class="ng-valid ng-dirty ng-touched" type="radio"
									data-ng-model="sqlRestoreCtrl.restoreData.selectedRecoveryType"
									data-ng-change="sqlRestoreCtrl.recoveryTypeChanged()">
								<cv:msg key="label.noRecovery" bundle="sqlserver" />
							</label>
						</div>
						<div class="col-xs-12 col-sm-8 col-sm-offset-4">
							<label>
								<input id="standBy" name="recoveryType" value="2"
									class="ng-valid ng-dirty ng-touched" type="radio"
									data-ng-model="sqlRestoreCtrl.restoreData.selectedRecoveryType"
									data-ng-change="sqlRestoreCtrl.recoveryTypeChanged()">
								<cv:msg key="label.standBy" bundle="sqlserver" />
							</label>
						</div>
					</div>
					<div class="form-group"
						data-ng-if="!sqlRestoreCtrl.isDestSqlCloudInstance">
						<label class="col-xs-12 col-sm-4 col-sm-offset-4"
							data-ng-if="sqlRestoreCtrl.showUndoFilePath">
							<cv:msg key="label.undoFilePath" bundle="sqlserver" />
						</label>
						<div class="col-xs-12 col-sm-8"
							data-ng-if="sqlRestoreCtrl.showUndoFilePath">
							<div class="input-group">
								<input type="text" name="undoFilePath" id="undoFilePath"
									data-ng-model="sqlRestoreCtrl.undoFilePath"
									data-ng-required="true" title="{{sqlRestoreCtrl.undoFilePath}}" />
								<span class="input-group-btn"
									data-ng-disabled="!sqlRestoreCtrl.destinationClient">
									<cv-machine-browse
										button-label='<cv:msg key="label.browse" bundle="restore"/>'
										client-id='{{sqlRestoreCtrl.destinationClient.clientId}}'
										result-function="sqlRestoreCtrl.undoFilePathResultFunction">
									</cv-machine-browse>
								</span>
							</div>
							<div class="help-block"
								data-ng-show="sqlRestoreCtrl.attempted && sqlRestoreCtrl.showUndoFilePath && !sqlRestoreCtrl.undoFilePath">
								<cv:msg key="label.selectAPath" bundle="browse" />
							</div>
						</div>
					</div>
					<div data-ng-if="!sqlRestoreCtrl.restoreData.hideInPlaceTab"
						data-ng-include="'hardwareRevert.html'"></div>
				</div>
				</uib-accordion>
			</div>
			<div data-ng-if="!sqlRestoreCtrl.restoreData.hideInPlaceTab"
				class="global-options remove-border-padding padding-top-10">
				<cv-alert-me selected="false"
					text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
			</div>
			<div class="form-group"
				data-ng-if="sqlRestoreCtrl.isSqlAnalysisServiceInstance">
				<label class="col-xs-12 col-sm-4">
					<cv:msg key="label.restore" bundle="restore" />
				</label>
				<div class="col-xs-12 col-sm-8">
					<input id="allowDatabaseOverwrite" type="checkbox"
						data-ng-model="sqlRestoreCtrl.asOptions.allowDatabaseOverwrite">
					<label for="allowDatabaseOverwrite" class="overwriteLabel">
						<cv:msg key="label.allowDatabaseOverwrite" bundle="sqlserver" />
					</label>
				</div>
				<div class="col-xs-12 col-sm-8  col-sm-offset-4">
					<input id="includeSecurityInformation" type="checkbox"
						data-ng-model="sqlRestoreCtrl.asOptions.includeSecurityInformation"
						data-ng-change="sqlRestoreCtrl.includeSecurityInformationChanged(sqlRestoreCtrl.asOptions.includeSecurityInformation)">
					<label for="includeSecurityInformation" class="overwriteLabel">
						<cv:msg key="label.includeSecurityInformation" bundle="sqlserver" />
						<select
							data-ng-if="sqlRestoreCtrl.asOptions.includeSecurityInformation"
							id="analysisServerSecurityInfo" name="analysisServerSecurityInfo"
							data-ng-model="sqlRestoreCtrl.asOptions.analysisServerSecurityInfo"
							data-ng-options="rt as rt.label for rt in sqlRestoreCtrl.analysisServerSecurityInfoOptions">
							<%-- <option value=""><cv:msg key="placeholder.selectDestinationServer" bundle="restoreJs"/></option>--%>
						</select>
					</label>
				</div>
				<div class="col-xs-12 col-sm-8 col-sm-offset-4">
					<input id="restoreRemotePartitions" type="checkbox"
						data-ng-model="sqlRestoreCtrl.asOptions.restoreRemotePartitions">
					<label for="restoreRemotePartitions" class="overwriteLabel">
						<cv:msg key="label.restoreRemotePartitions" bundle="sqlserver" />
					</label>
				</div>
			</div>
			</cv-tab> <!-- TAB 3 : Restore to disk --> <cv-tab
				tabname="<cv:msg key="label.rtdRestore" bundle="restore" />"
				data-ng-selected="sqlRestoreCtrl.onTabChanged()">
			<p class="restore-help-text padding-top-20">
				<cv:msg key="label.rtdRestoreDetails" bundle="restore" />
			</p>
			<div class="form-group">
				<label class="col-sm-4 margin-top-20" for="destinationClient">
					<cv:msg key="label.destinationClient" bundle="sqlserver" />
				</label>
				<div class="col-sm-8">
					<select name="destinationClient" required
						data-ng-if="!sqlRestoreCtrl.loadingRTDClients"
						data-ng-model="sqlRestoreCtrl.destinationClient"
						data-ng-options="ds as ds.clientName for ds in sqlRestoreCtrl.destinationClientRTDList | orderBy:'clientName' track by ds.clientId"
						data-ng-change="sqlRestoreCtrl.destinationClientChanged(sqlRestoreCtrl.destinationClient)">
						<option value=""><cv:msg key="label.selectServer"
								bundle="ebsApp" /></option>
					</select>
					<span data-ng-if="sqlRestoreCtrl.loadingRTDClients">
						<cv:msg key="Loading" bundle="messages" />
					</span>
					<div class="help-block"
						data-ng-show="sqlRestoreCtrl.attempted && !sqlRestoreCtrl.destinationClient">
						<cv:msg key="label.selectServer" bundle="ebsApp" />
					</div>
				</div>
			</div>
			<div class="form-group">
				<label class="col-sm-4" for="restoreToDiskPath">
					<cv:msg key="label.path" bundle="restore" />
				</label>
				<div class="col-sm-8">
					<div class="input-group">
						<input type="text" id="restoreToDiskPath" name="restoreToDiskPath"
							data-ng-model="sqlRestoreCtrl.restoreToDiskPath"
							data-ng-required=true
							title="{{sqlRestoreCtrl.restoreToDiskPath}}" />
						<span class="input-group-btn"
							data-ng-disabled="!sqlRestoreCtrl.destinationClient">
							<cv-machine-browse
								button-label='<cv:msg key="label.browse" bundle="restore"/>'
								client-id='{{sqlRestoreCtrl.destinationClient.clientId}}'
								result-function="sqlRestoreCtrl.restoreToDiskPathFunction">
							</cv-machine-browse>
						</span>
					</div>
					<div class="help-block"
						data-ng-show="sqlRestoreCtrl.attempted && !sqlRestoreCtrl.restoreToDiskPath">
						<cv:msg key="label.selectAPath" bundle="browse" />
					</div>
				</div>
			</div>
			</cv-tab> </cv-tabset-component>
		</div>
	</div>
	<div class="modal-footer">
		<button id="sqlRestoreOptionsMultipleDBs_button_#4103"
			class="btn btn-default cvBusyOnAjax setup-btn--hidden" type="button"
			data-ng-click="sqlRestoreCtrl.cancelModel()">
			<cv:msg key="Cancel" bundle="messages" />
		</button>
		<button id="sqlRestoreOptionsMultipleDBs_button_#6181" type="submit"
			class="btn btn-primary cvBusyOnAjax">
			<cv:msg key="Submit" bundle="messages" />
		</button>
	</div>
</form>
