<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>//also needed for displaying the toast message
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
</script>
<form name="restoreForm" class="form-horizontal" novalidate>
	<div class="modal-header">
		<h1 class="modal-title">{{sqlRestoreCtrl.dialogTile}}</h1>
	</div>
	<div class="modal-body bootstrap-wrapper">
		<div id="modern-tab">
			<cv-tabset-component control='sqlRestoreCtrl.tabControls'>
			<!-- TAB 1 : In place --> <cv-tab
				tabname="<cv:msg key="label.restoreInPlace" bundle="restore" />"
				data-ng-selected="sqlRestoreCtrl.onTabChanged()"
				hide-on="sqlRestoreCtrl.isSrcSqlCloudInstance || sqlRestoreCtrl.isSqlAnalysisServiceInstance">
			<!--<cv-help-component
				help-text="<cv:msg key="label.inPlaceRestoreDetails" bundle="restore"/>"></cv-help-component>-->
			<div class="form-group"
				data-ng-if="!sqlRestoreCtrl.isSrcSqlCloudInstance && !sqlRestoreCtrl.isSqlAnalysisServiceInstance">
				<div class="col-sm-4 margin-top-20 margin-bottom-10"
					for="destinationClient">
					<cv:msg key="label.destinationClient" bundle="sqlserver" />
				</div>
				<div class="col-sm-8 margin-top-20 margin-bottom-10">
					<!-- <a href="javascript: void(0);"> confirm if we have to make it hyperlink-->
					<span data-ng-if="!sqlRestoreCtrl.loadingInstances"
						data-ng-bind="sqlRestoreCtrl.destinationClient.clientName">
					</span>
					<span data-ng-if="sqlRestoreCtrl.loadingInstances">
						<cv:msg key="Loading" bundle="messages" />
					</span>
					<!--</a>-->
				</div>
			</div>
			<div class="form-group"
				data-ng-if="!sqlRestoreCtrl.isSrcSqlCloudInstance && !sqlRestoreCtrl.isSqlAnalysisServiceInstance">
				<div class="col-sm-4 margin-bottom-10" for="destinationInstance">
					<cv:msg key="label.destinationInstance" bundle="sqlserver" />
				</div>
				<div class="col-sm-8">
					<span
						data-ng-bind="sqlRestoreCtrl.destinationInstance.instanceName"></span>
				</div>
			</div>
			<div class="form-group"
				data-ng-if="!sqlRestoreCtrl.isSrcSqlCloudInstance && !sqlRestoreCtrl.isSqlAnalysisServiceInstance">
				<div class="col-sm-4 margin-bottom-10" for="destinationDatabase">
					<cv:msg key="label.destinationDatabase" bundle="saphana" />
				</div>
				<div class="col-sm-8">
					<span data-ng-bind="sqlRestoreCtrl.selectedDatabase.databaseName"></span>
				</div>
			</div>
			<div class="form-group"
				data-ng-if="!sqlRestoreCtrl.isSrcSqlCloudInstance && !sqlRestoreCtrl.isSqlAnalysisServiceInstance">
				<span for="overwrittenWarning" class="serverMessage error">
					{{sqlRestoreCtrl.overwrittenWarning}} </span>
			</div>
			</cv-tab> <!-- TAB 2 : out of place --> <cv-tab
				tabname={{sqlRestoreCtrl.tabNameSecond}}
				data-ng-selected="sqlRestoreCtrl.onTabChanged()"> <!--<cv-help-component
				help-text="<cv:msg key="label.OOPRestoreDetails" bundle="restore"/>"></cv-help-component>-->
			<div class="form-group">
				<label class="col-sm-4 margin-top-20" for="destinationClient">
					<cv:msg key="label.destinationClient" bundle="sqlserver" />
				</label>
				<div class="col-sm-8">
					<select name="destinationClient" required
						data-ng-if="!sqlRestoreCtrl.loadingInstances"
						data-ng-model="sqlRestoreCtrl.destinationClient"
						data-ng-options="ds as ds.clientName for ds in sqlRestoreCtrl.destinationClientList | orderBy:'clientName' track by ds.clientId"
						data-ng-change="sqlRestoreCtrl.destinationClientChanged(sqlRestoreCtrl.destinationClient)">
						<option value=""><cv:msg key="label.selectServer"
								bundle="ebsApp" /></option>
					</select>
					<span data-ng-if="sqlRestoreCtrl.loadingInstances">
						<cv:msg key="Loading" bundle="messages" />
					</span>
					<div class="help-block"
						data-ng-show="sqlRestoreCtrl.attempted && !sqlRestoreCtrl.destinationClient">
						<cv:msg key="label.selectServer" bundle="ebsApp" />
					</div>
				</div>
			</div>
			<div class="form-group">
				<label class="col-sm-4" for="destinationInstance">
					<cv:msg key="label.destinationInstance" bundle="sqlserver" />
				</label>
				<div class="col-sm-8">
					<select name="destinationInstance" required
						data-ng-if="!sqlRestoreCtrl.loadingInstances"
						data-ng-model="sqlRestoreCtrl.destinationInstance"
						data-ng-options="ds as ds.instanceName for ds in sqlRestoreCtrl.destinationInstanceList | orderBy:'instanceName' track by ds.instanceId"
						data-ng-change="sqlRestoreCtrl.destinationInstanceChanged(sqlRestoreCtrl.destinationInstance)">
						<option value=""><cv:msg key="label.selectInstance"
								bundle="sqlserver" /></option>
					</select>
					<!--  <span data-ng-if="loadingInstances">
						<cv:msg key="Loading" bundle="messages" />
					</span>-->
					<div class="help-block"
						data-ng-show="sqlRestoreCtrl.attempted && !sqlRestoreCtrl.destinationInstance">
						<cv:msg key="label.selectInstance" bundle="sqlserver" />
					</div>
				</div>
			</div>
			<div class="form-group"
				data-ng-if="!sqlRestoreCtrl.isSqlAnalysisServiceInstance">
				<label class="col-sm-4" for="destinationDatabase">
					<cv:msg key="label.destinationDatabase" bundle="saphana" />
				</label>
				<div class="col-sm-8">
					<input type="text" id="destinationDatabase"
						name="destinationDatabase"
						data-ng-model="sqlRestoreCtrl.selectedDatabase.databaseName"
						data-ng-required=true />
					<div class="help-block"
						data-ng-show="sqlRestoreCtrl.attempted && !sqlRestoreCtrl.selectedDatabase.databaseName">
						<cv:msg key="help.database" bundle="oracle" />
					</div>
				</div>
			</div>
			<div class="form-group"
				data-ng-if="!sqlRestoreCtrl.isSrcSqlCloudInstance && !sqlRestoreCtrl.isSqlAnalysisServiceInstance">
				<label class="col-sm-4" for="dataFilePath">
					<cv:msg key="label.dataFilePath" bundle="sqlserver" />
				</label>
				<div class="col-sm-8">
					<div class="input-group">
						<input type="text" id="dataFilePath" name="dataFilePath"
							data-ng-model="sqlRestoreCtrl.selectedDatabase.dataFilePath"
							data-ng-required=true
							data-ng-blur="sqlRestoreCtrl.changeAllDataFilePaths(sqlRestoreCtrl.selectedDatabase.dataFilePath)"
							title="{{sqlRestoreCtrl.selectedDatabase.dataFilePath}}" />
						<span class="input-group-btn"
							data-ng-disabled="!sqlRestoreCtrl.destinationClient">
							<cv-machine-browse
								button-label='<cv:msg key="label.browse" bundle="restore"/>'
								client-id='{{sqlRestoreCtrl.destinationClient.clientId}}'
								result-function="sqlRestoreCtrl.dataFilePathResultFunction">
							</cv-machine-browse>
						</span>
					</div>
					<div class="help-block"
						data-ng-show="sqlRestoreCtrl.attempted && !sqlRestoreCtrl.selectedDatabase.dataFilePath">
						<cv:msg key="label.selectAPath" bundle="browse" />
					</div>
				</div>
			</div>
			<div class="form-group"
				data-ng-if="!sqlRestoreCtrl.isSrcSqlCloudInstance && !sqlRestoreCtrl.isSqlAnalysisServiceInstance">
				<label class="col-sm-4" for="logFilePath">
					<cv:msg key="label.logFilePath" bundle="sqlserver" />
				</label>
				<div class="col-sm-8">
					<div class="input-group">
						<input type="text" id="logFilePath" name="logFilePath"
							data-ng-model="sqlRestoreCtrl.selectedDatabase.logFilePath"
							data-ng-required=true
							data-ng-blur="sqlRestoreCtrl.changeAllLogFilePaths(sqlRestoreCtrl.selectedDatabase.logFilePath)"
							title="{{sqlRestoreCtrl.selectedDatabase.logFilePath}}" />
						<span class="input-group-btn"
							data-ng-disabled="!sqlRestoreCtrl.destinationClient">
							<cv-machine-browse
								button-label='<cv:msg key="label.browse" bundle="restore"/>'
								client-id='{{sqlRestoreCtrl.destinationClient.clientId}}'
								result-function="sqlRestoreCtrl.logFilePathResultFunction">
							</cv-machine-browse>
						</span>
					</div>
					<div class="help-block"
						data-ng-show="sqlRestoreCtrl.attempted && !sqlRestoreCtrl.selectedDatabase.logFilePath">
						<cv:msg key="label.selectAPath" bundle="browse" />
					</div>
				</div>
			</div>
			<div class="form-group modalForm-overflow-scroll data-file-grid"
				data-ng-if="!sqlRestoreCtrl.isSrcSqlCloudInstance && !sqlRestoreCtrl.isSqlAnalysisServiceInstance">
				<uib-accordion close-others="false" class="text-left">
				<div uib-accordion-group is-open="status.dataFiles">
					<uib-accordion-heading> <cv:msg
						key="label.dataFiles" bundle="sqlserver" /> <i
						class="pull-right glyphicon"
						data-ng-class="{'glyphicon-chevron-down': status.dataFiles, 'glyphicon-chevron-right': !status.dataFiles}"></i></uib-accordion-heading>
					<div>
						<cv-grid cv-grid-options="sqlRestoreCtrl.gridOptions"></cv-grid>
						
						<!--  <div data-ui-grid="exchDbSCServSelCtrl.dbServerGridOptions" data-ui-grid-edit class="grid-style users-grid"></div>
									
					</div>
				</div>
				<div uib-accordion-group is-open="status.additionalOptions">
					<uib-accordion-heading> <cv:msg
						key="label.additionalOptions" bundle="restore" /> <i
						class="pull-right glyphicon"
						data-ng-class="{'glyphicon-chevron-down': status.additionalOptions, 'glyphicon-chevron-right': !status.additionalOptions}"></i></uib-accordion-heading>
					<label class="col-xs-12 col-sm-4">
						<cv:msg key="label.recoveryTypes" bundle="sqlserver" />
					</label>
					<div class="col-xs-12 col-sm-8">
						<label>
							<input id="recovery" name="recoveryType" value="0"
								class="ng-valid ng-dirty ng-touched" type="radio"
								data-ng-model="sqlRestoreCtrl.selectedRecoveryType.value"
								data-ng-change="sqlRestoreCtrl.recoveryTypeChanged()">
							<cv:msg key="label.recovery" bundle="sqlserver" />
						</label>
					</div>
					<div class="col-xs-12 col-sm-8 col-sm-offset-4">
						<label>
							<input id="nonRecovery" name="recoveryType" value="1"
								class="ng-valid ng-dirty ng-touched" type="radio"
								data-ng-model="sqlRestoreCtrl.selectedRecoveryType.value"
								data-ng-change="sqlRestoreCtrl.recoveryTypeChanged()">
							<cv:msg key="label.nonRecovery" bundle="sqlserver" />
						</label>
					</div>
					<div class="col-xs-12 col-sm-8 col-sm-offset-4">
						<label>
							<input id="standBy" name="recoveryType" value="2"
								class="ng-valid ng-dirty ng-touched" type="radio"
								data-ng-model="sqlRestoreCtrl.selectedRecoveryType.value"
								data-ng-change="sqlRestoreCtrl.recoveryTypeChanged()">
							<cv:msg key="label.standBy" bundle="sqlserver" />
						</label>
					</div>
					<label class="col-xs-12 col-sm-4 col-sm-offset-4"
						data-ng-if="sqlRestoreCtrl.showUndoFilePath">
						<cv:msg key="label.undoFilePath" bundle="sqlserver" />
					</label>
					<div class="col-xs-12 col-sm-8"
						data-ng-if="sqlRestoreCtrl.showUndoFilePath">
						<div class="input-group">
							<input type="text" name="undoFilePath" id="undoFilePath"
								data-ng-model="sqlRestoreCtrl.undoFilePath"
								data-ng-required="true" title="{{undoFilePath}}" />
							<span class="input-group-btn"
								data-ng-disabled="!sqlRestoreCtrl.destinationClient">
								<cv-machine-browse
									button-label='<cv:msg key="label.browse" bundle="restore"/>'
									client-id='{{sqlRestoreCtrl.destinationClient.clientId}}'
									result-function="sqlRestoreCtrl.undoFilePathResultFunction">
								</cv-machine-browse>
							</span>
						</div>
						<div class="help-block"
							data-ng-show="sqlRestoreCtrl.attempted && sqlRestoreCtrl.showUndoFilePath && !sqlRestoreCtrl.undoFilePath">
							<cv:msg key="label.selectAPath" bundle="browse" />
						</div>
					</div>
				</div>
				</uib-accordion>
			</div>
			<div class="form-group"
				data-ng-if="sqlRestoreCtrl.isSqlAnalysisServiceInstance">
				<label class="col-xs-12 col-sm-4">
					<cv:msg key="label.restore" bundle="restore" />
				</label>
				<div class="col-xs-12 col-sm-8">
					<input id="allowDatabaseOverwrite" type="checkbox"
						data-ng-model="sqlRestoreCtrl.allowDatabaseOverwrite">
					<label for="allowDatabaseOverwrite" class="overwriteLabel">
						<cv:msg key="label.allowDatabaseOverwrite" bundle="sqlserver" />
					</label>
				</div>
				<div class="col-xs-12 col-sm-8  col-sm-offset-4">
					<input id="includeSecurityInformation" type="checkbox"
						data-ng-model="sqlRestoreCtrl.includeSecurityInformation"
						data-ng-change="sqlRestoreCtrl.includeSecurityInformationChanged(sqlRestoreCtrl.includeSecurityInformation)">
					<label for="includeSecurityInformation" class="overwriteLabel">
						<cv:msg key="label.includeSecurityInformation" bundle="sqlserver" />
						<select data-ng-if="sqlRestoreCtrl.includeSecurityInformation"
							id="analysisServerSecurityInfo" name="analysisServerSecurityInfo"
							data-ng-model="sqlRestoreCtrl.analysisServerSecurityInfo"
							data-ng-options="rt as rt.label for rt in sqlRestoreCtrl.analysisServerSecurityInfoOptions">
							<%-- <option value=""><cv:msg key="placeholder.selectDestinationServer" bundle="restoreJs"/></option>--%>
						</select>
					</label>
				</div>
				<div class="col-xs-12 col-sm-8 col-sm-offset-4">
					<input id="restoreRemotePartitions" type="checkbox"
						data-ng-model="sqlRestoreCtrl.restoreRemotePartitions">
					<label for="restoreRemotePartitions" class="overwriteLabel">
						<cv:msg key="label.restoreRemotePartitions" bundle="sqlserver" />
					</label>
				</div>
			</div>
			</cv-tab> <!-- TAB 3 : Restore to disk --> <cv-tab
				tabname="<cv:msg key="label.rtdRestore" bundle="restore" />"
				data-ng-selected="sqlRestoreCtrl.onTabChanged()"> <!--<cv-help-component
				help-text="<cv:msg key="label.rtdRestoreDetails" bundle="restore"/>"></cv-help-component>-->
			<div class="form-group">
				<label class="col-sm-4 margin-top-20" for="destinationClient">
					<cv:msg key="label.destinationClient" bundle="sqlserver" />
				</label>
				<div class="col-sm-8">
					<select name="destinationClient" required
						data-ng-if="!sqlRestoreCtrl.loadingInstances"
						data-ng-model="sqlRestoreCtrl.destinationClient"
						data-ng-options="ds as ds.clientName for ds in sqlRestoreCtrl.destinationClientList | orderBy:'clientName' track by ds.clientId"
						data-ng-change="sqlRestoreCtrl.destinationClientChanged(sqlRestoreCtrl.destinationClient)">
						<option value=""><cv:msg key="label.selectServer"
								bundle="ebsApp" /></option>
					</select>
					<span data-ng-if="sqlRestoreCtrl.loadingInstances">
						<cv:msg key="Loading" bundle="messages" />
					</span>
					<div class="help-block"
						data-ng-show="sqlRestoreCtrl.attempted && !sqlRestoreCtrl.destinationClient">
						<cv:msg key="label.selectServer" bundle="ebsApp" />
					</div>
				</div>
			</div>
			<div class="form-group">
				<label class="col-sm-4" for="restoreToDiskPath">
					<cv:msg key="label.path" bundle="restore" />
				</label>
				<div class="col-sm-8">
					<div class="input-group">
						<input type="text" id="restoreToDiskPath" name="restoreToDiskPath"
							data-ng-model="sqlRestoreCtrl.restoreToDiskPath"
							data-ng-required=true
							title="{{sqlRestoreCtrl.restoreToDiskPath}}" />
						<span class="input-group-btn"
							data-ng-disabled="!sqlRestoreCtrl.destinationClient">
							<cv-machine-browse
								button-label='<cv:msg key="label.browse" bundle="restore"/>'
								client-id='{{sqlRestoreCtrl.destinationClient.clientId}}'
								result-function="sqlRestoreCtrl.restoreToDiskPathFunction">
							</cv-machine-browse>
						</span>
					</div>
					<div class="help-block"
						data-ng-show="sqlRestoreCtrl.attempted && !sqlRestoreCtrl.restoreToDiskPath">
						<cv:msg key="label.selectAPath" bundle="browse" />
					</div>
				</div>
			</div>
			</cv-tab> </cv-tabset-component>
		</div>
	</div>
	<div class="modal-footer">
		<button id="sqlRestoreOptions_button_#8833" class="btn btn-default cvBusyOnAjax setup-btn--hidden" 
			type="button" data-ng-click="sqlRestoreCtrl.cancelModel()">
			<cv:msg key="Cancel" bundle="messages" />
		</button>
		<button id="sqlRestoreOptions_button_#0171" class="btn btn-primary cvBusyOnAjax" 
			data-ng-click="sqlRestoreCtrl.doRestore()">
			<cv:msg key="Submit" bundle="messages" />
		</button>
	</div>
</form>
