<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="label.granularBrowseOptions" bundle="sqlserver" />
	</h1>
</div>
<form name="provideLiveBrowseCredentialForm" autocomplete="off">
	<div class="setup-content reduced-padding-top">
		<span class="server-message {{serverMessage.type}}"
			data-ng-bind="serverMessage.message"></span>
	</div>
	<div class="panel-body">
		<div class="form-group">
			<label class="col-sm-5">
				<cv:msg key="label.DatabaseName" bundle="sqlserver" />
			</label>
			<div class="col-sm-7">
				<span data-ng-bind="rpBrowseObj.sqlAppData.sourceDatabase"></span>
			</div>
		</div>
		<br>
		<div class="form-group">
			<label class="col-sm-5">
				<cv:msg key="label.targetDbName" bundle="sqlserver" />
			</label>
			<div class="col-sm-7">
				<span data-ng-bind="rpBrowseObj.sqlAppData.mountDatabase"></span>
			</div>
		</div>
		<br>
		<div class="form-group">
			<label class="col-sm-5" for="userName">
				<cv:msg key="label.userName" bundle="servers" />
			</label>
			<div class="col-sm-7">
				<input type="text" id="userName" name="userName"
					data-ng-required=true
					data-ng-model="rpBrowseObj.userName" />
				<span class="help-block"
					data-ng-show="!rpBrowseObj.userName || rpBrowseObj.userName.length <= 0">
					<cv:msg key="error.userName" bundle="users" />
				</span>
			</div>
		</div>
		<br>
		<div class="form-group">
			<label class="col-sm-5" for="password">
				<cv:msg key="label.password" bundle="servers" />
			</label>
			<div class="col-sm-7">
				<input type="password" id="password" name="password"
					data-ng-required=true
					data-ng-model="rpBrowseObj.password"/>
				<span class="help-block"
					data-ng-show="!rpBrowseObj.password || rpBrowseObj.password.length <= 0">
					<cv:msg key="error.password" bundle="users" />
				</span>
			</div>
		</div>
		<br> <br>
	</div>
	<div class="modal-footer">
		<button id="sqlLiveBrowseCredential_button_#8354" type="button" 
			class="btn btn-default cvBusyOnAjax setup-btn--hidden"
			data-ng-click="closeModal()">
			<cv:msg key="Cancel" bundle="messages" />
		</button>
		<button id="sqlLiveBrowseCredential_button_#0583" type="submit" 
			data-ng-disabled="!rpBrowseObj.userName || rpBrowseObj.userName.length <= 0 ||
			!rpBrowseObj.password || rpBrowseObj.password.length <= 0"
			class="btn btn-primary cvBusyOnAjax"
			data-ng-click="updateLiveBrowseCredential()">
			<cv:msg key="Save" bundle="messages" />
		</button>
	</div>
</form>