<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>//also needed for displaying the toast message
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.databaseClone"></cv:cvMessages>
</script>
<div class="modal-header">
	<h1 class="modal-title">
		<cv:msg key="label.instantClone" bundle="databaseClone" />
	</h1>
</div>
<div
	class="bootstrap-wrapper form-horizontal modal-margin margin-top-20">
	<form name="restoreForm" novalidate autocomplete="off"
		class="replication-target-form " data-cv-submit="sqlInstantCloneCtrl.createRecoveryPointJob()">
		<div class="text-center">
			<span
				class="{{sqlInstantCloneCtrl.restoreOpts.serverMessage.type}} serverMessage">{{sqlInstantCloneCtrl.restoreOpts.serverMessage.message}}</span>
		</div>
		<h4>
			<cv:msg key="label.destDetails" bundle="oracle" />
		</h4>
		<cv-sql-select-dest-client-instance
			entity="sqlInstantCloneCtrl.data.entity"
			restore-opts="sqlInstantCloneCtrl.restoreOpts" usecase="clone"
			restore-operation-type="RECOVERY_POINT"
			ctrl="sqlInstantCloneCtrl.ctrl">
		</cv-sql-select-dest-client-instance>
		<div class="form-group">
			<label class="col-xs-12 col-md-5 col-lg-5 margin-top-20"
				for="destinationDatabase">
				<cv:msg key="label.destinationDatabase" bundle="saphana" />
			</label>
			<div class="col-xs-12 col-md-7 col-lg-7 margin-top-10">
				<input type="text" id="destinationDatabase"
					name="destinationDatabase"
					data-ng-model="sqlInstantCloneCtrl.restoreOpts.destinationDatabase.databaseName"
					data-ng-required=true />
				<span class="help-block"
					data-ng-show="!sqlInstantCloneCtrl.restoreOpts.destinationDatabase.databaseName && sqlInstantCloneCtrl.restoreOpts.requestAttempted">
					<cv:msg key="help.database" bundle="oracle" />
				</span>
			</div>
		</div>
		<h4 class="margin-top-20">
			<cv:msg key="label.cloneOptions" bundle="databaseClone" />
		</h4>
		<div class="form-group">
			<label class="col-xs-12 col-md-5 col-lg-5" for="rsvTPDays">
				<cv:msg key="label.cloneReservation" bundle="oracle" />
			</label>
			<div class="col-xs-12 col-md-7 col-lg-7 padding-right-0">
				<input type="number" id="rsvTPDays" min="0" name="rsvTPDays"
					class="input-number-50"
					data-ng-model="sqlInstantCloneCtrl.cloneEnv.rsvTPDays"
					data-ng-change="sqlInstantCloneCtrl.validateValue()" />
				<label for="rsvTPDays" class="inline-label padding-right-0">
					<cv:msg key="days" bundle="messagesJs" />
				</label>
			</div>
			<span class="help-block col-xs-12 margin-left-20"
				data-ng-show="cv.restoreForm.needsAttention(restoreForm.rsvTPDays) || cv.restoreForm.needsAttention(restoreForm.rsvTPHours) || sqlInstantCloneCtrl.errors.rsvTPDays">
				<cv:msg key="error.rsvTime" bundle="databaseClone" />
			</span>
		</div>
		<div class="form-group">
			<div class="col-xs-12 col-md-5 col-lg-12">
				<toggle-control id="sqlInstantClone_unconditionOverrideToggle"
					status="sqlInstantCloneCtrl.cloneEnv.unconditionOver==true?'enabled-activity':'disabled-activity'"
					data-ng-click="sqlInstantCloneCtrl.cloneEnv.unconditionOver = !sqlInstantCloneCtrl.cloneEnv.unconditionOver"
					title="<cv:msg key="label.unconditionOver" bundle="databaseClone" />">
				</toggle-control>
				<cv:msg key="label.unconditionOver" bundle="databaseClone" />
			</div>
		</div>
		<div class="form-group">
			<div class="col-xs-12 col-md-5 col-lg-12">
				<toggle-control id="sqlInstantClone_enableLogReplayToggle"
					status="sqlInstantCloneCtrl.cloneEnv.enableLogReplay==true?'enabled-activity':'disabled-activity'"
					data-ng-click="sqlInstantCloneCtrl.cloneEnv.enableLogReplay = !sqlInstantCloneCtrl.cloneEnv.enableLogReplay"
					title="<cv:msg key="label.applyLogPlay" bundle="databaseClone" />">
				</toggle-control>
				<cv:msg key="label.applyLogPlay" bundle="databaseClone" />
			</div>
		</div>
		<div class="modal-footer">
			<button id="sqlInstantClone_button_#4674" class="btn btn-default cvBusyOnAjax" type="button"
				data-ng-click="sqlInstantCloneCtrl.cancelModel()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="sqlInstantClone_button_#2926" class="btn btn-primary cvBusyOnAjax" type="submit">
				<cv:msg key="Submit" bundle="messages" />
			</button>
		</div>
	</form>
</div>
