<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>//also needed for displaying the toast message
</script>
<div>
	<div class="setup-title">
		<h1>
			<cv:msg key="label.restoreOpts" bundle="restore" />
		</h1>
	</div>
	<span class="server-message {{serverMessage.type}}"
		data-ng-bind="serverMessage.message"></span>
	<div class="setup-content">
		<form name="restoreForm" novalidate data-cv-submit="doRestore()"
			autocomplete="off">
			<div class="bootstrap-wrapper form-horizontal modal-margin">
				<div class="form-group">
					<div class="col-xs-12">
						<input id="includeAllChildTables" type="checkbox"
							data-ng-model="restoreData.restoreAllDependentTables" />
						<label for="includeAllChildTables" class="overwriteLabel">
							<cv:msg key="label.includeAllChildTables" bundle="sqlserver" />
						</label>
					</div>
				</div>
				<div class="form-group">
					<div class="col-xs-12">
						<input id="includeAllParentTables" type="checkbox"
							data-ng-model="restoreData.restoreAllParentTables" />
						<label for="includeAllParentTables" class="overwriteLabel">
							<cv:msg key="label.includeAllParentTables" bundle="sqlserver" />
						</label>
					</div>
				</div>
			<div class="form-group">
				<div class="col-xs-12 col-md-4 col-lg-4"
					for="destinationClient">
					<cv:msg key="label.destinationClient" bundle="sqlserver" />
				</div>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<span
						data-ng-bind="destinationClient.clientName">
					</span>
				</div>
			</div>
			<div class="form-group">
				<div class="col-xs-12 col-md-4 col-lg-4" for="destinationInstance">
					<cv:msg key="label.destinationInstance" bundle="sqlserver" />
				</div>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<span
						data-ng-bind="destinationInstance.instanceName"></span>
				</div>
			</div>
				<div class="form-group">
					<label class="col-xs-12 col-md-4 col-lg-4"
						for="destinationDatabase">
						<cv:msg key='label.DatabaseName' bundle='sqlserver' />
					</label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<select id="destinationDatabase" name="destinationDatabase"
							data-ng-if="!loadingDatabases" data-ng-required="true"
							data-ng-model="restoreData.destinationDatabase"
							data-ng-options="db as db.databaseName for db in databases | orderBy:'databaseName' track by db.databaseId">
							<option value="" data-ng-if="!loadingDatabases"><cv:msg key="help.database" bundle="oracle"/></option>
						</select>
						<span data-ng-if="loadingDatabases">
							<cv:msg key="Loading" bundle="messages" />
						</span>
						<span class="help-block ng-hide"
							data-ng-show="!loadingDatabases && cv.restoreForm.needsAttention(restoreForm.destinationDatabase)">
							<cv:msg key="help.database" bundle="oracle" />
						</span>
					</div>
				</div>
			</div>
			<div class="button-container">
				<button id="sqlGranularRestore_button_#3548" type="button" 
					class="btn btn-default cvBusyOnAjax setup-btn--hidden"
					data-ng-click="cancelModel()">
					<cv:msg key="Cancel" bundle="messages" />
				</button>
				<button id="sqlGranularRestore_button_#5890" class="btn btn-primary cvBusyOnAjax" type="submit"> 
					<cv:msg key="Submit" bundle="messages" />
				</button>
			</div>
		</form>
	</div>
</div>