<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.saphana"></cv:cvMessages>
	<cv:cvMessages bundle="localization.databaseClone"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-md-12">
		<h1 class="float-left">
			{{targetDatabase.name}}
		</h1>
		<span class="server-message {{serverMessage.type}}"
			data-ng-bind="serverMessage.message"></span>
		<span data-ng-if="isBrowseReady" data-ng-click="deleteClone()">
			<a class="page-action-item" href=""><cv:msg
					key="label.delete.recovery.point" bundle="exchange" /></a>
		</span>
		<span data-ng-if="isBrowseReady" data-ng-click="extendClone()">
			<a class="page-action-item" href=""><cv:msg key="label.extend"
					bundle="sqlserver" /></a>
		</span>
		<span data-ng-if="isBrowseReady" data-ng-click="browseClone()">
			<a class="page-action-item" href=""><cv:msg
					key="restore.table.button" bundle="databaseClone" /></a>
		</span>
		<!-- 		<span data-ng-if="isBrowseReady" data-ng-click="refreshClone()"> -->
		<%-- 			<a class="page-action-item" href=""><cv:msg key="action.refresh" --%>
		<%-- 					bundle="collections" /></a> --%>
		<!-- 		</span> -->
	</div>
</div>
<div class="row">
	<div class="col-md-6">
		<cv-tile-component
			data-ac-id="subscriptionsDetails-label_general-subscriptions"
			data-title='<cv:msg key="label.sourDetails" bundle="oracle"/>'
			loader="targetDatabase.name">
		<ul class="list-style-secondary">
			<li class="group">
				<span class="pageDetailColumn">
					<cv:msg key="label.server" bundle="ediscovery" />
				</span>
				<span class="pageDetailColumn">
					<a class="crop" href="#/clientDetails/{{sourceServer.clientId}}">{{sourceServer.clientName}}</a>
				</span>
			</li>
			<li class="group"><span class="pageDetailColumn"> <cv:msg
						key="label.database.instance" bundle="ediscovery" />
			</span> <span class="pageDetailColumn"> <a class="crop"
					href="#/instances/{{sourceInstance.instanceId}}?clientId={{sourceServer.clientId}}&instanceName={{sourceInstance.instanceName}}">{{sourceInstance.instanceName}}</a>
			</span></li>
			<li class="group"><span class="pageDetailColumn"> <cv:msg
						key="label.dbName" bundle="ebsApp" />
			</span> <span class="pageDetailColumn"> <a class="crop"
					href="#/{{sourceInstance.instanceId}}/sqlDatabaseDetails/{{sourceDatabase.id}}">{{sourceDatabase.name}}</a>
			</span></li>
			<li class="group">
				<span class="pageDetailColumn">
					<cv:msg key="label.version" bundle="sqlserver" />
				</span>
				<span class="pageDetailColumn">{{sourceDbVersion}}</span>
			</li>
			<li class="group">
				<span class="pageDetailColumn">
					<cv:msg key="label.size" bundle="dbs" />
				</span>
				<span class="pageDetailColumn">{{sizeOfSourceDb}}</span>
			</li>
			<li class="group">
				<span class="pageDetailColumn">
					<cv:msg key="label.databaseAsOf" bundle="databaseClone" />
				</span>
				<span class="pageDetailColumn">{{databaseAsOf}}</span>
			</li>
		</ul>
		</cv-tile-component>
	</div>
	<div class="col-md-6">
		<cv-tile-component
			data-ac-id="subscriptionsDetails-label_general-subscriptions"
			data-title='<cv:msg key="label.destDetails" bundle="oracle"/>'
			loader="targetDatabase.name">
		<ul class="list-style-secondary">
			<li class="group">
				<span class="pageDetailColumn">
					<cv:msg key="label.server" bundle="ediscovery" />
				</span>
				<span class="pageDetailColumn">
					<a class="crop" href="#/clientDetails/{{mountServer.clientId}}">{{mountServer.clientName}}</a>
				</span>
			</li>
			<li class="group">
				<span class="pageDetailColumn">
					<cv:msg key="label.database.instance" bundle="ediscovery" />
				</span>
				<span class="pageDetailColumn"> <a class="crop"
					href="#/instances/{{mountInstance.instanceId}}?clientId={{mountServer.clientId}}&instanceName={{mountInstance.instanceName}}">{{mountInstance.instanceName}}</a>
			</span>
			</li>
			<li class="group">
				<span class="pageDetailColumn">
					<cv:msg key="label.version" bundle="sqlserver" />
				</span>
				<span class="pageDetailColumn">{{destDbVersion}}</span>
			</li>
			<li class="group">
				<span class="pageDetailColumn">
					<cv:msg key="label.recovery.points.expiration.date"
						bundle="exchange" />
				</span>
				<span class="pageDetailColumn">{{expirationDate}}</span>
			</li>
			<li class="group">
				<span class="pageDetailColumn">
					<cv:msg key="label.recovery.points.status" bundle="exchange" />
				</span>
				<span class="pageDetailColumn">
					<a class="crop" href="#/jobs/{{rPoint.rpJobId}}"
						data-ng-if="!isBrowseReady">{{cloneStatus}}</a>
					<span class="crop" data-ng-if="isBrowseReady">{{cloneStatus}}</span>
				</span>
			</li>
		</ul>
		</cv-tile-component>
	</div>
</div>