<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<div class="form-group">
	<label class="col-xs-12 col-md-5 col-lg-5" for="destinationClient">
		<cv:msg key="label.destinationClient" bundle="sqlserver" />
	</label>
	<div class="col-xs-12 col-md-7 col-lg-7" data-ng-if="!dataLoading"
		data-ng-disabled="!model.destinationClientList || model.destinationClientList.length <= 0">
		<cv-isteven-single-select id-name="destinationClient"
			input-model="model.destinationClientList"
			binding-model="restoreOpts.destinationClient" track-field="clientId"
			label="clientName" tick-property="selected"
			on-change='clientChanged()'
			help-text='<cv:msg key="label.selectServer" bundle="ebsApp"/>'
			place-holder='<cv:msg key="label.selectServer" bundle="ebsApp"/>'
			required="true"> </cv-isteven-single-select>
	</div>
</div>

<div class="form-group">
	<label class="col-xs-12 col-md-5 col-lg-5" for="destinationInstance">
		<cv:msg key="label.destinationInstance" bundle="sqlserver" />
	</label>
	<div class="col-xs-12 col-md-7 col-lg-7" data-ng-if="!dataLoading"
		data-ng-disabled="!model.destinationInstanceList || model.destinationInstanceList.length <= 0">
		<cv-isteven-single-select id-name="destinationInstance"
			input-model="model.destinationInstanceList"
			binding-model="restoreOpts.destinationInstance"
			track-field="instanceId" label="instanceName"
			tick-property="selected" on-change='instanceChanged()'
			help-text='<cv:msg key="label.selectInstance" bundle="sqlserver"/>'
			place-holder='<cv:msg key="label.selectInstance" bundle="sqlserver"/>'
			required="true"> </cv-isteven-single-select>
	</div>
</div>

<div class="form-group"
	data-ng-if="usecase === 'clone' && showiSCSIServer"
	data-ng-disabled="!model.iSCSIProxyServerList || model.iSCSIProxyServerList.length <= 0">

	<label class="col-xs-12 col-md-5 col-lg-5 margin-bottom-15"
		for="accessNode" id="accessNodeLb" data-ng-if="!showAccessNodeHelp">
		<cv:msg key="label.iSCSIProxyServer" bundle="sqlserver" />
	</label>

	<label class="col-xs-12 col-md-5 col-lg-5 margin-bottom-15"
		for="accessNode" id="accessNodeLb2" data-ng-if="showAccessNodeHelp">
		<cv-help-text
			help-label="<cv:msg key="label.iSCSIProxyServer" bundle="sqlserver" />"
			help-text="'<cv:msg key="help.accessNode" bundle="databaseClone" />'"></cv-help-text>
	</label>

	<div class="col-xs-12 col-md-7 col-lg-7 margin-bottom-5"
		data-ng-if="!dataLoading">
		<cv-isteven-single-select id-name="proxyServer"
			input-model="model.iSCSIProxyServerList"
			binding-model="restoreOpts.proxyClient" track-field="clientId"
			label="clientName" tick-property="selected"
			help-text='<cv:msg key="label.selectServer" bundle="ebsApp"/>'
			place-holder='<cv:msg key="label.selectServer" bundle="ebsApp"/>'
			required="validateAccessNode"> </cv-isteven-single-select>
	</div>
</div>