<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.migrate"></cv:cvMessages>
</script>

<div>
	<form name="restoreForm" novalidate id="editCredentialForm" autocomplete="off"
		data-ng-init="ctrl.init()">
		<div class="modal-header">
			<h1 class="modal-title">
				<cv:msg key="label.impersonateUser" bundle="sqlserver" />
			</h1>
		</div>
		<div class="modal-body bootstrap-wrapper form-horizontal">
			<span class="serverMessage {{ctrl.serverMessage.type}}"
				data-ng-bind="ctrl.serverMessage.message"></span>

			<div class="form-group">
				<label class="col-xs-12 col-lg-4" for="userName">
					<cv:msg key="label.userName" bundle="servers" />
				</label>
				<div class="col-xs-12 col-lg-8">
					<input type="text" name="username"
						data-ng-model="ctrl.userAccount.userName"
						data-ng-blur="ctrl.userNameChanged()"
						placeholder='<cv:msg key="error.userName" bundle="users" />'
						required />
					<span class="help-block"
						data-ng-show="ctrl.inputAlertFlags.username && ctrl.attempted">
						<cv:msg key="error.userName" bundle="users" />
					</span>
				</div>
			</div>

			<div class="form-group">
				<label class="col-xs-12 col-lg-4" for="password">
					<cv:msg key="label.password" bundle="servers" />
				</label>
				<div class="col-xs-12 col-lg-8">
					<input type="password" name="password"
						data-ng-model="ctrl.userAccount.password"
						data-ng-blur="ctrl.passwordChanged()"
						placeholder="{{ctrl.passwordPlaceholder}}" required />

					<span class="help-block"
						data-ng-show="ctrl.inputAlertFlags.password && ctrl.attempted">
						<cv:msg key="error.password" bundle="users" />
					</span>
				</div>
			</div>

			<div class="button-container padding-top-20 padding-bottom-20">
				<button id="cloudMigrate_button_#5039" type="button"
					class="btn btn-default cvBusyOnAjax" data-ng-click="ctrl.cancel()">
					<cv:msg key="action.cancel" bundle="subscriptions" />
				</button>
				<button id="cloudMigrate_button_#5401" type="submit"
					class="btn btn-primary cvBusyOnAjax" data-ng-click="ctrl.submit()">
					<cv:msg key="action.save" bundle="subscriptions" />
				</button>
			</div>
		</div>
	</form>
</div>